/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.storage;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.sql.DataSource;
import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.libs.hikari.HikariConfig;
import me.yleoft.zHomes.libs.hikari.HikariDataSource;
import me.yleoft.zHomes.libs.zAPI.location.LocationHandler;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.storage.database_type;
import me.yleoft.zHomes.zHomes;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnection {
    public static HikariDataSource dataSource = null;
    public static database_type type = database_type.H2;
    public static Class<?> mariadbdriverClass;
    public static Class<?> mysqldriverClass;
    public static Class<?> h2driverClass;
    public static Class<?> sqlitedriverClass;
    public static ClassLoader mysqlDriverLoader;
    public static ClassLoader mariadbDriverLoader;
    public static ClassLoader h2DriverLoader;
    public static ClassLoader sqliteDriverLoader;
    public static Driver mysqlDriver;
    public static Driver mariadbDriver;
    public static Driver h2Driver;
    public static Driver sqliteDriver;

    public static void connect() {
        try {
            if (dataSource == null || dataSource.isClosed()) {
                long start = System.currentTimeMillis();
                HikariConfig config = new HikariConfig();
                if (mariadbDriver == null) {
                    mariadbDriver = (Driver)mariadbdriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (mysqlDriver == null) {
                    mysqlDriver = (Driver)mysqldriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (sqliteDriver == null) {
                    sqliteDriver = (Driver)sqlitedriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (h2Driver == null) {
                    h2Driver = (Driver)h2driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                switch (zHomes.getConfigYAML().getDatabaseType().toLowerCase()) {
                    case "mariadb": {
                        type = database_type.EXTERNAL;
                        config.setDataSource(new DirectDriverDataSource(mariadbDriver, mariadbDriverLoader, DatabaseConnection.mariadbUrl(), zHomes.getConfigYAML().getDatabaseUsername(), zHomes.getConfigYAML().getDatabasePassword()));
                        break;
                    }
                    case "mysql": {
                        type = database_type.EXTERNAL;
                        config.setDataSource(new DirectDriverDataSource(mysqlDriver, mysqlDriverLoader, DatabaseConnection.mysqlUrl(), zHomes.getConfigYAML().getDatabaseUsername(), zHomes.getConfigYAML().getDatabasePassword()));
                        break;
                    }
                    case "sqlite": {
                        type = database_type.SQLITE;
                        config.setDataSource(new DirectDriverDataSource(sqliteDriver, sqliteDriverLoader, DatabaseConnection.sqliteUrl(), null, null));
                        break;
                    }
                    default: {
                        type = database_type.H2;
                        config.setDataSource(new DirectDriverDataSource(h2Driver, h2DriverLoader, DatabaseConnection.h2Url(), null, null));
                    }
                }
                config.setMaximumPoolSize(zHomes.getConfigYAML().getDatabasePoolSize());
                dataSource = new HikariDataSource(config);
                long end = System.currentTimeMillis();
                zHomes.getInstance().getLoggerInstance().info("<yellow>HikariCP started in " + (end - start) + "ms");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up HikariCP connection pool", e);
        }
    }

    public static String mariadbUrl() {
        return "jdbc:mariadb://" + zHomes.getConfigYAML().getDatabaseHost() + ":" + zHomes.getConfigYAML().getDatabasePort() + "/" + zHomes.getConfigYAML().getDatabaseName() + "?allowPublicKeyRetrieval=" + zHomes.getConfigYAML().isDatabaseAllowPublicKeyRetrieval() + "&useSSL=" + zHomes.getConfigYAML().isDatabaseUseSSL();
    }

    public static String mysqlUrl() {
        return "jdbc:mysql://" + zHomes.getConfigYAML().getDatabaseHost() + ":" + zHomes.getConfigYAML().getDatabasePort() + "/" + zHomes.getConfigYAML().getDatabaseName() + "?allowPublicKeyRetrieval=" + zHomes.getConfigYAML().isDatabaseAllowPublicKeyRetrieval() + "&useSSL=" + zHomes.getConfigYAML().isDatabaseUseSSL();
    }

    public static String h2Url() {
        return "jdbc:h2:" + zHomes.getInstance().getDataFolder().getAbsolutePath() + "/database-h2";
    }

    public static String sqliteUrl() {
        return "jdbc:sqlite:" + zHomes.getInstance().getDataFolder().getAbsolutePath() + "/database-sqlite.db";
    }

    public static void disconnect() {
        if (dataSource != null) {
            DatabaseConnection.closePool();
        }
    }

    public static Connection getConnection() {
        try {
            if (dataSource != null) {
                return dataSource.getConnection();
            }
            DatabaseConnection.disconnect();
            DatabaseConnection.connect();
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to access database", e);
        }
    }

    public static void closePool() {
        if (dataSource != null) {
            dataSource.close();
        }
    }

    public static void migrateData(@Nullable CommandSender sender, @NotNull String type) {
        zAPI.getScheduler().runAsync(task -> {
            String op;
            switch (op = type.toLowerCase(Locale.ROOT)) {
                case "sqlitetoh2": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE, DatabaseConnection.h2Url(), DbEngine.H2);
                    break;
                }
                case "sqlitetomysql": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE, DatabaseConnection.mysqlUrl(), DbEngine.MYSQL);
                    break;
                }
                case "sqlitetomariadb": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE, DatabaseConnection.mariadbUrl(), DbEngine.MYSQL);
                    break;
                }
                case "mysqltosqlite": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.mysqlUrl(), DbEngine.MYSQL, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE);
                    break;
                }
                case "mysqltoh2": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.mysqlUrl(), DbEngine.MYSQL, DatabaseConnection.h2Url(), DbEngine.H2);
                    break;
                }
                case "mariadbtosqlite": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.mariadbUrl(), DbEngine.MYSQL, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE);
                    break;
                }
                case "mariadbtoh2": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.mariadbUrl(), DbEngine.MYSQL, DatabaseConnection.h2Url(), DbEngine.H2);
                    break;
                }
                case "h2tosqlite": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.h2Url(), DbEngine.H2, DatabaseConnection.sqliteUrl(), DbEngine.SQLITE);
                    break;
                }
                case "h2tomysql": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.h2Url(), DbEngine.H2, DatabaseConnection.mysqlUrl(), DbEngine.MYSQL);
                    break;
                }
                case "h2tomariadb": {
                    DatabaseConnection.migrateUrlToUrl(sender, DatabaseConnection.h2Url(), DbEngine.H2, DatabaseConnection.mariadbUrl(), DbEngine.MYSQL);
                    break;
                }
                case "essentials": {
                    DatabaseConnection.migrateFromEssentials(sender);
                    break;
                }
                case "sethome": {
                    DatabaseConnection.migrateFromSetHome(sender);
                    break;
                }
                case "ultimatehomes": {
                    DatabaseConnection.migrateFromUltimateHomes(sender);
                    break;
                }
                case "xhomes": {
                    DatabaseConnection.migrateFromXHomes(sender);
                    break;
                }
                case "zhome": {
                    DatabaseConnection.migrateFromZHome(sender);
                    break;
                }
                default: {
                    if (sender == null) break;
                    LanguageBuilder.sendMessage(sender, zHomes.getLanguageYAML().getMainConverterUsage());
                }
            }
        });
    }

    private static DbEngine engineFromUrl(String url) {
        String u = url.toLowerCase(Locale.ROOT);
        if (u.startsWith("jdbc:sqlite:")) {
            return DbEngine.SQLITE;
        }
        if (u.startsWith("jdbc:h2:")) {
            return DbEngine.H2;
        }
        if (u.startsWith("jdbc:mysql:") || u.startsWith("jdbc:mariadb:")) {
            return DbEngine.MYSQL;
        }
        return DbEngine.MYSQL;
    }

    private static String upsertSql(DbEngine engine) {
        String table = DatabaseEditor.databaseTable();
        return switch (engine.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "INSERT INTO " + table + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON CONFLICT(UUID, HOME) DO UPDATE SET LOCATION = excluded.LOCATION";
            case 1 -> "MERGE INTO " + table + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, ?, ?)";
            case 2 -> "INSERT INTO " + table + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)";
        };
    }

    private static String selectAllSql() {
        return "SELECT UUID, HOME, LOCATION FROM " + DatabaseEditor.databaseTable();
    }

    private static String countSql() {
        return "SELECT COUNT(*) AS total FROM " + DatabaseEditor.databaseTable();
    }

    private static void migrateUrlToUrl(@Nullable CommandSender sender, @NotNull String sourceUrl, @NotNull DbEngine sourceEngine, @NotNull String targetUrl, @NotNull DbEngine targetEngine) {
        DatabaseConnection.connect();
        String user = zHomes.getConfigYAML().getDatabaseUsername();
        String pass = zHomes.getConfigYAML().getDatabasePassword();
        boolean sourceNeedsAuth = sourceEngine == DbEngine.MYSQL;
        boolean targetNeedsAuth = targetEngine == DbEngine.MYSQL;
        try (Connection sourceConn = DatabaseConnection.openConnectionForUrl(sourceUrl, sourceNeedsAuth ? user : null, sourceNeedsAuth ? pass : null);
             Connection targetConn = DatabaseConnection.openConnectionForUrl(targetUrl, targetNeedsAuth ? user : null, targetNeedsAuth ? pass : null);){
            zHomes.getInstance().getLoggerInstance().info("<yellow>Connected to both source and target databases.");
            int totalRows = DatabaseConnection.countRows(sourceConn);
            if (totalRows <= 0) {
                zHomes.getInstance().getLoggerInstance().info("<red>No data to migrate.");
                return;
            }
            zHomes.getInstance().getLoggerInstance().info("<yellow>Starting migration of " + totalRows + " records...");
            String upsert = DatabaseConnection.upsertSql(targetEngine);
            int batchSize = 1000;
            int progressEvery = 250;
            boolean oldAutoCommit = targetConn.getAutoCommit();
            targetConn.setAutoCommit(false);
            int migrated = 0;
            try (Statement stmt = sourceConn.createStatement();
                 ResultSet rs = stmt.executeQuery(DatabaseConnection.selectAllSql());
                 PreparedStatement ps = targetConn.prepareStatement(upsert);){
                while (rs.next()) {
                    String uuid = rs.getString("UUID");
                    String home = DatabaseConnection.truncateHome(rs.getString("HOME"));
                    String location = rs.getString("LOCATION");
                    ps.setString(1, uuid);
                    ps.setString(2, home);
                    ps.setString(3, location);
                    ps.addBatch();
                    if (++migrated % 1000 == 0) {
                        ps.executeBatch();
                        targetConn.commit();
                    }
                    if (migrated % 250 != 0) continue;
                    DatabaseConnection.updateProgress(sender, migrated, totalRows);
                }
                ps.executeBatch();
                targetConn.commit();
            }
            catch (SQLException e) {
                try {
                    targetConn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    targetConn.setAutoCommit(oldAutoCommit);
                }
                catch (SQLException sQLException) {}
            }
            DatabaseConnection.completeMigration(sender, migrated, totalRows);
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Failed to migrate database", e);
        }
    }

    private static int countRows(Connection sourceConn) throws SQLException {
        try (Statement stmt = sourceConn.createStatement();){
            int n;
            block12: {
                ResultSet countResult = stmt.executeQuery(DatabaseConnection.countSql());
                try {
                    int n2 = n = countResult.next() ? countResult.getInt("total") : 0;
                    if (countResult == null) break block12;
                }
                catch (Throwable throwable) {
                    if (countResult != null) {
                        try {
                            countResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                countResult.close();
            }
            return n;
        }
    }

    private static DbEngine currentEngine() {
        DbEngine dbEngine;
        block8: {
            Connection c = DatabaseConnection.getConnection();
            try {
                String url = c.getMetaData().getURL();
                dbEngine = DatabaseConnection.engineFromUrl(url);
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return DbEngine.MYSQL;
                }
            }
            c.close();
        }
        return dbEngine;
    }

    private static String currentUpsertSql() {
        return DatabaseConnection.upsertSql(DatabaseConnection.currentEngine());
    }

    private static void migrateFromEssentials(@Nullable CommandSender sender) {
        File directory = new File(String.valueOf(zHomes.getInstance().getDataFolder()) + "/../Essentials/userdata");
        if (!directory.exists() || !directory.isDirectory()) {
            zHomes.getInstance().getLoggerInstance().error("Invalid directory: " + directory.getPath());
            return;
        }
        String sql = DatabaseConnection.currentUpsertSql();
        DatabaseConnection.migrateYamlDirectory(sender, directory, sql, YamlHomeFormat.ESSENTIALS);
    }

    private static void migrateFromSetHome(@Nullable CommandSender sender) {
        File directory = new File(String.valueOf(zHomes.getInstance().getDataFolder()) + "/../SetHome/homes");
        if (!directory.exists() || !directory.isDirectory()) {
            zHomes.getInstance().getLoggerInstance().error("Invalid directory: " + directory.getPath());
            return;
        }
        String sql = DatabaseConnection.currentUpsertSql();
        DatabaseConnection.migrateYamlDirectory(sender, directory, sql, YamlHomeFormat.SETHOME);
    }

    private static void migrateFromUltimateHomes(@Nullable CommandSender sender) {
        File directory = new File(String.valueOf(zHomes.getInstance().getDataFolder()) + "/../UltimateHomes/playerdata");
        if (!directory.exists() || !directory.isDirectory()) {
            zHomes.getInstance().getLoggerInstance().error("Invalid directory: " + directory.getPath());
            return;
        }
        String sql = DatabaseConnection.currentUpsertSql();
        DatabaseConnection.migrateYamlDirectory(sender, directory, sql, YamlHomeFormat.ULTIMATEHOMES);
    }

    private static void migrateFromZHome(@Nullable CommandSender sender) {
        File directory = new File(String.valueOf(zHomes.getInstance().getDataFolder()) + "/../zHome/homes");
        if (!directory.exists() || !directory.isDirectory()) {
            zHomes.getInstance().getLoggerInstance().error("Invalid directory: " + directory.getPath());
            return;
        }
        String sql = DatabaseConnection.currentUpsertSql();
        DatabaseConnection.migrateYamlDirectory(sender, directory, sql, YamlHomeFormat.ZHOME);
    }

    private static void migrateFromXHomes(@Nullable CommandSender sender) {
        File file = new File(String.valueOf(zHomes.getInstance().getDataFolder()) + "/../Xhomes/playerhomes.yml");
        if (!file.exists()) {
            zHomes.getInstance().getLoggerInstance().error("Invalid file: " + file.getPath());
            return;
        }
        String sql = DatabaseConnection.currentUpsertSql();
        try (Connection conn = DatabaseConnection.getConnection();){
            YamlConfiguration fYaml = YamlConfiguration.loadConfiguration((File)file);
            int totalUsers = fYaml.getKeys(false).size();
            zHomes.getInstance().getLoggerInstance().info("<yellow>Starting migration for " + totalUsers + " users...");
            boolean oldAuto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int userCount = 0;
            int homeCount = 0;
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                for (String player : fYaml.getKeys(false)) {
                    OfflinePlayer offplayer = PlayerHandler.getOfflinePlayer(player);
                    ++userCount;
                    if (offplayer == null) {
                        DatabaseConnection.updateUserProgress(sender, userCount, totalUsers, "<green>Conversion failed, skipping user...");
                        continue;
                    }
                    String uuid = offplayer.getUniqueId().toString();
                    ConfigurationSection homesSection = fYaml.getConfigurationSection(player);
                    if (homesSection == null) {
                        DatabaseConnection.updateUserProgress(sender, userCount, totalUsers, "<green>Converting Data...");
                        continue;
                    }
                    for (String homeName : homesSection.getKeys(false)) {
                        String[] homeS;
                        String homeRaw = homesSection.getString(homeName);
                        if (homeRaw == null || (homeS = homeRaw.split(",")).length != 11) continue;
                        String worldName = homeS[0];
                        double x = Double.parseDouble(homeS[1] + "." + homeS[2]);
                        double y = Double.parseDouble(homeS[3] + "." + homeS[4]);
                        double z = Double.parseDouble(homeS[5] + "." + homeS[6]);
                        float yaw = Float.parseFloat(homeS[7] + "." + homeS[8]);
                        float pitch = Float.parseFloat(homeS[9] + "." + homeS[10]);
                        String location = LocationHandler.serialize(worldName, x, y, z, yaw, pitch);
                        ps.setString(1, uuid);
                        ps.setString(2, DatabaseConnection.truncateHome(homeName));
                        ps.setString(3, location);
                        ps.addBatch();
                        ++homeCount;
                    }
                    if (userCount % 200 == 0) {
                        ps.executeBatch();
                        conn.commit();
                    }
                    DatabaseConnection.updateUserProgress(sender, userCount, totalUsers, "<green>Converting Data...");
                }
                ps.executeBatch();
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    conn.setAutoCommit(oldAuto);
                }
                catch (SQLException sQLException) {}
            }
            if (sender != null) {
                LanguageBuilder.sendMessage(sender, "<green>Converted Data! <dark_gray>[<gray>" + userCount + " users/" + totalUsers + " users<dark_gray>]");
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                }
            }
            zHomes.getInstance().getLoggerInstance().info("<green>Migration completed! " + userCount + " users and " + homeCount + " homes transferred from XHomes.");
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Unable to migrate data from XHomes", e);
        }
    }

    private static void migrateYamlDirectory(@Nullable CommandSender sender, File directory, String upsertSql, YamlHomeFormat format) {
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            LanguageBuilder.sendMessage(sender, zHomes.getLanguageYAML().getMainConverterError());
            return;
        }
        int totalUsers = files.length;
        zHomes.getInstance().getLoggerInstance().info("<yellow>Starting migration for " + totalUsers + " users...");
        try (Connection conn = DatabaseConnection.getConnection();){
            boolean oldAuto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int userCount = 0;
            int homeCount = 0;
            try (PreparedStatement ps = conn.prepareStatement(upsertSql);){
                for (File file : files) {
                    ++userCount;
                    String uuid = file.getName().replace(".yml", "");
                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                    int insertedThisUser = switch (format.ordinal()) {
                        default -> throw new IncompatibleClassChangeError();
                        case 0 -> DatabaseConnection.insertHomesFromSection(ps, uuid, yaml.getConfigurationSection("homes"), EssentialsKeys.INSTANCE);
                        case 1 -> DatabaseConnection.insertHomesFromSection(ps, uuid, yaml.getConfigurationSection("Homes"), SetHomeKeys.INSTANCE);
                        case 2 -> DatabaseConnection.insertHomesFromSection(ps, uuid, yaml.getConfigurationSection("homes"), UltimateHomesKeys.INSTANCE);
                        case 3 -> DatabaseConnection.insertHomesFromZHome(ps, uuid, yaml);
                    };
                    homeCount += insertedThisUser;
                    if (userCount % 200 == 0) {
                        ps.executeBatch();
                        conn.commit();
                    }
                    DatabaseConnection.updateUserProgress(sender, userCount, totalUsers, "<green>Converting Data...");
                }
                ps.executeBatch();
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    conn.setAutoCommit(oldAuto);
                }
                catch (SQLException sQLException) {}
            }
            if (sender != null) {
                LanguageBuilder.sendMessage(sender, "<green>Converted Data! <dark_gray>[<gray>" + userCount + " users/" + totalUsers + " users<dark_gray>]");
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                }
            }
            zHomes.getInstance().getLoggerInstance().info("<green>Migration completed! " + userCount + " users and " + homeCount + " homes transferred from " + String.valueOf((Object)format) + ".");
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Unable to migrate YAML data: " + String.valueOf((Object)format), e);
        }
    }

    private static int insertHomesFromSection(PreparedStatement ps, String uuid, @Nullable ConfigurationSection homesSection, HomeKeys keys) throws SQLException {
        if (homesSection == null) {
            return 0;
        }
        int count = 0;
        for (String homeName : homesSection.getKeys(false)) {
            ConfigurationSection home = homesSection.getConfigurationSection(homeName);
            if (home == null) continue;
            String worldName = keys.world(home);
            double x = home.getDouble("x");
            double y = home.getDouble("y");
            double z = home.getDouble("z");
            float yaw = (float)home.getDouble("yaw");
            float pitch = (float)home.getDouble("pitch");
            String location = LocationHandler.serialize(worldName, x, y, z, yaw, pitch);
            ps.setString(1, uuid);
            ps.setString(2, DatabaseConnection.truncateHome(homeName));
            ps.setString(3, location);
            ps.addBatch();
            ++count;
        }
        return count;
    }

    private static int insertHomesFromZHome(PreparedStatement ps, String uuid, YamlConfiguration yaml) throws SQLException {
        if (yaml.getKeys(false).isEmpty()) {
            return 0;
        }
        int count = 0;
        for (String homeName : yaml.getKeys(false)) {
            ConfigurationSection home = yaml.getConfigurationSection(homeName);
            if (home == null) continue;
            String worldName = home.getString("world", "");
            double x = home.getDouble("x");
            double y = home.getDouble("y");
            double z = home.getDouble("z");
            float yaw = (float)home.getDouble("yaw");
            float pitch = (float)home.getDouble("pitch");
            String location = LocationHandler.serialize(worldName, x, y, z, yaw, pitch);
            ps.setString(1, uuid);
            ps.setString(2, DatabaseConnection.truncateHome(homeName));
            ps.setString(3, location);
            ps.addBatch();
            ++count;
        }
        return count;
    }

    private static void updateUserProgress(CommandSender sender, int count, int totalUsers, String prefix) {
        if (sender != null) {
            String message = prefix + " <dark_gray>[<gray>" + count + " users/" + totalUsers + " users<dark_gray>]";
            LanguageBuilder.sendActionBar(sender, message);
        }
    }

    private static void updateProgress(CommandSender sender, int count, int totalRows) {
        if (sender != null) {
            String message = "<green>Converting Data... <dark_gray>[<gray>" + count + "/" + totalRows + "<dark_gray>]";
            LanguageBuilder.sendActionBar(sender, message);
        }
    }

    private static void completeMigration(CommandSender sender, int count, int totalRows) {
        if (sender != null) {
            String message = "<green>Converted Data! <dark_gray>[<gray>" + count + "/" + totalRows + "<dark_gray>]";
            LanguageBuilder.sendActionBar(sender, message);
            LanguageBuilder.sendMessage(sender, zHomes.getLanguageYAML().getMainConverterOutput());
            try {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        zHomes.getInstance().getLoggerInstance().info("<green>Migration completed! " + count + " records transferred.");
    }

    private static String truncateHome(String home) {
        if (home == null) {
            return "";
        }
        return home.length() <= 100 ? home : home.substring(0, 100);
    }

    private static Connection openConnectionForUrl(String jdbcUrl, String username, String password) throws SQLException {
        ClassLoader loader;
        Driver driver;
        if (jdbcUrl == null) {
            throw new SQLException("jdbcUrl is null");
        }
        String u = jdbcUrl.toLowerCase();
        if (u.startsWith("jdbc:mysql:")) {
            driver = mysqlDriver;
            loader = mysqlDriverLoader;
            if (driver == null) {
                throw new SQLException("MySQL driver is not initialized (mysqlDriver == null)");
            }
        } else if (u.startsWith("jdbc:mariadb:")) {
            driver = mariadbDriver;
            loader = mariadbDriverLoader;
            if (driver == null) {
                throw new SQLException("MariaDB driver is not initialized (mariadbDriver == null)");
            }
        } else if (u.startsWith("jdbc:h2:")) {
            driver = h2Driver;
            loader = h2DriverLoader;
            if (driver == null) {
                throw new SQLException("H2 driver is not initialized (h2Driver == null)");
            }
        } else if (u.startsWith("jdbc:sqlite:")) {
            driver = sqliteDriver;
            loader = sqliteDriverLoader;
            if (driver == null) {
                throw new SQLException("SQLite driver is not initialized (SQLite == null)");
            }
        } else {
            throw new SQLException("Unsupported JDBC url for migration: " + jdbcUrl);
        }
        DirectDriverDataSource ds = new DirectDriverDataSource(driver, loader, jdbcUrl, username, password);
        return ds.getConnection();
    }

    /*
     * Exception decompiling
     */
    public static boolean existsTableColumnValueDoubleLower(String table, String columnName, String value, String columnName2, String value2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        mysqlDriver = null;
        mariadbDriver = null;
        h2Driver = null;
        sqliteDriver = null;
    }

    public static final class DirectDriverDataSource
    implements DataSource {
        private final Driver driver;
        private final ClassLoader driverLoader;
        private final String jdbcUrl;
        private final Properties props = new Properties();
        private final AtomicReference<PrintWriter> logWriter = new AtomicReference<Object>(null);

        public DirectDriverDataSource(Driver driver, ClassLoader driverLoader, String jdbcUrl, String username, String password) {
            this.driver = driver;
            this.driverLoader = driverLoader;
            this.jdbcUrl = jdbcUrl;
            if (username != null) {
                this.props.setProperty("user", username);
            }
            if (password != null) {
                this.props.setProperty("password", password);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connectWithTccl();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.props);
            if (username != null) {
                p.setProperty("user", username);
            }
            if (password != null) {
                p.setProperty("password", password);
            }
            return this.connectWithTccl(p);
        }

        private Connection connectWithTccl() throws SQLException {
            return this.connectWithTccl(this.props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection connectWithTccl(Properties p) throws SQLException {
            ClassLoader prev = Thread.currentThread().getContextClassLoader();
            try {
                Connection c;
                if (this.driverLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.driverLoader);
                }
                if ((c = this.driver.connect(this.jdbcUrl, p)) == null) {
                    throw new SQLException("Driver returned null connection for url=" + this.jdbcUrl + " (acceptsURL=" + this.driver.acceptsURL(this.jdbcUrl) + ")");
                }
                Connection connection = c;
                return connection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(prev);
            }
        }

        @Override
        public PrintWriter getLogWriter() {
            return this.logWriter.get();
        }

        @Override
        public void setLogWriter(PrintWriter out) {
            this.logWriter.set(out);
        }

        @Override
        public void setLoginTimeout(int seconds) {
        }

        @Override
        public int getLoginTimeout() {
            return 0;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (iface.isInstance(this)) {
                return iface.cast(this);
            }
            throw new SQLException("Not a wrapper for " + iface.getName());
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return iface.isInstance(this);
        }
    }

    private static enum DbEngine {
        SQLITE,
        H2,
        MYSQL;

    }

    private static enum YamlHomeFormat {
        ESSENTIALS,
        SETHOME,
        ULTIMATEHOMES,
        ZHOME;

    }

    private static final class EssentialsKeys
    implements HomeKeys {
        static final EssentialsKeys INSTANCE = new EssentialsKeys();

        private EssentialsKeys() {
        }

        @Override
        public String world(ConfigurationSection home) {
            return home.getString("world-name", "");
        }
    }

    private static interface HomeKeys {
        public String world(ConfigurationSection var1);
    }

    private static final class SetHomeKeys
    implements HomeKeys {
        static final SetHomeKeys INSTANCE = new SetHomeKeys();

        private SetHomeKeys() {
        }

        @Override
        public String world(ConfigurationSection home) {
            return home.getString("world", "");
        }
    }

    private static final class UltimateHomesKeys
    implements HomeKeys {
        static final UltimateHomesKeys INSTANCE = new UltimateHomesKeys();

        private UltimateHomesKeys() {
        }

        @Override
        public String world(ConfigurationSection home) {
            return home.getString("world", "");
        }
    }
}

