/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderDefinition;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholdersHandler;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.libs.bstats.bukkit.Metrics;
import me.yleoft.zHomes.libs.zAPI.libs.bstats.charts.DrilldownPie;
import me.yleoft.zHomes.libs.zAPI.libs.bstats.charts.SimplePie;
import me.yleoft.zHomes.libs.zAPI.libs.folialib.FoliaLib;
import me.yleoft.zHomes.libs.zAPI.libs.folialib.impl.PlatformScheduler;
import me.yleoft.zHomes.libs.zAPI.listeners.DupeFixerListeners;
import me.yleoft.zHomes.libs.zAPI.listeners.ItemListeners;
import me.yleoft.zHomes.libs.zAPI.listeners.PlayerListeners;
import me.yleoft.zHomes.libs.zAPI.logging.FileLogger;
import me.yleoft.zHomes.libs.zAPI.logging.Logger;
import me.yleoft.zHomes.libs.zAPI.utility.PluginYAML;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class zAPI {
    private static String VERSION;
    private static JavaPlugin plugin;
    private static FoliaLib foliaLib;
    private static Logger logger;
    private static Logger pluginLogger;
    private static PlaceholdersHandler placeholdersHandler;
    private static final MiniMessage miniMessage;
    public static boolean useNBTAPI;

    public static void setPlugin(@NotNull JavaPlugin plugin) {
        if (zAPI.plugin == null) {
            zAPI.plugin = plugin;
        }
    }

    public static void preload(@NotNull JavaPlugin plugin, boolean loadHooks) {
        zAPI.setPlugin(plugin);
        if (logger == null) {
            logger = new Logger("[zAPI]");
        }
        if (foliaLib == null) {
            foliaLib = new FoliaLib((Plugin)plugin);
        }
        if (loadHooks) {
            HookRegistry.preload();
        }
    }

    public static void preload(@NotNull JavaPlugin plugin) {
        zAPI.preload(plugin, true);
    }

    public static void init(@NotNull JavaPlugin plugin, boolean useNBTAPI) {
        if (zAPI.plugin != null && zAPI.plugin != plugin) {
            throw new IllegalStateException("zAPI has already been initialized with a different plugin!");
        }
        zAPI.preload(plugin, false);
        logger.setDebugMode(false);
        zAPI.useNBTAPI = useNBTAPI;
        PluginYAML.registerEvent(new PlayerListeners());
        if (useNBTAPI) {
            PluginYAML.registerEvent(new DupeFixerListeners());
            PluginYAML.registerEvent(new ItemListeners());
        }
        logger.info("Initialized zAPI v" + VERSION + " using " + plugin.getName() + " v" + Version.getVersion());
        logger.info("Version found: " + Bukkit.getServer().getName() + " " + Bukkit.getServer().getBukkitVersion() + " | APIv " + Version.CURRENT_VERSION);
        try {
            logger.info("Using the plugin '" + Version.getName() + " v" + Version.getVersion() + "' to create a bStats instance!");
            Metrics metrics = zAPI.startMetrics(26888);
            metrics.addCustomChart(new DrilldownPie("parent_plugin", () -> {
                HashMap data = new HashMap();
                String pluginVersion = Version.getVersion();
                HashMap<String, Integer> subCategory = new HashMap<String, Integer>();
                subCategory.put(pluginVersion, 1);
                data.put(Version.getName(), subCategory);
                return data;
            }));
            metrics.addCustomChart(new SimplePie("zapi_version", () -> VERSION));
            metrics.addCustomChart(new SimplePie("use_nbtapi", () -> useNBTAPI ? "Yes" : "No"));
        }
        catch (Exception exception) {
            logger.warn("Failed to create a bStats instance.", exception);
        }
    }

    public static void init(@NotNull JavaPlugin plugin) {
        zAPI.init(plugin, false);
    }

    public static void disable() {
        if (plugin != null) {
            HookRegistry.unload();
            HookRegistry.clearHooks();
            zAPI.getScheduler().cancelAllTasks();
            HandlerList.unregisterAll((Plugin)plugin);
            PluginYAML.unregisterPermissions();
            PluginYAML.unregisterCommands();
        }
        FileLogger.compressLogs();
        plugin = null;
        logger = null;
        pluginLogger = null;
        placeholdersHandler = null;
        foliaLib = null;
    }

    @NotNull
    public static JavaPlugin getPlugin() {
        return plugin;
    }

    @NotNull
    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    @NotNull
    public static PlatformScheduler getScheduler() {
        return foliaLib.getScheduler();
    }

    @NotNull
    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    @NotNull
    public static Logger getLogger() {
        return logger;
    }

    public static Logger getPluginLogger() {
        return pluginLogger != null ? pluginLogger : logger;
    }

    public static PlaceholdersHandler getPlaceholdersHandler() {
        return placeholdersHandler;
    }

    public static void setPluginLogger(Logger logger) {
        pluginLogger = logger;
    }

    public static void setPlaceholdersHandler(@NotNull PlaceholdersHandler handler) {
        zAPI.getLogger().debug("Setting custom PlaceholderAPIHandler: " + handler.getClass().getName());
        HookRegistry.PAPI.registerPlaceholderExpansion(handler);
        HookRegistry.MINI_PLACEHOLDERS.registerPlaceholderExpansion(handler);
        placeholdersHandler = handler;
    }

    @NotNull
    public static Metrics startMetrics(int pluginId) {
        return new Metrics((Plugin)plugin, pluginId);
    }

    static {
        YamlConfiguration settings = new YamlConfiguration();
        String defaultVersion = "1.0.0";
        try (InputStream in = zAPI.class.getClassLoader().getResourceAsStream("settings.yml");){
            if (in != null) {
                settings.load((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                VERSION = settings.getString("version", defaultVersion);
            } else {
                VERSION = defaultVersion;
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            VERSION = defaultVersion;
        }
        placeholdersHandler = new PlaceholdersHandler(){

            @Override
            @NotNull
            public String getIdentifier() {
                return "";
            }

            @Override
            @NotNull
            public List<PlaceholderDefinition> getPlaceholders() {
                return List.of();
            }

            @Override
            @Nullable
            public String onPlaceholderRequest(@Nullable OfflinePlayer player, @NotNull String key, @NotNull List<String> parameters) {
                return "";
            }
        };
        miniMessage = MiniMessage.miniMessage();
        useNBTAPI = false;
    }
}

