/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.skull;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.libs.zAPI.skull.SkullBuilder;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class HeadProvider {
    private static final Map<String, ItemStack> cacheName = new ConcurrentHashMap<String, ItemStack>();
    private static final Map<String, ItemStack> cacheBase64 = new ConcurrentHashMap<String, ItemStack>();

    public static ItemStack getPlayerHeadFromString(@NotNull String type, @NotNull String value) {
        switch (type) {
            case "head": {
                if (value.startsWith("http://") || value.startsWith("https://")) {
                    return HeadProvider.getPlayerHeadFromString("urlhead", value);
                }
                if (value.length() >= 32) {
                    return HeadProvider.getPlayerHeadFromString("base64head", value);
                }
                return HeadProvider.getPlayerHeadFromString("namehead", value);
            }
            case "namehead": {
                return HeadProvider.getPlayerHead(value);
            }
            case "base64head": {
                return HeadProvider.getPlayerHeadB64(value);
            }
            case "urlhead": {
                String encoded = SkullBuilder.getEncoded(value);
                return HeadProvider.getPlayerHeadB64(encoded);
            }
        }
        return SkullBuilder.originalHead.clone();
    }

    public static ItemStack getPlayerHead(@NotNull String playerName) {
        try {
            return cacheName.computeIfAbsent(playerName, SkullBuilder::getSkullByName).clone();
        }
        catch (Exception exception) {
            zAPI.getLogger().warn("Failed to get head for player: " + playerName, exception);
            return SkullBuilder.originalHead.clone();
        }
    }

    public static ItemStack getPlayerHeadB64(@NotNull String base64Url) {
        try {
            return cacheBase64.computeIfAbsent(base64Url, SkullBuilder::getSkullByBase64EncodedTextureUrl).clone();
        }
        catch (Exception exception) {
            zAPI.getLogger().warn("Failed to get head for base64: " + base64Url, exception);
            return SkullBuilder.originalHead.clone();
        }
    }
}

