/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.logging;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.plugin.java.JavaPlugin;

public class Logger {
    private static final JavaPlugin plugin = zAPI.getPlugin();
    private boolean debugMode = false;
    private Component prefix;

    public Logger(String prefix) {
        this.setPrefix(prefix);
    }

    public Logger(Component prefix) {
        this.setPrefix(prefix);
    }

    public Logger() {
    }

    public void info(String message) {
        this.logMultiline(message, line -> plugin.getComponentLogger().info(line));
    }

    public void warn(String message) {
        this.logMultiline(message, line -> plugin.getComponentLogger().warn(line));
    }

    public void warn(String message, Throwable throwable) {
        this.logMultilineThrowable(message, throwable, line -> plugin.getComponentLogger().warn(line), (line, t) -> plugin.getComponentLogger().warn(line, t));
    }

    public void error(String message) {
        this.logMultiline(message, line -> plugin.getComponentLogger().error(line));
    }

    public void error(String message, Throwable throwable) {
        this.logMultilineThrowable(message, throwable, line -> plugin.getComponentLogger().error(line), (line, t) -> plugin.getComponentLogger().error(line, t));
    }

    public void debug(String message) {
        if (!this.debugMode) {
            return;
        }
        this.logMultiline(message, line -> plugin.getComponentLogger().info(line));
    }

    public void debug(String message, Throwable throwable) {
        if (!this.debugMode) {
            return;
        }
        this.logMultilineThrowable(message, throwable, line -> plugin.getComponentLogger().info(line), (line, t) -> plugin.getComponentLogger().info(line, t));
    }

    public void trace(String message) {
        this.logMultiline(message, line -> plugin.getComponentLogger().trace(line));
    }

    public void trace(String message, Throwable throwable) {
        this.logMultilineThrowable(message, throwable, line -> plugin.getComponentLogger().trace(line), (line, t) -> plugin.getComponentLogger().trace(line, t));
    }

    public void setPrefix(Component prefix) {
        this.prefix = prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = TextFormatter.transform(prefix);
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private void logMultiline(String message, Consumer<Component> sink) {
        String[] lines;
        if (message == null) {
            return;
        }
        for (String line : lines = Logger.splitLinesTrimOuterBlanks(message)) {
            sink.accept(this.formatTransform(line));
        }
    }

    private void logMultilineThrowable(String message, Throwable throwable, Consumer<Component> sinkNoThrowable, BiConsumer<Component, Throwable> sinkWithThrowable) {
        if (message == null) {
            return;
        }
        String[] lines = Logger.splitLinesTrimOuterBlanks(message);
        boolean includeThrowable = this.debugMode && throwable != null;
        for (int i = 0; i < lines.length; ++i) {
            Component formatted = this.formatTransform(lines[i]);
            if (includeThrowable && i == lines.length - 1) {
                sinkWithThrowable.accept(formatted, throwable);
                continue;
            }
            sinkNoThrowable.accept(formatted);
        }
    }

    private static String[] splitLinesTrimOuterBlanks(String message) {
        int end;
        int start;
        String normalized = message.stripTrailing();
        String[] lines = normalized.split("\\R", -1);
        for (start = 0; start < lines.length && lines[start].isEmpty(); ++start) {
        }
        for (end = lines.length; end > start && lines[end - 1].isEmpty(); --end) {
        }
        return Arrays.copyOfRange(lines, start, end);
    }

    private Component formatTransform(String message) {
        return TextFormatter.transform(this.format(message));
    }

    private String format(String message) {
        return this.getPrefix() == null ? message : (String)zAPI.getMiniMessage().serialize(this.getPrefix()) + " " + message;
    }
}

