/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.logging.FileLogger;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.jetbrains.annotations.NotNull;

public abstract class LogManager {
    private static final List<CustomLog> logFiles = new ArrayList<CustomLog>();
    private static final File logFolder = new File(zAPI.getPlugin().getDataFolder(), "logs");

    public static List<FileLogger> getFiles() {
        ArrayList<FileLogger> lus = new ArrayList<FileLogger>();
        logFiles.forEach(cl -> lus.add(cl.getLu()));
        return lus;
    }

    public static FileLogger createFile(@NotNull String name) {
        for (CustomLog cl : logFiles) {
            if (!cl.getName().equals(name)) continue;
            return cl.getLu();
        }
        CustomLog cl = new CustomLog(name);
        logFiles.add(cl);
        return cl.getLu();
    }

    public static FileLogger getLogUtil(@NotNull String name) {
        for (CustomLog cl : logFiles) {
            if (!cl.getName().equals(name)) continue;
            return cl.getLu();
        }
        throw new IllegalArgumentException("Unable to find log file: " + name);
    }

    public static File getFile(@NotNull String name) {
        return LogManager.getLogUtil(name).getLogFile();
    }

    public static File getLogFolder() {
        return logFolder;
    }

    static {
        logFolder.mkdirs();
    }

    private static class CustomLog {
        private final FileLogger lu;
        private final String name;

        public CustomLog(@NotNull String name) {
            this.lu = new FileLogger(logFolder, name);
            this.name = name;
        }

        public File getFile() {
            return this.lu.getLogFile();
        }

        public FileLogger getLu() {
            return this.lu;
        }

        public String getName() {
            return this.name;
        }
    }
}

