/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.listeners;

import java.util.Locale;
import me.yleoft.zHomes.libs.zAPI.configuration.Messages;
import me.yleoft.zHomes.libs.zAPI.utility.PluginYAML;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class PlayerListeners
implements Listener {
    @EventHandler
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String commandString = event.getMessage();
        String command = commandString.split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)command);
        if (pluginCommand == null) {
            return;
        }
        if (PluginYAML.getCmds().containsKey(pluginCommand)) {
            String bypassPermission;
            me.yleoft.zHomes.libs.zAPI.command.Command commandInstance = PluginYAML.getCommandInstance((Command)pluginCommand);
            if (commandInstance != null && (bypassPermission = commandInstance.bypassCooldownPermission()) != null && !bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (PluginYAML.cacheCooldown.containsKey(player)) {
                long cooldown = PluginYAML.cacheCooldown.get(player);
                if (currentTime >= cooldown) {
                    PluginYAML.cacheCooldown.remove(player);
                } else {
                    event.setCancelled(true);
                    double seconds = (double)(cooldown - currentTime) / 1000.0;
                    player.sendMessage(TextFormatter.transform((OfflinePlayer)player, Messages.getCooldownMessage(seconds)));
                }
            }
            if (!PluginYAML.cacheCooldown.containsKey(player)) {
                double cooldown = PluginYAML.getCmds().get(pluginCommand);
                if (cooldown == 0.0) {
                    return;
                }
                long cooldownInMills = (long)(cooldown * 1000.0);
                PluginYAML.cacheCooldown.put(player, currentTime + cooldownInMills);
            }
        }
    }
}

