/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.yleoft.zHomes.libs.nbtapi.NBT;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NbtHandler {
    public static final String mark = "zAPI:" + Version.getName() + "-unpickable";
    public static final String customCommandNBT = "zAPI:" + Version.getName() + "-customCommand";

    public static void markItem(@NotNull ItemStack item, @NotNull String mark, boolean value) {
        NBT.modify(item, nbt -> nbt.setBoolean(mark, value));
    }

    public static void markItem(@NotNull ItemStack item, @NotNull String mark) {
        NbtHandler.markItem(item, mark, true);
    }

    public static void unmarkItem(@NotNull ItemStack item, @NotNull String mark) {
        NBT.modify(item, nbt -> nbt.setBoolean(mark, false));
    }

    public static void removeMark(@NotNull ItemStack item, @NotNull String mark) {
        NBT.modify(item, nbt -> nbt.removeKey(mark));
    }

    public static boolean isMarked(@NotNull ItemStack item, @NotNull String mark) {
        return NBT.get(item, nbt -> {
            if (!nbt.hasTag(mark)) {
                return false;
            }
            return nbt.getBoolean(mark);
        });
    }

    public static boolean hasMark(@NotNull ItemStack item, @NotNull String mark) {
        return NBT.get(item, nbt -> nbt.hasTag(mark));
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command, @Nullable Map<String, String> replaces, boolean isConsole) {
        NBT.modify(item, nbt -> {
            Object customCommand = command;
            if (replaces != null) {
                for (String key : replaces.keySet()) {
                    customCommand = ((String)customCommand).replace(key, (CharSequence)replaces.get(key));
                }
            }
            if (isConsole) {
                customCommand = "[CON]" + (String)customCommand;
            }
            if (nbt.hasTag(customCommandNBT)) {
                if (nbt.getString(customCommandNBT).contains((CharSequence)customCommand)) {
                    return;
                }
                customCommand = nbt.getString(customCommandNBT) + "||" + (String)customCommand;
            }
            nbt.setString(customCommandNBT, (String)customCommand);
        });
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, @Nullable Map<String, String> replaces, boolean isConsole) {
        for (String command : commands) {
            NbtHandler.addCustomCommand(item, command, replaces, isConsole);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, boolean isConsole) {
        for (String command : commands) {
            NbtHandler.addCustomCommand(item, command, null, isConsole);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands) {
        for (String command : commands) {
            NbtHandler.addCustomCommand(item, command);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, @Nullable Map<String, String> replaces) {
        for (String command : commands) {
            NbtHandler.addCustomCommand(item, command, replaces);
        }
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command, @Nullable Map<String, String> replaces) {
        NbtHandler.addCustomCommand(item, command, replaces, false);
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command) {
        NbtHandler.addCustomCommand(item, command, null);
    }

    public static void removeCustomCommand(@NotNull ItemStack item, @NotNull String command) {
        NBT.modify(item, nbt -> {
            String customCommand = nbt.getString(customCommandNBT);
            if (customCommand.equals(command)) {
                nbt.removeKey(customCommandNBT);
            }
            if (customCommand.contains("||") || customCommand.contains(command)) {
                if (customCommand.contains(command + "||")) {
                    customCommand = customCommand.replace(command + "||", "");
                }
                if (customCommand.contains("||" + command)) {
                    customCommand = customCommand.replace("||" + command, "");
                }
                nbt.setString(customCommandNBT, customCommand);
            }
        });
    }

    public static void removeCustomCommands(@NotNull ItemStack item) {
        NBT.modify(item, nbt -> nbt.removeKey(customCommandNBT));
    }

    public static List<String> getCustomCommands(@NotNull ItemStack item) {
        return NBT.get(item, nbt -> {
            ArrayList<Object> commands = new ArrayList();
            if (nbt.hasTag(customCommandNBT)) {
                commands = new ArrayList<String>(Arrays.asList(nbt.getString(customCommandNBT).split("\\|\\|")));
            }
            return commands;
        });
    }

    public static void cleanInventory(@NotNull Player player, @NotNull String mark) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !NbtHandler.isMarked(item, mark)) continue;
            player.getInventory().remove(item);
        }
    }
}

