/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.yleoft.zHomes.libs.zAPI.configuration.Path;
import me.yleoft.zHomes.libs.zAPI.item.NbtHandler;
import me.yleoft.zHomes.libs.zAPI.skull.HeadProvider;
import me.yleoft.zHomes.libs.zAPI.utility.MathExpressionEvaluator;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemBuilder {
    public static final String KEY_MATERIAL = "material";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_NAME = "name";
    public static final String KEY_LORE = "lore";
    public static final String KEY_ENCHANTMENTS = "enchantments";
    public static final String KEY_UNBREAKABLE = "unbreakable";
    public static final String KEY_ITEM_FLAGS = "itemflags";
    public static final String KEY_PICKABLE = "pickable";
    public static final String KEY_COMMANDS = "commands";
    public static final String KEY_DISPLAY_CONDITION = "display-condition";
    public static final String KEY_PLACEHOLDERS = "placeholders";

    @NotNull
    public static ItemStack createItem(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> placeholders) {
        Map<String, String> parsedPlaceholders = ItemBuilder.parsePlaceholderDefinitions(player, config, Path.formPath(path, KEY_PLACEHOLDERS), placeholders);
        Map<String, String> finalPlaceholders = ItemBuilder.mergePlaceholders(placeholders, parsedPlaceholders);
        Material material = ItemBuilder.loadMaterial(player, config, Path.formPath(path, KEY_MATERIAL), finalPlaceholders);
        int amount = config.getInt(Path.formPath(path, KEY_AMOUNT), 1);
        ItemStack item = ItemBuilder.createItemFromMaterial(player, material.name(), amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ItemBuilder.applyName(meta, player, config, Path.formPath(path, KEY_NAME), finalPlaceholders);
            ItemBuilder.applyLore(meta, player, config, Path.formPath(path, KEY_LORE), finalPlaceholders);
            ItemBuilder.applyEnchantments(meta, player, config, Path.formPath(path, KEY_ENCHANTMENTS));
            ItemBuilder.applyUnbreakable(meta, config, Path.formPath(path, KEY_UNBREAKABLE));
            ItemBuilder.applyItemFlags(meta, player, config, Path.formPath(path, KEY_ITEM_FLAGS));
            item.setItemMeta(meta);
        }
        ItemBuilder.applyPickable(item, config, Path.formPath(path, KEY_PICKABLE));
        ItemBuilder.applyCommands(item, player, config, Path.formPath(path, KEY_COMMANDS), finalPlaceholders);
        return item;
    }

    @NotNull
    public static ItemStack createItem(@Nullable Player player, @NotNull YamlConfiguration config, @NotNull String path) {
        return ItemBuilder.createItem((OfflinePlayer)player, config, path, null);
    }

    @NotNull
    private static Material loadMaterial(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> placeholders) {
        List materials;
        if (!config.contains(path)) {
            return Material.STONE;
        }
        String materialString = config.isList(path) ? ((materials = config.getStringList(path)).isEmpty() ? "STONE" : (String)materials.get(new Random().nextInt(materials.size()))) : config.getString(path, "STONE");
        materialString = ItemBuilder.applyPlaceholders(player, materialString, placeholders);
        return ItemBuilder.parseMaterial(materialString);
    }

    @NotNull
    private static Material loadMaterial(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path) {
        return ItemBuilder.loadMaterial(player, config, path, null);
    }

    @NotNull
    public static Material parseMaterial(@NotNull String materialString) {
        if (materialString.startsWith("head-") || materialString.startsWith("base64head-") || materialString.startsWith("namehead-") || materialString.startsWith("urlhead-")) {
            return Material.PLAYER_HEAD;
        }
        Material material = Material.getMaterial((String)materialString.toUpperCase());
        return material != null ? material : Material.STONE;
    }

    @NotNull
    public static ItemStack createItemFromMaterial(@Nullable OfflinePlayer player, @NotNull String materialString, int amount) {
        if (materialString.startsWith("head-") || materialString.startsWith("base64head-") || materialString.startsWith("namehead-") || materialString.startsWith("urlhead-")) {
            String[] split = materialString.split("-", 2);
            String value = TextFormatter.applyPlaceholders(player, split[1]);
            ItemStack head = HeadProvider.getPlayerHeadFromString(split[0], value);
            head.setAmount(amount);
            return head;
        }
        Material material = ItemBuilder.parseMaterial(materialString);
        return new ItemStack(material, amount);
    }

    private static void applyName(@NotNull ItemMeta meta, @Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> placeholders) {
        if (!config.contains(path)) {
            return;
        }
        String nameString = config.getString(path);
        if (nameString != null) {
            nameString = ItemBuilder.applyPlaceholders(player, nameString, placeholders);
            meta.itemName(TextFormatter.transform(player, nameString));
        }
    }

    private static void applyLore(@NotNull ItemMeta meta, @Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> placeholders) {
        if (!config.contains(path)) {
            return;
        }
        List<String> loreStrings = config.isList(path) ? config.getStringList(path) : Collections.singletonList(config.getString(path, ""));
        List lore = loreStrings.stream().map(line -> ItemBuilder.applyPlaceholders(player, line, placeholders)).map(line -> TextFormatter.transform(player, line)).map(ItemBuilder::disableDefaultItalics).collect(Collectors.toList());
        meta.lore(lore);
    }

    private static void applyEnchantments(@NotNull ItemMeta meta, @Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path) {
        List<String> enchantmentStrings = ItemBuilder.getConfigList(config, path);
        for (String enchantStr : enchantmentStrings) {
            String enchantName;
            Enchantment enchantment;
            String[] parts = (enchantStr = TextFormatter.applyPlaceholders(player, enchantStr)).split(":");
            if (parts.length != 2 || (enchantment = Enchantment.getByName((String)(enchantName = parts[0].toUpperCase()))) == null || !ItemBuilder.isInteger(parts[1])) continue;
            int level = Integer.parseInt(parts[1].trim());
            meta.addEnchant(enchantment, level, true);
        }
    }

    private static void applyUnbreakable(@NotNull ItemMeta meta, @NotNull YamlConfiguration config, @NotNull String path) {
        if (config.contains(path)) {
            meta.setUnbreakable(config.getBoolean(path));
        }
    }

    private static void applyItemFlags(@NotNull ItemMeta meta, @Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path) {
        List<String> flagStrings = ItemBuilder.getConfigList(config, path);
        for (String flagStr : flagStrings) {
            flagStr = TextFormatter.applyPlaceholders(player, flagStr);
            try {
                ItemFlag flag = ItemFlag.valueOf((String)flagStr.toUpperCase());
                meta.addItemFlags(new ItemFlag[]{flag});
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private static void applyPickable(@NotNull ItemStack item, @NotNull YamlConfiguration config, @NotNull String path) {
        boolean pickable = config.getBoolean(path, false);
        NbtHandler.markItem(item, NbtHandler.mark, !pickable);
    }

    private static void applyCommands(@NotNull ItemStack item, @Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> placeholders) {
        List<String> commands = ItemBuilder.getConfigList(config, path);
        if (commands.isEmpty()) {
            return;
        }
        List<String> processedCommands = commands.stream().map(cmd -> ItemBuilder.applyPlaceholders(player, cmd, placeholders)).collect(Collectors.toList());
        NbtHandler.addCustomCommands(item, processedCommands);
    }

    public static void registerNativePlaceholders() {
    }

    @NotNull
    private static String applyPlaceholders(@Nullable OfflinePlayer player, @NotNull String text, @Nullable Map<String, String> placeholders) {
        String result = text;
        if (placeholders != null && !placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result = result.replace(key, value);
                if (!key.startsWith("%") || !key.endsWith("%")) continue;
                String miniKey = "<" + key.substring(1, key.length() - 1) + ">";
                result = result.replace(miniKey, value);
            }
        }
        result = ItemBuilder.evaluateMathExpressions(result);
        result = TextFormatter.applyPlaceholders(player, result);
        return result;
    }

    @NotNull
    public static String applyPlaceholdersPublic(@Nullable OfflinePlayer player, @NotNull String text, @Nullable Map<String, String> placeholders) {
        return ItemBuilder.applyPlaceholders(player, text, placeholders);
    }

    @NotNull
    private static String evaluateMathExpressions(@NotNull String text) {
        Pattern pattern = Pattern.compile("\\{math:\\s*([^}]+)\\}");
        Matcher matcher = pattern.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String expression = matcher.group(1).trim();
            try {
                double value = MathExpressionEvaluator.evaluate(expression);
                String replacement = ItemBuilder.formatMathResult(value);
                matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
            }
            catch (Exception e) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group(0)));
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @NotNull
    private static String formatMathResult(double value) {
        if (value == Math.floor(value) && !Double.isInfinite(value)) {
            return String.valueOf((long)value);
        }
        String formatted = String.format("%.2f", value);
        if (formatted.contains(".")) {
            formatted = formatted.replaceAll("0*$", "").replaceAll("\\.$", "");
        }
        return formatted;
    }

    @NotNull
    public static Map<String, String> createSlotPlaceholders(@Nullable OfflinePlayer player, int slot, int itemIndex) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%slot%", String.valueOf(slot));
        placeholders.put("%currentitem%", String.valueOf(itemIndex));
        placeholders.put("%player%", player != null ? player.getName() : "");
        placeholders.put("%online%", String.valueOf(Bukkit.getOnlinePlayers().size()));
        placeholders.put("%uuid%", player != null ? player.getUniqueId().toString() : "");
        if (player != null && player.isOnline() && player instanceof Player) {
            placeholders.put("%world%", ((Player)player).getWorld().getName());
        } else {
            placeholders.put("%world%", "");
        }
        return placeholders;
    }

    @NotNull
    public static Map<String, String> mergePlaceholders(Map<String, String> ... maps) {
        HashMap<String, String> merged = new HashMap<String, String>();
        for (Map<String, String> map : maps) {
            if (map == null) continue;
            merged.putAll(map);
        }
        return merged;
    }

    @NotNull
    public static Map<String, String> parsePlaceholderDefinitions(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable Map<String, String> basePlaceholders) {
        HashMap<String, String> parsedPlaceholders = new HashMap<String, String>();
        if (!config.contains(path) || !config.isConfigurationSection(path)) {
            return parsedPlaceholders;
        }
        ConfigurationSection placeholdersSection = config.getConfigurationSection(path);
        if (placeholdersSection == null) {
            return parsedPlaceholders;
        }
        for (String key : placeholdersSection.getKeys(false)) {
            String value = placeholdersSection.getString(key);
            if (value == null) continue;
            Object placeholderKey = key.startsWith("%") ? key : "%" + key + "%";
            String parsedValue = ItemBuilder.applyPlaceholders(player, value, basePlaceholders);
            parsedPlaceholders.put((String)placeholderKey, parsedValue);
        }
        return parsedPlaceholders;
    }

    public static boolean evaluateDisplayCondition(@Nullable OfflinePlayer player, @NotNull String condition, @Nullable Map<String, String> placeholders) {
        String processed = ItemBuilder.applyPlaceholders(player, condition, placeholders);
        int notEqualsIndex = ItemBuilder.findOperatorIndex(processed, "!=");
        if (notEqualsIndex != -1) {
            String rightEvaluated;
            String left = processed.substring(0, notEqualsIndex).trim();
            String right = processed.substring(notEqualsIndex + 2).trim();
            String leftEvaluated = ItemBuilder.evaluateMathIfNeeded(left);
            return !leftEvaluated.equals(rightEvaluated = ItemBuilder.evaluateMathIfNeeded(right));
        }
        int equalsIndex = ItemBuilder.findOperatorIndex(processed, "==");
        if (equalsIndex != -1) {
            String left = processed.substring(0, equalsIndex).trim();
            String right = processed.substring(equalsIndex + 2).trim();
            String leftEvaluated = ItemBuilder.evaluateMathIfNeeded(left);
            String rightEvaluated = ItemBuilder.evaluateMathIfNeeded(right);
            return leftEvaluated.equals(rightEvaluated);
        }
        int greaterEqualsIndex = ItemBuilder.findOperatorIndex(processed, ">=");
        if (greaterEqualsIndex != -1) {
            double rightValue;
            String left = processed.substring(0, greaterEqualsIndex).trim();
            String right = processed.substring(greaterEqualsIndex + 2).trim();
            double leftValue = ItemBuilder.evaluateMathExpression(left);
            return leftValue >= (rightValue = ItemBuilder.evaluateMathExpression(right));
        }
        int lessEqualsIndex = ItemBuilder.findOperatorIndex(processed, "<=");
        if (lessEqualsIndex != -1) {
            double rightValue;
            String left = processed.substring(0, lessEqualsIndex).trim();
            String right = processed.substring(lessEqualsIndex + 2).trim();
            double leftValue = ItemBuilder.evaluateMathExpression(left);
            return leftValue <= (rightValue = ItemBuilder.evaluateMathExpression(right));
        }
        int greaterIndex = ItemBuilder.findOperatorIndex(processed, ">");
        if (greaterIndex != -1 && !ItemBuilder.isPartOfTwoCharOperator(processed, greaterIndex, '>')) {
            double rightValue;
            String left = processed.substring(0, greaterIndex).trim();
            String right = processed.substring(greaterIndex + 1).trim();
            double leftValue = ItemBuilder.evaluateMathExpression(left);
            return leftValue > (rightValue = ItemBuilder.evaluateMathExpression(right));
        }
        int lessIndex = ItemBuilder.findOperatorIndex(processed, "<");
        if (lessIndex != -1 && !ItemBuilder.isPartOfTwoCharOperator(processed, lessIndex, '<')) {
            double rightValue;
            String left = processed.substring(0, lessIndex).trim();
            String right = processed.substring(lessIndex + 1).trim();
            double leftValue = ItemBuilder.evaluateMathExpression(left);
            return leftValue < (rightValue = ItemBuilder.evaluateMathExpression(right));
        }
        return false;
    }

    private static double evaluateMathExpression(@NotNull String expression) {
        try {
            if (ItemBuilder.containsMathOperators(expression)) {
                return MathExpressionEvaluator.evaluate(expression);
            }
            return Double.parseDouble(expression.trim());
        }
        catch (Exception e) {
            try {
                return Double.parseDouble(expression.trim());
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }
    }

    private static String evaluateMathIfNeeded(@NotNull String expression) {
        if (ItemBuilder.containsMathOperators(expression)) {
            try {
                double result = MathExpressionEvaluator.evaluate(expression);
                if (result == Math.floor(result)) {
                    return String.valueOf((long)result);
                }
                return String.valueOf(result);
            }
            catch (Exception e) {
                return expression;
            }
        }
        return expression;
    }

    private static boolean containsMathOperators(@NotNull String expression) {
        String trimmed = expression.trim();
        if (trimmed.contains("sqrt(") || trimmed.contains("round(") || trimmed.contains("roundDown(")) {
            return true;
        }
        for (int i = 0; i < trimmed.length(); ++i) {
            char c = trimmed.charAt(i);
            if (c == '*' || c == '/') {
                return true;
            }
            if (c != '+' && c != '-' || i <= 0) continue;
            return true;
        }
        return false;
    }

    private static int findOperatorIndex(@NotNull String text, @NotNull String operator) {
        int index = text.indexOf(operator);
        while (index == 0 && text.length() > operator.length()) {
            index = text.indexOf(operator, index + 1);
        }
        return index > 0 ? index : -1;
    }

    private static boolean isPartOfTwoCharOperator(@NotNull String text, int index, char operator) {
        return index + 1 < text.length() && text.charAt(index + 1) == '=';
    }

    public static void replacePlaceholders(@NotNull ItemStack item, @NotNull Map<String, String> replacements) {
        List lore;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        HashMap<String, Component> componentReplacements = new HashMap<String, Component>();
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            componentReplacements.put(entry.getKey(), TextFormatter.transform(null, entry.getValue()));
        }
        Component name = meta.itemName();
        if (name != null) {
            meta.itemName(ItemBuilder.replaceInComponent(name, componentReplacements));
        }
        if ((lore = meta.lore()) != null && !lore.isEmpty()) {
            List newLore = lore.stream().map(line -> ItemBuilder.replaceInComponent(line, componentReplacements)).collect(Collectors.toList());
            meta.lore(newLore);
        }
        item.setItemMeta(meta);
    }

    @NotNull
    private static Component replaceInComponent(@NotNull Component component, @NotNull Map<String, Component> replacements) {
        Component result = component;
        for (Map.Entry<String, Component> entry : replacements.entrySet()) {
            TextReplacementConfig config = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(entry.getKey()).replacement((ComponentLike)entry.getValue()).build();
            result = result.replaceText(config);
        }
        return result;
    }

    @NotNull
    private static Component disableDefaultItalics(@NotNull Component component) {
        return component.decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET ? component.decoration(TextDecoration.ITALIC, false) : component;
    }

    @NotNull
    private static List<String> getConfigList(@NotNull YamlConfiguration config, @NotNull String path) {
        if (!config.contains(path)) {
            return Collections.emptyList();
        }
        if (config.isList(path)) {
            return config.getStringList(path);
        }
        String value = config.getString(path);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }

    private static boolean isInteger(@NotNull String value) {
        try {
            Integer.parseInt(value.trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

