/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.hooks;

import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholdersHandler;
import me.yleoft.zHomes.libs.zAPI.hooks.HookInstance;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class HookPlaceholderAPI
implements HookInstance {
    private final Map<PlaceholdersHandler, PlaceholderExpansion> expansions = new HashMap<PlaceholdersHandler, PlaceholderExpansion>();
    public static String message = "PlaceholderAPI has been found, placeholders are enabled!";
    private PlaceholderAPIPlugin plugin;

    @Override
    public boolean exists() {
        return this.plugin != null;
    }

    @Override
    public void load() {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return;
        }
        this.plugin = PlaceholderAPIPlugin.getInstance();
    }

    @Override
    public void unload() {
        if (!this.exists()) {
            return;
        }
        for (PlaceholdersHandler handler : this.expansions.keySet()) {
            this.unregisterPlaceholderExpansion(handler);
        }
    }

    @Override
    public String message() {
        return message;
    }

    public void registerPlaceholderExpansion(final PlaceholdersHandler handler) {
        if (HookRegistry.PAPI.exists()) {
            try {
                PlaceholderExpansion expansion = new PlaceholderExpansion(){

                    @NotNull
                    public String getIdentifier() {
                        return handler.getIdentifier();
                    }

                    @NotNull
                    public String getAuthor() {
                        return handler.getAuthor();
                    }

                    @NotNull
                    public String getVersion() {
                        return handler.getVersion();
                    }

                    public String onRequest(OfflinePlayer p, @NotNull String params) {
                        return handler.applyHookPlaceholders(p, params);
                    }
                };
                ((PlaceholderExpansion)expansion).register();
                this.expansions.put(handler, expansion);
            }
            catch (Exception exception) {
                zAPI.getLogger().warn("Failed to register PlaceholderAPI expansion for: " + handler.getIdentifier(), exception);
            }
        }
    }

    public void unregisterPlaceholderExpansion(PlaceholdersHandler handler) {
        PlaceholderExpansion expansion;
        if (HookRegistry.PAPI.exists() && (expansion = this.expansions.remove(handler)) != null) {
            expansion.unregister();
        }
    }

    public static void setMessage(String message) {
        HookPlaceholderAPI.message = message;
    }
}

