/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderDefinition;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderType;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlaceholdersHandler {
    @NotNull
    public String getIdentifier();

    @NotNull
    default public String getAuthor() {
        return String.join((CharSequence)", ", Version.getAuthors());
    }

    @NotNull
    default public String getVersion() {
        return Version.getVersion();
    }

    @NotNull
    public List<PlaceholderDefinition> getPlaceholders();

    @Nullable
    public String onPlaceholderRequest(@Nullable OfflinePlayer var1, @NotNull String var2, @NotNull List<String> var3);

    @Nullable
    default public String applyHookPlaceholders(@Nullable OfflinePlayer player, @NotNull String params) {
        if (params.startsWith("player_")) {
            String afterPlayer = params.substring("player_".length());
            for (PlaceholderDefinition def : this.getPlaceholders()) {
                String keySuffix;
                int keyIndex;
                if (def.getType() != PlaceholderType.PLAYER_TARGETED || (keyIndex = afterPlayer.indexOf(keySuffix = "_" + def.getKey())) <= 0) continue;
                String targetName = afterPlayer.substring(0, keyIndex);
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
                if (!def.hasParameters()) {
                    if (!afterPlayer.equals(targetName + keySuffix)) continue;
                    return this.onPlaceholderRequest(targetPlayer, def.getKey(), Collections.emptyList());
                }
                String fullPrefix = targetName + keySuffix + "_";
                if (afterPlayer.startsWith(fullPrefix)) {
                    String remaining = afterPlayer.substring(fullPrefix.length());
                    String[] parts = remaining.split("_", def.getParameterCount());
                    return this.onPlaceholderRequest(targetPlayer, def.getKey(), List.of(parts));
                }
                if (!afterPlayer.equals(targetName + keySuffix)) continue;
                return this.onPlaceholderRequest(targetPlayer, def.getKey(), Collections.emptyList());
            }
        }
        for (PlaceholderDefinition def : this.getPlaceholders()) {
            if (!def.hasParameters() && params.equals(def.getKey())) {
                return this.onPlaceholderRequest(player, def.getKey(), Collections.emptyList());
            }
            if (!def.hasParameters() || !params.startsWith(def.getKey() + "_")) continue;
            String remaining = params.substring(def.getKey().length() + 1);
            String[] parts = remaining.split("_", def.getParameterCount());
            return this.onPlaceholderRequest(player, def.getKey(), List.of(parts));
        }
        return this.onPlaceholderRequest(player, params, Collections.emptyList());
    }

    default public String applyPlaceholders(@Nullable OfflinePlayer player, @NotNull String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.contains("%")) {
            Pattern pattern = Pattern.compile("%" + Pattern.quote(this.getIdentifier()) + "_([^%]+)%");
            Matcher matcher = pattern.matcher(text);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String rawParams = matcher.group(1);
                String replacement = this.applyHookPlaceholders(player, rawParams);
                if (replacement == null) {
                    replacement = "";
                }
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(buffer);
            text = buffer.toString();
        }
        if (!HookRegistry.MINI_PLACEHOLDERS.exists() && text.contains("<")) {
            Pattern miniPattern = Pattern.compile("<" + Pattern.quote(this.getIdentifier()) + "_([^>]+)>");
            Matcher miniMatcher = miniPattern.matcher(text);
            StringBuffer miniBuffer = new StringBuffer();
            while (miniMatcher.find()) {
                List<String> args;
                String rawTag = miniMatcher.group(1);
                String[] tagParts = rawTag.split(":");
                String miniKey = tagParts[0];
                String replacement = this.onPlaceholderRequest(player, miniKey, args = tagParts.length > 1 ? List.of(Arrays.copyOfRange(tagParts, 1, tagParts.length)) : Collections.emptyList());
                if (replacement == null) {
                    replacement = "";
                }
                miniMatcher.appendReplacement(miniBuffer, Matcher.quoteReplacement(replacement));
            }
            miniMatcher.appendTail(miniBuffer);
            text = miniBuffer.toString();
        }
        return text;
    }
}

