/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.configuration;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.yleoft.zHomes.libs.zAPI.configuration.Path;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLBuilder
extends Path {
    private final File file;
    private final Map<String, Object> defaults = new LinkedHashMap<String, Object>();
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();
    private final Map<String, String[]> pendingComments = new LinkedHashMap<String, String[]>();
    private final Map<String, String> pendingMoves = new LinkedHashMap<String, String>();
    private final Map<String, Boolean> commentHighlight = new LinkedHashMap<String, Boolean>();
    private final Map<String, String[]> sectionComments = new LinkedHashMap<String, String[]>();
    private final Set<String> voidedPaths = new HashSet<String>();
    private final List<String> insertionOrder = new ArrayList<String>();
    private String[] header = null;
    private String[] footer = null;
    private String[] nextComment = null;
    private boolean nextCommentHighlight = true;
    private String currentVersion = "1.0.0";
    private Map<String, Object> cachedData = null;
    private static final String VERSION_KEY = "config-version";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d)\\.(\\d{1,2})$");
    private boolean migrateLegacyColors = false;
    private static final Pattern AMP_HEX_PATTERN = Pattern.compile("(?i)&?#([0-9a-f]{6})");
    private static final Pattern SPIGOT_HEX_PATTERN = Pattern.compile("(?i)&x(&[0-9a-f]){6}");

    public YAMLBuilder(File parent, String fileName) {
        if (!((String)fileName).endsWith(".yml") && !((String)fileName).endsWith(".yaml")) {
            fileName = (String)fileName + ".yml";
        }
        this.file = new File(parent, (String)fileName);
        this.loadExistingVersion();
        this.loadCachedData();
    }

    public YAMLBuilder(File file) {
        this.file = file;
        this.loadExistingVersion();
        this.loadCachedData();
    }

    private void loadExistingVersion() {
        if (this.file.exists()) {
            try {
                List<String> lines = Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (!trimmed.startsWith("config-version: ")) continue;
                    String version = trimmed.substring("config-version:".length()).trim();
                    if (this.isValidVersion(version = version.replace("\"", "").replace("'", ""))) {
                        this.currentVersion = version;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadCachedData() {
        this.cachedData = this.loadExistingData();
    }

    public YAMLBuilder refresh() {
        this.loadCachedData();
        this.loadExistingVersion();
        return this;
    }

    public YAMLBuilder migrateLegacyColors(boolean enable) {
        this.migrateLegacyColors = enable;
        return this;
    }

    public String getString(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return null;
        }
        if (value instanceof MultiLineString) {
            return String.join((CharSequence)"\n", ((MultiLineString)value).lines);
        }
        return value.toString();
    }

    public String getString(String path, String defaultValue) {
        String value = this.getString(path);
        return value != null ? value : defaultValue;
    }

    public boolean getBoolean(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    public int getInt(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public int getInt(String path, int defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLong(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public long getLong(String path, long defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDouble(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getDouble(String path, double defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public float getFloat(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public float getFloat(String path, float defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public byte getByte(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public byte getByte(String path, byte defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public short getShort(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public short getShort(String path, short defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public char getChar(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return '\u0000';
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.isEmpty() ? (char)'\u0000' : str.charAt(0);
        }
        return '\u0000';
    }

    public char getChar(String path, char defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.isEmpty() ? defaultValue : str.charAt(0);
        }
        return defaultValue;
    }

    public List<String> getStringList(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return new ArrayList<String>();
        }
        if (value instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object item : (List)value) {
                result.add(item != null ? item.toString() : null);
            }
            return result;
        }
        return new ArrayList<String>();
    }

    public List<String> getStringList(String path, List<String> defaultValue) {
        Object value = this.getValue(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object item : (List)value) {
                result.add(item != null ? item.toString() : null);
            }
            return result;
        }
        return defaultValue;
    }

    public List<Integer> getIntList(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return new ArrayList<Integer>();
        }
        if (value instanceof List) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (Object item : (List)value) {
                if (item instanceof Number) {
                    result.add(((Number)item).intValue());
                    continue;
                }
                if (!(item instanceof String)) continue;
                try {
                    result.add(Integer.parseInt((String)item));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return result;
        }
        return new ArrayList<Integer>();
    }

    public List<Double> getDoubleList(String path) {
        Object value = this.getValue(path);
        if (value == null) {
            return new ArrayList<Double>();
        }
        if (value instanceof List) {
            ArrayList<Double> result = new ArrayList<Double>();
            for (Object item : (List)value) {
                if (item instanceof Number) {
                    result.add(((Number)item).doubleValue());
                    continue;
                }
                if (!(item instanceof String)) continue;
                try {
                    result.add(Double.parseDouble((String)item));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return result;
        }
        return new ArrayList<Double>();
    }

    public Object get(String path) {
        return this.getValue(path);
    }

    public Object get(String path, Object defaultValue) {
        Object value = this.getValue(path);
        return value != null ? value : defaultValue;
    }

    public boolean contains(String path) {
        return this.getValue(path) != null;
    }

    public boolean isType(String path, Class<?> type) {
        Object value = this.getValue(path);
        return value != null && type.isInstance(value);
    }

    private Object getValue(String path) {
        Object value = this.getValueFromPath(this.cachedData, path);
        if (value != null) {
            return value;
        }
        return this.defaults.get(path);
    }

    public YAMLSection getConfigurationSection(String path) {
        Object cached;
        Object value = this.getValue(path);
        if (value instanceof Map) {
            return new YAMLSection(this, path, (Map)value);
        }
        if (this.cachedData != null && (cached = this.getValueFromPath(this.cachedData, path)) instanceof Map) {
            return new YAMLSection(this, path, (Map)cached);
        }
        return null;
    }

    public Set<String> getKeys(boolean deep) {
        return this.getKeys("", deep);
    }

    public Set<String> getKeys(String path, boolean deep) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Map targetMap = this.cachedData;
        if (path != null && !path.isEmpty()) {
            Object value = this.getValueFromPath(this.cachedData, path);
            if (value instanceof Map) {
                targetMap = (Map)value;
            } else {
                return keys;
            }
        }
        if (targetMap == null) {
            return keys;
        }
        if (deep) {
            this.collectKeysDeep(targetMap, "", keys);
        } else {
            keys.addAll(targetMap.keySet());
        }
        return keys;
    }

    private void collectKeysDeep(Map<String, Object> map, String prefix, Set<String> keys) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String fullKey = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            keys.add(fullKey);
            if (!(entry.getValue() instanceof Map)) continue;
            this.collectKeysDeep((Map)entry.getValue(), fullKey, keys);
        }
    }

    public YAMLBuilder voidPath(String path) {
        this.defaults.remove(path);
        this.values.remove(path);
        this.pendingComments.remove(path);
        this.commentHighlight.remove(path);
        this.sectionComments.remove(path);
        this.voidedPaths.add(path);
        if (this.cachedData != null) {
            this.removeValueFromPath(this.cachedData, path);
        }
        String pathPrefix = path + ".";
        this.defaults.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(pathPrefix));
        this.values.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(pathPrefix));
        this.pendingComments.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(pathPrefix));
        this.commentHighlight.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(pathPrefix));
        this.sectionComments.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(pathPrefix));
        return this;
    }

    public boolean isVoided(String path) {
        if (this.voidedPaths.contains(path)) {
            return true;
        }
        for (String voided : this.voidedPaths) {
            if (!path.startsWith(voided + ".")) continue;
            return true;
        }
        return false;
    }

    public YAMLBuilder header(String ... lines) {
        if (lines == null) {
            this.header = null;
            return this;
        }
        this.header = lines.length == 1 && YAMLBuilder.isTextBox(lines[0]) ? YAMLBuilder.splitLinesPreserveEmpty(lines[0]) : lines;
        return this;
    }

    public YAMLBuilder footer(String ... lines) {
        if (lines == null) {
            this.footer = null;
            return this;
        }
        this.footer = lines.length == 1 && YAMLBuilder.isTextBox(lines[0]) ? YAMLBuilder.splitLinesPreserveEmpty(lines[0]) : lines;
        return this;
    }

    public YAMLBuilder comment(boolean highlight, String ... comments) {
        this.nextComment = comments != null && comments.length == 1 && YAMLBuilder.isTextBox(comments[0]) ? YAMLBuilder.splitLinesPreserveEmpty(comments[0]) : comments;
        this.nextCommentHighlight = highlight;
        return this;
    }

    public YAMLBuilder comment(String ... comments) {
        return this.comment(true, comments);
    }

    public YAMLBuilder commentSection(String section, String ... comments) {
        if (comments != null && comments.length == 1 && YAMLBuilder.isTextBox(comments[0])) {
            this.sectionComments.put(section, YAMLBuilder.splitLinesPreserveEmpty(comments[0]));
        } else {
            this.sectionComments.put(section, comments);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, String value) {
        this.defaults.put(path, YAMLBuilder.toYamlStringValue(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, String ... values) {
        if (values.length == 1) {
            return this.addDefault(path, values[0]);
        }
        this.defaults.put(path, Arrays.stream(values).toList());
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, int value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, long value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, double value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, float value) {
        this.defaults.put(path, Float.valueOf(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, boolean value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, List<String> value) {
        this.defaults.put(path, new ArrayList<String>(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public <T> YAMLBuilder addDefaultList(String path, List<T> value) {
        this.defaults.put(path, new ArrayList<T>(value));
        this.applyPendingComment(path);
        return this;
    }

    public YAMLBuilder addDefault(String path, byte value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, short value) {
        this.defaults.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder addDefault(String path, char value) {
        this.defaults.put(path, String.valueOf(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, String value) {
        this.values.put(path, YAMLBuilder.toYamlStringValue(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, String ... values) {
        if (values.length == 1) {
            return this.setValue(path, values[0]);
        }
        this.defaults.put(path, Arrays.stream(values).toList());
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, int value) {
        this.values.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, double value) {
        this.values.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, boolean value) {
        this.values.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, List<String> value) {
        this.values.put(path, new ArrayList<String>(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, long value) {
        this.values.put(path, value);
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    public YAMLBuilder setValue(String path, float value) {
        this.values.put(path, Float.valueOf(value));
        this.applyPendingComment(path);
        if (!this.insertionOrder.contains(path)) {
            this.insertionOrder.add(path);
        }
        return this;
    }

    private void applyPendingComment(String path) {
        if (this.nextComment != null) {
            this.pendingComments.put(path, this.nextComment);
            this.commentHighlight.put(path, this.nextCommentHighlight);
            this.nextComment = null;
            this.nextCommentHighlight = true;
        }
    }

    public YAMLBuilder set(String path, Object value) {
        if (this.cachedData == null) {
            this.cachedData = new LinkedHashMap<String, Object>();
        }
        if (this.isVoided(path)) {
            return this;
        }
        if (!this.pendingMoves.isEmpty()) {
            this.applyPendingMoves();
        }
        if (value == null) {
            this.removeValueFromPath(this.cachedData, path);
        } else {
            Object yamlValue = value;
            if (value instanceof String) {
                String s = (String)((Object)value);
                yamlValue = YAMLBuilder.toYamlStringValue(s);
            } else if (value instanceof String[]) {
                String[] arr = (String[])value;
                yamlValue = arr.length <= 1 ? YAMLBuilder.toYamlStringValue(arr.length == 0 ? "" : arr[0]) : new MultiLineString(arr);
            } else if (value instanceof List) {
                List list = (List)((Object)value);
                yamlValue = new ArrayList(list);
            }
            this.setValueAtPath(this.cachedData, path, yamlValue);
        }
        if (this.migrateLegacyColors) {
            this.convertLegacyColorsInObject(this.cachedData);
        }
        for (String voidedPath : this.voidedPaths) {
            this.removeValueFromPath(this.cachedData, voidedPath);
        }
        try {
            this.writeYamlFile(this.cachedData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadExistingVersion();
        this.loadCachedData();
        return this;
    }

    public YAMLBuilder unset(String path) {
        return this.set(path, null);
    }

    public YAMLBuilder setString(String path, String value) {
        return this.set(path, value);
    }

    public YAMLBuilder setBoolean(String path, boolean value) {
        return this.set(path, value);
    }

    public YAMLBuilder setInt(String path, int value) {
        return this.set(path, value);
    }

    public YAMLBuilder setInteger(String path, int value) {
        return this.setInt(path, value);
    }

    public YAMLBuilder setLong(String path, long value) {
        return this.set(path, value);
    }

    public YAMLBuilder setDouble(String path, double value) {
        return this.set(path, value);
    }

    public YAMLBuilder setFloat(String path, float value) {
        return this.set(path, Float.valueOf(value));
    }

    public YAMLBuilder setStringList(String path, List<String> value) {
        return this.set(path, value == null ? null : new ArrayList<String>(value));
    }

    public YAMLBuilder setList(String path, List<?> value) {
        return this.set(path, value == null ? null : new ArrayList(value));
    }

    public YAMLBuilder setMultiline(String path, String ... lines) {
        if (lines == null) {
            return this.set(path, null);
        }
        if (lines.length <= 1) {
            return this.set(path, lines.length == 0 ? "" : lines[0]);
        }
        return this.set(path, new MultiLineString(lines));
    }

    public FileConfiguration getConfig() {
        if (this.file.exists()) {
            return YamlConfiguration.loadConfiguration((File)this.file);
        }
        return new YamlConfiguration();
    }

    public String version() {
        return this.currentVersion;
    }

    public YAMLBuilder updateVersion(String newVersion) {
        if (this.isValidVersion(newVersion) && this.compareVersions(newVersion, this.currentVersion) > 0) {
            this.currentVersion = newVersion;
        }
        return this;
    }

    public boolean versionNewer(String version) {
        return this.compareVersions(this.currentVersion, version) > 0;
    }

    public boolean versionOlder(String version) {
        return this.compareVersions(this.currentVersion, version) < 0;
    }

    public boolean versionEqual(String version) {
        return this.compareVersions(this.currentVersion, version) == 0;
    }

    private boolean isValidVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return false;
        }
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        return minor <= 9 && patch <= 99;
    }

    private int compareVersions(String v1, String v2) {
        if (!this.isValidVersion(v1) || !this.isValidVersion(v2)) {
            return 0;
        }
        Matcher m1 = VERSION_PATTERN.matcher(v1);
        Matcher m2 = VERSION_PATTERN.matcher(v2);
        m1.matches();
        m2.matches();
        int major1 = Integer.parseInt(m1.group(1));
        int minor1 = Integer.parseInt(m1.group(2));
        int patch1 = Integer.parseInt(m1.group(3));
        int major2 = Integer.parseInt(m2.group(1));
        int minor2 = Integer.parseInt(m2.group(2));
        int patch2 = Integer.parseInt(m2.group(3));
        if (major1 != major2) {
            return major1 - major2;
        }
        if (minor1 != minor2) {
            return minor1 - minor2;
        }
        return patch1 - patch2;
    }

    public YAMLBuilder move(String path, String newPath) {
        this.pendingMoves.put(path, newPath);
        return this;
    }

    private void applyPendingMoves() {
        for (Map.Entry<String, String> moveEntry : this.pendingMoves.entrySet()) {
            Object value;
            String fromPath = moveEntry.getKey();
            String toPath = moveEntry.getValue();
            String pathPrefix = fromPath + ".";
            String newPathPrefix = toPath + ".";
            if (this.cachedData != null && (value = this.getValueFromPath(this.cachedData, fromPath)) != null) {
                this.removeValueFromPath(this.cachedData, fromPath);
                this.setValueAtPath(this.cachedData, toPath, value);
            }
            if (this.defaults.containsKey(fromPath)) {
                this.defaults.put(toPath, this.defaults.remove(fromPath));
            }
            LinkedHashMap<CallSite, Object> defaultsToAdd = new LinkedHashMap<CallSite, Object>();
            HashSet<String> defaultsToRemove = new HashSet<String>();
            for (String key : this.defaults.keySet()) {
                if (!key.startsWith(pathPrefix)) continue;
                Iterator newKey = newPathPrefix + key.substring(pathPrefix.length());
                defaultsToAdd.put((CallSite)((Object)newKey), this.defaults.get(key));
                defaultsToRemove.add(key);
            }
            for (String key : defaultsToRemove) {
                this.defaults.remove(key);
            }
            this.defaults.putAll(defaultsToAdd);
            if (this.values.containsKey(fromPath)) {
                this.values.put(toPath, this.values.remove(fromPath));
            }
            LinkedHashMap<CallSite, Object> valuesToAdd = new LinkedHashMap<CallSite, Object>();
            HashSet<String> valuesToRemove = new HashSet<String>();
            for (String key : this.values.keySet()) {
                if (!key.startsWith(pathPrefix)) continue;
                Iterator newKey = newPathPrefix + key.substring(pathPrefix.length());
                valuesToAdd.put((CallSite)((Object)newKey), this.values.get(key));
                valuesToRemove.add(key);
            }
            for (String key : valuesToRemove) {
                this.values.remove(key);
            }
            this.values.putAll(valuesToAdd);
            if (this.pendingComments.containsKey(fromPath)) {
                this.pendingComments.put(toPath, this.pendingComments.remove(fromPath));
            }
            LinkedHashMap<CallSite, String[]> commentsToAdd = new LinkedHashMap<CallSite, String[]>();
            HashSet<String> commentsToRemove = new HashSet<String>();
            for (String key : this.pendingComments.keySet()) {
                if (!key.startsWith(pathPrefix)) continue;
                Iterator newKey = newPathPrefix + key.substring(pathPrefix.length());
                commentsToAdd.put((CallSite)((Object)newKey), this.pendingComments.get(key));
                commentsToRemove.add(key);
            }
            for (String key : commentsToRemove) {
                this.pendingComments.remove(key);
            }
            this.pendingComments.putAll(commentsToAdd);
            if (this.commentHighlight.containsKey(fromPath)) {
                this.commentHighlight.put(toPath, this.commentHighlight.remove(fromPath));
            }
            LinkedHashMap<CallSite, Boolean> highlightsToAdd = new LinkedHashMap<CallSite, Boolean>();
            HashSet<String> highlightsToRemove = new HashSet<String>();
            for (String key : this.commentHighlight.keySet()) {
                if (!key.startsWith(pathPrefix)) continue;
                String newKey = newPathPrefix + key.substring(pathPrefix.length());
                highlightsToAdd.put((CallSite)((Object)newKey), this.commentHighlight.get(key));
                highlightsToRemove.add(key);
            }
            for (String key : highlightsToRemove) {
                this.commentHighlight.remove(key);
            }
            this.commentHighlight.putAll(highlightsToAdd);
            if (this.sectionComments.containsKey(fromPath)) {
                this.sectionComments.put(toPath, this.sectionComments.remove(fromPath));
            }
            LinkedHashMap<CallSite, String[]> sectionCommentsToAdd = new LinkedHashMap<CallSite, String[]>();
            HashSet<String> sectionCommentsToRemove = new HashSet<String>();
            for (String key : this.sectionComments.keySet()) {
                if (!key.startsWith(pathPrefix)) continue;
                String newKey = newPathPrefix + key.substring(pathPrefix.length());
                sectionCommentsToAdd.put((CallSite)((Object)newKey), this.sectionComments.get(key));
                sectionCommentsToRemove.add(key);
            }
            for (String key : sectionCommentsToRemove) {
                this.sectionComments.remove(key);
            }
            this.sectionComments.putAll(sectionCommentsToAdd);
        }
        this.pendingMoves.clear();
    }

    public YAMLBuilder build() {
        try {
            boolean firstTimeGenerate;
            boolean bl = firstTimeGenerate = !this.file.exists();
            if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            this.applyPendingMoves();
            LinkedHashMap<String, Object> finalData = new LinkedHashMap<String, Object>();
            if (this.cachedData != null) {
                this.copyAllValues(this.cachedData, finalData, "");
            }
            Map<Object, Object> allEntries = new LinkedHashMap();
            if (firstTimeGenerate) {
                allEntries = this.mergeInDeclarationOrder(this.defaults, this.values);
            } else {
                for (String string : this.insertionOrder) {
                    if (this.defaults.containsKey(string)) {
                        allEntries.put(string, this.defaults.get(string));
                        continue;
                    }
                    if (!this.values.containsKey(string)) continue;
                    allEntries.put(string, this.values.get(string));
                }
            }
            for (Map.Entry entry : allEntries.entrySet()) {
                Object existingValue;
                String path = (String)entry.getKey();
                if (this.isVoided(path) || (existingValue = this.getValueFromPath(finalData, path)) != null) continue;
                this.setValueAtPathOrdered(finalData, path, entry.getValue(), allEntries);
            }
            for (String string : this.voidedPaths) {
                this.removeValueFromPath(finalData, string);
            }
            if (this.migrateLegacyColors) {
                this.convertLegacyColorsInObject(finalData);
            }
            this.writeYamlFile(finalData);
            this.loadCachedData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private Map<String, Object> mergeInDeclarationOrder(Map<String, Object> defaults, Map<String, Object> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String path : this.insertionOrder) {
            if (this.isVoided(path)) continue;
            if (values.containsKey(path)) {
                result.put(path, values.get(path));
                continue;
            }
            if (!defaults.containsKey(path)) continue;
            result.put(path, defaults.get(path));
        }
        return result;
    }

    private boolean shouldInsertValueBefore(String valuePath, String defaultPath, Map<String, Object> defaults) {
        String defaultParent;
        String valueParent = this.getParentPath(valuePath);
        if (!valueParent.equals(defaultParent = this.getParentPath(defaultPath))) {
            return false;
        }
        String defaultPathPrefix = defaultPath + ".";
        for (String key : defaults.keySet()) {
            if (!key.startsWith(defaultPathPrefix)) continue;
            return true;
        }
        return false;
    }

    private String getParentPath(String path) {
        int lastDot = path.lastIndexOf(46);
        return lastDot > 0 ? path.substring(0, lastDot) : "";
    }

    private void setValueAtPathOrdered(Map<String, Object> data, String path, Object value, Map<String, Object> allEntries) {
        String[] parts = path.split("\\.");
        Map current = data;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.containsKey(part) || !(current.get(part) instanceof Map)) {
                current.put((String)part, new LinkedHashMap());
            }
            current = (Map)current.get(part);
        }
        String finalKey = parts[parts.length - 1];
        if (current.containsKey(finalKey)) {
            current.put((String)finalKey, (Object)value);
            return;
        }
        current.put((String)finalKey, (Object)value);
    }

    private static boolean isTextBox(String s) {
        return s != null && (s.contains("\n") || s.contains("\r"));
    }

    private static String[] splitLinesPreserveEmpty(String s) {
        if (s == null) {
            return new String[0];
        }
        String normalized = s.replace("\r\n", "\n").replace('\r', '\n');
        boolean endsWithNewline = !normalized.isEmpty() && normalized.charAt(normalized.length() - 1) == '\n';
        String[] parts = normalized.split("\n", -1);
        if (endsWithNewline && parts.length > 0 && parts[parts.length - 1].isEmpty()) {
            parts = Arrays.copyOf(parts, parts.length - 1);
        }
        return parts;
    }

    private static Object toYamlStringValue(String s) {
        if (s == null) {
            return null;
        }
        if (!YAMLBuilder.isTextBox(s)) {
            return s;
        }
        String[] lines = YAMLBuilder.splitLinesPreserveEmpty(s);
        if (lines.length <= 1) {
            return s;
        }
        return new MultiLineString(lines);
    }

    private void convertLegacyColorsInObject(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : new ArrayList(map.entrySet())) {
                Object key = entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    String s = (String)v;
                    map.put(key, this.legacyToMiniMessage(s));
                    continue;
                }
                if (v instanceof MultiLineString) {
                    MultiLineString mls = (MultiLineString)v;
                    String[] out = new String[mls.lines.length];
                    for (int i = 0; i < mls.lines.length; ++i) {
                        out[i] = this.legacyToMiniMessage(mls.lines[i]);
                    }
                    map.put(key, new MultiLineString(out));
                    continue;
                }
                if (v instanceof List) {
                    List list = (List)v;
                    ArrayList<String> newList = new ArrayList<String>(list.size());
                    for (Object item : list) {
                        if (item instanceof String) {
                            String sItem = (String)item;
                            newList.add(this.legacyToMiniMessage(sItem));
                            continue;
                        }
                        newList.add((String)item);
                    }
                    map.put(key, newList);
                    continue;
                }
                this.convertLegacyColorsInObject(v);
            }
        }
    }

    private String legacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String s = input.replace('\u00a7', '&');
        s = AMP_HEX_PATTERN.matcher(s).replaceAll("<#$1>");
        Matcher m = SPIGOT_HEX_PATTERN.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String token = m.group();
            String hex = token.replace("&x", "").replace("&", "");
            m.appendReplacement(sb, "<#" + hex + ">");
        }
        m.appendTail(sb);
        s = sb.toString();
        return s.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&k", "<obfuscated>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<underlined>").replace("&o", "<italic>").replace("&r", "<reset>");
    }

    private void copyAllValues(Map<String, Object> source, Map<String, Object> dest, String pathPrefix) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String fullPath;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = fullPath = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            if (key.equals(VERSION_KEY) && pathPrefix.isEmpty() || this.isVoided(fullPath)) continue;
            if (value instanceof Map) {
                Object destValue;
                if (!dest.containsKey(key)) {
                    dest.put(key, new LinkedHashMap());
                }
                if (!((destValue = dest.get(key)) instanceof Map)) continue;
                this.copyAllValues((Map)value, (Map)destValue, fullPath);
                continue;
            }
            dest.put(key, value);
        }
    }

    private Map<String, Object> loadExistingData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (!this.file.exists()) {
            return data;
        }
        try {
            List<String> lines = Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
            this.parseYaml(lines, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private void parseYaml(List<String> lines, Map<String, Object> data) {
        ArrayDeque<String> pathStack = new ArrayDeque<String>();
        ArrayDeque<Integer> indentStack = new ArrayDeque<Integer>();
        indentStack.push(-1);
        String currentListPath = null;
        ArrayList<String> currentList = null;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            int indent = this.getIndent(line);
            String trimmed = line.trim();
            if (trimmed.startsWith("- ")) {
                if (currentListPath == null || currentList == null) continue;
                String value = trimmed.substring(2).trim();
                value = this.unquote(value);
                currentList.add(value);
                continue;
            }
            if (currentListPath != null) {
                this.setValueAtPath(data, currentListPath, currentList);
                currentListPath = null;
                currentList = null;
            }
            while (!indentStack.isEmpty() && indent <= (Integer)indentStack.peek()) {
                indentStack.pop();
                if (pathStack.isEmpty()) continue;
                pathStack.pop();
            }
            int colonIndex = trimmed.indexOf(58);
            if (colonIndex <= 0) continue;
            String key = trimmed.substring(0, colonIndex).trim();
            String valueStr = trimmed.substring(colonIndex + 1).trim();
            pathStack.push(key);
            indentStack.push(indent);
            String fullPath = this.buildFullPathFromStack(pathStack);
            if (valueStr.isEmpty()) {
                String next = YAMLBuilder.nextMeaningfulLine(lines, i + 1);
                if (next != null) {
                    int nextIndent = this.getIndent(next);
                    String nextTrimmed = next.trim();
                    if (nextIndent > indent) {
                        if (!nextTrimmed.startsWith("- ")) continue;
                        currentListPath = fullPath;
                        currentList = new ArrayList<String>();
                        continue;
                    }
                }
                pathStack.pop();
                indentStack.pop();
                continue;
            }
            if (valueStr.equals("|") || valueStr.equals("|-")) {
                int baseIndent = indent;
                ArrayList<String> blockLines = new ArrayList<String>();
                int j = i + 1;
                Integer blockIndent = null;
                while (j < lines.size()) {
                    int nextIndent;
                    String nextLine = lines.get(j);
                    if (nextLine.trim().isEmpty()) {
                        nextIndent = this.getIndent(nextLine);
                        if (nextIndent <= baseIndent) break;
                        blockLines.add("");
                        ++j;
                        continue;
                    }
                    nextIndent = this.getIndent(nextLine);
                    if (nextIndent <= baseIndent) break;
                    if (blockIndent == null) {
                        blockIndent = nextIndent;
                    }
                    blockLines.add(this.stripIndent(nextLine, blockIndent));
                    ++j;
                }
                Object value = blockLines.isEmpty() ? "" : new MultiLineString(blockLines.toArray(new String[0]));
                this.setValueAtPath(data, fullPath, value);
                pathStack.pop();
                indentStack.pop();
                i = j - 1;
                continue;
            }
            Object value = this.parseValue(valueStr);
            this.setValueAtPath(data, fullPath, value);
            pathStack.pop();
            indentStack.pop();
        }
        if (currentListPath != null && currentList != null && !currentList.isEmpty()) {
            this.setValueAtPath(data, currentListPath, currentList);
        }
    }

    private String buildFullPathFromStack(Deque<String> pathStack) {
        String[] parts = pathStack.toArray(new String[0]);
        StringBuilder reversedPath = new StringBuilder();
        for (int i = parts.length - 1; i >= 0; --i) {
            if (reversedPath.length() > 0) {
                reversedPath.append(".");
            }
            reversedPath.append(parts[i]);
        }
        return reversedPath.toString();
    }

    private String stripIndent(String line, int indentToStrip) {
        int stripped = 0;
        int idx = 0;
        while (idx < line.length() && stripped < indentToStrip) {
            char c = line.charAt(idx);
            if (c == ' ') {
                ++stripped;
                ++idx;
                continue;
            }
            if (c != '\t') break;
            stripped += 2;
            ++idx;
        }
        return idx <= line.length() ? line.substring(idx) : line.trim();
    }

    private Object parseValue(String value) {
        value = value.trim();
        if ((value = this.stripInlineComment(value)).equals("[]")) {
            return new ArrayList();
        }
        value = this.unquote(value);
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            return value;
        }
    }

    private String stripInlineComment(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar == '\"' || firstChar == '\'') {
            int closeQuote = this.findClosingQuote(value, firstChar, 1);
            if (closeQuote > 0) {
                return value.substring(0, closeQuote + 1);
            }
            return value;
        }
        int commentIndex = -1;
        for (int i = 1; i < value.length(); ++i) {
            if (value.charAt(i) != '#' || !Character.isWhitespace(value.charAt(i - 1))) continue;
            commentIndex = i;
            break;
        }
        if (commentIndex > 0) {
            return value.substring(0, commentIndex).trim();
        }
        return value;
    }

    private int findClosingQuote(String value, char quoteChar, int startIndex) {
        for (int i = startIndex; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' && i + 1 < value.length()) {
                ++i;
                continue;
            }
            if (c != quoteChar) continue;
            return i;
        }
        return -1;
    }

    private String unquote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private int getIndent(String line) {
        int count = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++count;
                continue;
            }
            if (c != '\t') break;
            count += 2;
        }
        return count;
    }

    private Object getValueFromPath(Map<String, Object> data, String path) {
        if (data == null) {
            return null;
        }
        String[] parts = path.split("\\.");
        Object current = data;
        for (String part : parts) {
            if (current instanceof Map) {
                if ((current = current.get(part)) != null) continue;
                return null;
            }
            return null;
        }
        return current;
    }

    private void setValueAtPath(Map<String, Object> data, String path, Object value) {
        String[] parts = path.split("\\.");
        Map current = data;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.containsKey(part) || !(current.get(part) instanceof Map)) {
                current.put((String)part, new LinkedHashMap());
            }
            current = (Map)current.get(part);
        }
        current.put((String)parts[parts.length - 1], (Object)value);
    }

    private void removeValueFromPath(Map<String, Object> data, String path) {
        if (data == null) {
            return;
        }
        String[] parts = path.split("\\.");
        Map current = data;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            Object next = current.get(part);
            if (!(next instanceof Map)) {
                return;
            }
            current = (Map)next;
        }
        current.remove(parts[parts.length - 1]);
        this.cleanupEmptyParents(data, path);
    }

    private void cleanupEmptyParents(Map<String, Object> data, String path) {
        String parentPath;
        Object parent;
        String[] parts = path.split("\\.");
        for (int i = parts.length - 2; i >= 0 && (parent = this.getValueFromPath(data, parentPath = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i + 1)))) instanceof Map && ((Map)parent).isEmpty(); --i) {
            this.removeValueFromPath(data, parentPath);
        }
    }

    private static String nextMeaningfulLine(List<String> lines, int startIndex) {
        for (int i = startIndex; i < lines.size(); ++i) {
            String l = lines.get(i);
            String t = l.trim();
            if (t.isEmpty() || t.startsWith("#")) continue;
            return l;
        }
        return null;
    }

    private void writeYamlFile(Map<String, Object> data) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.header != null && this.header.length > 0) {
            for (String line : this.header) {
                if (line.isEmpty()) {
                    sb.append("\n");
                    continue;
                }
                if (line.startsWith("#")) {
                    sb.append(line).append("\n");
                    continue;
                }
                sb.append("# ").append(line).append("\n");
            }
            sb.append("\n");
        }
        HashSet<String> writtenPaths = new HashSet<String>();
        this.writeMap(sb, data, 0, "", null, writtenPaths);
        if (this.footer != null && this.footer.length > 0) {
            sb.append("\n");
            for (String line : this.footer) {
                if (line.isEmpty()) {
                    sb.append("\n");
                    continue;
                }
                sb.append("# ").append(line).append("\n");
            }
        }
        sb.append("\n");
        sb.append(VERSION_KEY).append(": \"").append(this.currentVersion).append("\"\n");
        Files.write(this.file.toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void writeMap(StringBuilder sb, Map<String, Object> map, int indent, String pathPrefix, String previousTopSection, Set<String> writtenPaths) {
        String indentStr = this.repeat("  ", indent);
        boolean isTopLevel = indent == 0;
        String lastTopSection = previousTopSection;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int n;
            String currentTopSection;
            String fullPath;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = fullPath = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            String string2 = isTopLevel ? key : (currentTopSection = pathPrefix.isEmpty() ? key : pathPrefix.split("\\.")[0]);
            if (this.isVoided(fullPath)) continue;
            if (isTopLevel && lastTopSection != null && !lastTopSection.equals(key)) {
                sb.append("\n");
            }
            if (this.sectionComments.containsKey(fullPath)) {
                if (sb.length() > 0 && !sb.toString().endsWith("\n\n")) {
                    sb.append("\n");
                }
                for (String comment : this.sectionComments.get(fullPath)) {
                    sb.append(indentStr).append("# ").append(comment).append("\n");
                }
            }
            if (this.pendingComments.containsKey(fullPath)) {
                String[] comments = this.pendingComments.get(fullPath);
                boolean highlight = Boolean.TRUE.equals(this.commentHighlight.get(fullPath));
                if (sb.length() > 0) {
                    if (!sb.toString().endsWith("\n")) {
                        sb.append("\n");
                    }
                    if (highlight && !sb.toString().endsWith("\n\n")) {
                        sb.append("\n");
                    }
                }
                String[] stringArray = comments;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String comment = stringArray[n];
                    sb.append(indentStr).append("# ").append(comment).append("\n");
                }
            }
            if (value instanceof Map) {
                sb.append(indentStr).append(key).append(":\n");
                this.writeMap(sb, (Map)value, indent + 1, fullPath, currentTopSection, writtenPaths);
            } else if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    sb.append(indentStr).append(key).append(": []\n");
                } else {
                    sb.append(indentStr).append(key).append(":\n");
                    String listIndentStr = this.repeat("  ", indent + 1);
                    for (Object item : list) {
                        sb.append(listIndentStr).append("- \"").append(this.escapeString(item.toString())).append("\"\n");
                    }
                }
            } else if (value instanceof MultiLineString) {
                MultiLineString mls = (MultiLineString)value;
                sb.append(indentStr).append(key).append(": |-\n");
                String[] stringArray = mls.lines;
                int n3 = stringArray.length;
                for (n = 0; n < n3; ++n) {
                    String line = stringArray[n];
                    sb.append(indentStr).append("  ").append(line).append("\n");
                }
            } else if (value instanceof String) {
                sb.append(indentStr).append(key).append(": \"").append(this.escapeString((String)value)).append("\"\n");
            } else if (value instanceof Double || value instanceof Float) {
                sb.append(indentStr).append(key).append(": ").append(value).append("\n");
            } else if (value instanceof Number) {
                sb.append(indentStr).append(key).append(": ").append(value).append("\n");
            } else if (value instanceof Boolean) {
                sb.append(indentStr).append(key).append(": ").append(value).append("\n");
            } else {
                sb.append(indentStr).append(key).append(": \"").append(this.escapeString(value.toString())).append("\"\n");
            }
            writtenPaths.add(fullPath);
            lastTopSection = currentTopSection;
        }
    }

    private String escapeString(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String repeat(String str, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public File getFile() {
        return this.file;
    }

    private record MultiLineString(String[] lines) {
    }

    public static class YAMLSection {
        private final YAMLBuilder parent;
        private final String basePath;
        private final Map<String, Object> data;

        YAMLSection(YAMLBuilder parent, String basePath, Map<String, Object> data) {
            this.parent = parent;
            this.basePath = basePath;
            this.data = data;
        }

        private String getFullPath(String key) {
            return this.basePath.isEmpty() ? key : this.basePath + "." + key;
        }

        public String getString(String path) {
            return this.parent.getString(this.getFullPath(path));
        }

        public String getString(String path, String defaultValue) {
            return this.parent.getString(this.getFullPath(path), defaultValue);
        }

        public boolean getBoolean(String path) {
            return this.parent.getBoolean(this.getFullPath(path));
        }

        public boolean getBoolean(String path, boolean defaultValue) {
            return this.parent.getBoolean(this.getFullPath(path), defaultValue);
        }

        public int getInt(String path) {
            return this.parent.getInt(this.getFullPath(path));
        }

        public int getInt(String path, int defaultValue) {
            return this.parent.getInt(this.getFullPath(path), defaultValue);
        }

        public long getLong(String path) {
            return this.parent.getLong(this.getFullPath(path));
        }

        public long getLong(String path, long defaultValue) {
            return this.parent.getLong(this.getFullPath(path), defaultValue);
        }

        public double getDouble(String path) {
            return this.parent.getDouble(this.getFullPath(path));
        }

        public double getDouble(String path, double defaultValue) {
            return this.parent.getDouble(this.getFullPath(path), defaultValue);
        }

        public float getFloat(String path) {
            return this.parent.getFloat(this.getFullPath(path));
        }

        public float getFloat(String path, float defaultValue) {
            return this.parent.getFloat(this.getFullPath(path), defaultValue);
        }

        public List<String> getStringList(String path) {
            return this.parent.getStringList(this.getFullPath(path));
        }

        public List<String> getStringList(String path, List<String> defaultValue) {
            return this.parent.getStringList(this.getFullPath(path), defaultValue);
        }

        public List<Integer> getIntList(String path) {
            return this.parent.getIntList(this.getFullPath(path));
        }

        public List<Double> getDoubleList(String path) {
            return this.parent.getDoubleList(this.getFullPath(path));
        }

        public Object get(String path) {
            return this.parent.get(this.getFullPath(path));
        }

        public Object get(String path, Object defaultValue) {
            return this.parent.get(this.getFullPath(path), defaultValue);
        }

        public boolean contains(String path) {
            return this.parent.contains(this.getFullPath(path));
        }

        public YAMLSection getConfigurationSection(String path) {
            Object value = this.data.get(path);
            if (value instanceof Map) {
                return new YAMLSection(this.parent, this.getFullPath(path), (Map)value);
            }
            return this.parent.getConfigurationSection(this.getFullPath(path));
        }

        public Set<String> getKeys(boolean deep) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (deep) {
                this.parent.collectKeysDeep(this.data, "", keys);
            } else {
                keys.addAll(this.data.keySet());
            }
            return keys;
        }

        public String getCurrentPath() {
            return this.basePath;
        }

        public String getName() {
            int lastDot = this.basePath.lastIndexOf(46);
            return lastDot >= 0 ? this.basePath.substring(lastDot + 1) : this.basePath;
        }

        public YAMLBuilder getRoot() {
            return this.parent;
        }
    }
}

