/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.hooks;

import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.libs.zAPI.hooks.HookInstance;
import me.yleoft.zHomes.zHomes;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class HookVault
implements HookInstance {
    private Economy economy;

    @Override
    public boolean exists() {
        return this.economy != null;
    }

    @Override
    public void load() {
        if (!Bukkit.getServer().getPluginManager().isPluginEnabled("Vault")) {
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            zHomes.getInstance().getLoggerInstance().info("<yellow>Vault economy provider not found! Disabling Vault hook.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    @Override
    public String message() {
        return "<yellow>Vault hooked successfully!";
    }

    public boolean canAfford(Player p, String commandPermission, double cost) {
        if (p.hasPermission(zHomes.getConfigYAML().getBypassCommandCostPermission(commandPermission))) {
            return true;
        }
        if (this.exists()) {
            if (this.economy.has((OfflinePlayer)p, cost)) {
                this.economy.withdrawPlayer((OfflinePlayer)p, cost);
                return true;
            }
            LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getVaultCantAffordCommand());
            return false;
        }
        return true;
    }
}

