/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.configuration;

import java.io.File;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.configuration.YAMLBuilder;
import me.yleoft.zHomes.zHomes;

public class ConfigYAML
extends YAMLBuilder {
    private static final String currentVersion = "1.0.1";

    public ConfigYAML() {
        super(new File(zHomes.getInstance().getDataFolder(), "config.yml"));
        this.migrateLegacyColors(true);
        this.buildConfig();
    }

    private void buildConfig() {
        this.header("####################################################################################################\n# +----------------------------------------------------------------------------------------------+ #\n# |                                                                                              | #\n# |                      \u2591\u2588\u2588     \u2591\u2588\u2588                                                             | #\n# |                      \u2591\u2588\u2588     \u2591\u2588\u2588                                                             | #\n# |           \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2591\u2588\u2588     \u2591\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588             | #\n# |                \u2591\u2588\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2591\u2588\u2588    \u2591\u2588\u2588 \u2591\u2588\u2588   \u2591\u2588\u2588   \u2591\u2588\u2588 \u2591\u2588\u2588    \u2591\u2588\u2588 \u2591\u2588\u2588                   | #\n# |              \u2591\u2588\u2588\u2588    \u2591\u2588\u2588     \u2591\u2588\u2588 \u2591\u2588\u2588    \u2591\u2588\u2588 \u2591\u2588\u2588   \u2591\u2588\u2588   \u2591\u2588\u2588 \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588             | #\n# |            \u2591\u2588\u2588\u2588      \u2591\u2588\u2588     \u2591\u2588\u2588 \u2591\u2588\u2588    \u2591\u2588\u2588 \u2591\u2588\u2588   \u2591\u2588\u2588   \u2591\u2588\u2588 \u2591\u2588\u2588               \u2591\u2588\u2588            | #\n# |           \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2591\u2588\u2588     \u2591\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588  \u2591\u2588\u2588   \u2591\u2588\u2588   \u2591\u2588\u2588  \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588             | #\n# |                                                                                              | #\n%h1\n# |                                                                                              | #\n# |   \u2022 Wiki:        https://docs.yleoft.me/zhomes                                               | #\n# |   \u2022 Discord:     https://discord.gg/yCdhVDgn4K                                               | #\n# |   \u2022 Bug reports: https://github.com/yL3oft/zHomes/issues                                     | #\n# |                                                                                              | #\n%h2\n# |                                                                                              | #\n# +----------------------------------------------------------------------------------------------+ #\n####################################################################################################\n".replace("%h1", zHomes.getLanguageYAML().getConfigCommentHeader1()).replace("%h2", zHomes.getLanguageYAML().getConfigCommentHeader2()));
        if (this.versionOlder(currentVersion)) {
            this.voidPath(ConfigYAML.formPath("general", "auto-update"));
            this.voidPath(ConfigYAML.formPath("commands", "main", "version", "update"));
            this.updateVersion(currentVersion);
        }
        this.addDefault("prefix", "<dark_gray>[<red>zHomes<dark_gray>]");
        this.commentSection("database", zHomes.getLanguageYAML().getConfigCommentDatabase());
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentDatabaseType());
        this.addDefault(ConfigYAML.formPath("database", "type"), "H2");
        this.addDefault(ConfigYAML.formPath("database", "host"), "localhost");
        this.addDefault(ConfigYAML.formPath("database", "port"), 3306);
        this.addDefault(ConfigYAML.formPath("database", "database"), "db");
        this.addDefault(ConfigYAML.formPath("database", "username"), "root");
        this.addDefault(ConfigYAML.formPath("database", "password"), "pass");
        this.addDefault(ConfigYAML.formPath("database", "options", "useSSL"), false);
        this.addDefault(ConfigYAML.formPath("database", "options", "allowPublicKeyRetrieval"), false);
        this.comment(true, zHomes.getLanguageYAML().getConfigCommentPoolSize());
        this.addDefault(ConfigYAML.formPath("database", "pool-size"), 10);
        this.addDefault(ConfigYAML.formPath("database", "table-prefix"), "zhomes");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentGeneralLanguage());
        this.addDefault(ConfigYAML.formPath("general", "language"), "en");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentGeneralAnnounceUpdate());
        this.addDefault(ConfigYAML.formPath("general", "announce-update"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentGeneralMetrics());
        this.addDefault(ConfigYAML.formPath("general", "metrics"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentGeneralDebugMode());
        this.addDefault(ConfigYAML.formPath("general", "debug-mode"), false);
        this.commentSection("teleport-options", zHomes.getLanguageYAML().getConfigCommentTeleportOptions());
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsEnableSafeTeleport());
        this.addDefault(ConfigYAML.formPath("teleport-options", "enable-safe-teleport"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsDimensionalTeleportation());
        this.addDefault(ConfigYAML.formPath("teleport-options", "dimensional-teleportation"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsPlaySound());
        this.addDefault(ConfigYAML.formPath("teleport-options", "play-sound"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsRestrictedWorldsEnable());
        this.addDefault(ConfigYAML.formPath("teleport-options", "restricted-worlds", "enable"), false);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsRestrictedWorldsMode());
        this.addDefault(ConfigYAML.formPath("teleport-options", "restricted-worlds", "mode"), "blacklist");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsRestrictedWorldsWorlds());
        this.addDefault(ConfigYAML.formPath("teleport-options", "restricted-worlds", "worlds"), List.of("world_nether", "world_the_end"));
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsWarmupEnable());
        this.addDefault(ConfigYAML.formPath("teleport-options", "warmup", "enable"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsWarmupTime());
        this.addDefault(ConfigYAML.formPath("teleport-options", "warmup", "time"), 5);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsWarmupCancelOnMove());
        this.addDefault(ConfigYAML.formPath("teleport-options", "warmup", "cancel-on-move"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentTeleportOptionsWarmupShowOnActionbar());
        this.addDefault(ConfigYAML.formPath("teleport-options", "warmup", "show-on-actionbar"), true);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentLimitsEnabled());
        this.addDefault(ConfigYAML.formPath("limits", "enabled"), false);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentLimitsDefault());
        this.addDefault(ConfigYAML.formPath("limits", "default"), 10);
        this.comment(zHomes.getLanguageYAML().getConfigCommentLimitsExamples());
        this.setValue(ConfigYAML.formPath("limits", "15"), List.of("group.vip", "group.mvp"));
        this.setValue(ConfigYAML.formPath("limits", "999"), List.of("group.admin"));
        this.commentSection("commands", zHomes.getLanguageYAML().getConfigCommentCommands());
        this.addDefault(ConfigYAML.formPath("commands", "main", "command"), "zhomes");
        this.addDefault(ConfigYAML.formPath("commands", "main", "description"), "The main command for the plugin");
        this.addDefault(ConfigYAML.formPath("commands", "main", "permission"), "zhomes.command.main");
        this.addDefault(ConfigYAML.formPath("commands", "main", "aliases"), List.of("zh"));
        this.addDefault(ConfigYAML.formPath("commands", "main", "help", "permission"), "zhomes.command.main.help");
        this.addDefault(ConfigYAML.formPath("commands", "main", "info", "permission"), "zhomes.command.main.info");
        this.addDefault(ConfigYAML.formPath("commands", "main", "version", "permission"), "zhomes.command.main.version");
        this.addDefault(ConfigYAML.formPath("commands", "main", "reload", "permission"), "zhomes.command.main.reload");
        this.addDefault(ConfigYAML.formPath("commands", "main", "nearhomes", "permission"), "zhomes.command.main.nearhomes");
        this.addDefault(ConfigYAML.formPath("commands", "main", "nearhomes", "limit"), 500.0);
        this.addDefault(ConfigYAML.formPath("commands", "main", "parse", "permission"), "zhomes.command.main.parse");
        this.addDefault(ConfigYAML.formPath("commands", "main", "converter", "permission"), "zhomes.command.main.converter");
        this.addDefault(ConfigYAML.formPath("commands", "main", "importexport", "permission"), "zhomes.command.main.importexport");
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "command"), "sethome");
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "description"), "Use to set a home");
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "permission"), "zhomes.command.sethome");
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "aliases"), List.of("seth"));
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "cooldown"), 0.0);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsCommandCost());
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "command-cost"), 0);
        this.addDefault(ConfigYAML.formPath("commands", "sethome", "others", "permission"), "zhomes.command.sethome.others");
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "command"), "delhome");
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "description"), "Use to delete a home");
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "permission"), "zhomes.command.delhome");
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "aliases"), List.of("deletehome", "delh"));
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "cooldown"), 0.0);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsCommandCost());
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "command-cost"), 0);
        this.addDefault(ConfigYAML.formPath("commands", "delhome", "others", "permission"), "zhomes.command.delhome.others");
        this.addDefault(ConfigYAML.formPath("commands", "homes", "command"), "homes");
        this.addDefault(ConfigYAML.formPath("commands", "homes", "description"), "List your homes");
        this.addDefault(ConfigYAML.formPath("commands", "homes", "permission"), "zhomes.command.homes");
        this.addDefault(ConfigYAML.formPath("commands", "homes", "aliases"), List.of("myhomes"));
        this.addDefault(ConfigYAML.formPath("commands", "homes", "cooldown"), 0.0);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsCommandCost());
        this.addDefault(ConfigYAML.formPath("commands", "homes", "command-cost"), 0);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsHomesTypes());
        this.addDefault(ConfigYAML.formPath("commands", "homes", "type"), "menu");
        this.addDefault(ConfigYAML.formPath("commands", "homes", "others", "permission"), "zhomes.command.homes.others");
        this.addDefault(ConfigYAML.formPath("commands", "home", "command"), "home");
        this.addDefault(ConfigYAML.formPath("commands", "home", "description"), "Teleport to a home");
        this.addDefault(ConfigYAML.formPath("commands", "home", "permission"), "zhomes.command.home");
        this.addDefault(ConfigYAML.formPath("commands", "home", "aliases"), List.of());
        this.addDefault(ConfigYAML.formPath("commands", "home", "cooldown"), 3.0);
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsCommandCost());
        this.addDefault(ConfigYAML.formPath("commands", "home", "command-cost"), 0);
        this.addDefault(ConfigYAML.formPath("commands", "home", "others", "permission"), "zhomes.command.home.others");
        this.addDefault(ConfigYAML.formPath("commands", "home", "rename", "permission"), "zhomes.command.home.rename");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentCommandsCommandCost());
        this.addDefault(ConfigYAML.formPath("commands", "home", "rename", "command-cost"), 0);
        this.commentSection("permissions", zHomes.getLanguageYAML().getConfigCommentPermissions());
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassLimit());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "limit"), "zhomes.bypass.limit");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassDimensionalTeleportation());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "dimensional-teleportation"), "zhomes.bypass.dimensionalteleportation");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassSafeTeleportation());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "safe-teleportation"), "zhomes.bypass.safeteleport");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassRestrictedWorlds());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "restricted-worlds"), "zhomes.bypass.restrictedworlds");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassWarmup());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "warmup"), "zhomes.bypass.warmup");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassCommandCosts());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "command-cost"), "%command_permission%.bypass.command-cost");
        this.comment(false, zHomes.getLanguageYAML().getConfigCommentPermissionsBypassCommandCooldowns());
        this.addDefault(ConfigYAML.formPath("permissions", "bypass", "command-cooldown"), "%command_permission%.bypass.command-cooldown");
        this.footer("!!! DON'T TOUCH config-version UNLESS YOU KNOW EXACTLY WHAT YOU'RE DOING !!!");
        this.build();
    }

    public String getPrefix() {
        return this.getString("prefix");
    }

    public String getDatabaseType() {
        return this.getString(ConfigYAML.formPath("database", "type"));
    }

    public String getDatabaseHost() {
        return this.getString(ConfigYAML.formPath("database", "host"));
    }

    public int getDatabasePort() {
        return this.getInt(ConfigYAML.formPath("database", "port"));
    }

    public String getDatabaseName() {
        return this.getString(ConfigYAML.formPath("database", "database"));
    }

    public String getDatabaseUsername() {
        return this.getString(ConfigYAML.formPath("database", "username"));
    }

    public String getDatabasePassword() {
        return this.getString(ConfigYAML.formPath("database", "password"));
    }

    public boolean isDatabaseUseSSL() {
        return this.getBoolean(ConfigYAML.formPath("database", "options", "useSSL"));
    }

    public boolean isDatabaseAllowPublicKeyRetrieval() {
        return this.getBoolean(ConfigYAML.formPath("database", "options", "allowPublicKeyRetrieval"));
    }

    public int getDatabasePoolSize() {
        return this.getInt(ConfigYAML.formPath("database", "pool-size"));
    }

    public String getDatabaseTablePrefix() {
        return this.getString(ConfigYAML.formPath("database", "table-prefix"));
    }

    public String getDatabaseTable() {
        return this.getDatabaseTablePrefix() + "_homes";
    }

    public String getLanguageCode() {
        return this.getString(ConfigYAML.formPath("general", "language"));
    }

    public boolean isAnnounceUpdateEnabled() {
        return this.getBoolean(ConfigYAML.formPath("general", "announce-update"));
    }

    public boolean isMetricsEnabled() {
        return this.getBoolean(ConfigYAML.formPath("general", "metrics"));
    }

    public boolean isDebugModeEnabled() {
        return this.getBoolean(ConfigYAML.formPath("general", "debug-mode"));
    }

    public boolean isSafeTeleportEnabled() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "enable-safe-teleport"));
    }

    public boolean isDimensionalTeleportationEnabled() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "dimensional-teleportation"));
    }

    public boolean isTeleportSoundEnabled() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "play-sound"));
    }

    public boolean isRestrictedWorldsEnabled() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "restricted-worlds", "enable"));
    }

    public String getRestrictedWorldsMode() {
        return this.getString(ConfigYAML.formPath("teleport-options", "restricted-worlds", "mode"));
    }

    public List<String> getRestrictedWorldsList() {
        return this.getStringList(ConfigYAML.formPath("teleport-options", "restricted-worlds", "worlds"));
    }

    public boolean isWarmupEnabled() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "warmup", "enable"));
    }

    public int getWarmupTime() {
        return this.getInt(ConfigYAML.formPath("teleport-options", "warmup", "time"));
    }

    public boolean isWarmupCancelOnMove() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "warmup", "cancel-on-move"));
    }

    public boolean isWarmupShowOnActionBar() {
        return this.getBoolean(ConfigYAML.formPath("teleport-options", "warmup", "show-on-actionbar"));
    }

    public boolean isLimitsEnabled() {
        return this.getBoolean(ConfigYAML.formPath("limits", "enabled"));
    }

    public int getDefaultHomeLimit() {
        return this.getInt(ConfigYAML.formPath("limits", "default"));
    }

    public String getMainCommand() {
        return this.getString(ConfigYAML.formPath("commands", "main", "command"));
    }

    public String getMainCommandDescription() {
        return this.getString(ConfigYAML.formPath("commands", "main", "description"));
    }

    public String getMainCommandPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "permission"));
    }

    public List<String> getMainCommandAliases() {
        return this.getStringList(ConfigYAML.formPath("commands", "main", "aliases"));
    }

    public String getMainCommandHelpPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "help", "permission"));
    }

    public String getMainCommandInfoPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "info", "permission"));
    }

    public String getMainCommandVersionPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "version", "permission"));
    }

    public String getMainCommandVersionUpdatePermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "version", "update", "permission"));
    }

    public String getMainCommandReloadPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "reload", "permission"));
    }

    public String getMainCommandNearHomesPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "nearhomes", "permission"));
    }

    public double getMainCommandNearHomesLimit() {
        return this.getDouble(ConfigYAML.formPath("commands", "main", "nearhomes", "limit"));
    }

    public String getMainCommandParsePermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "parse", "permission"));
    }

    public String getMainCommandConverterPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "converter", "permission"));
    }

    public String getMainCommandImportExportPermission() {
        return this.getString(ConfigYAML.formPath("commands", "main", "importexport", "permission"));
    }

    public String getSetHomeCommand() {
        return this.getString(ConfigYAML.formPath("commands", "sethome", "command"));
    }

    public String getSetHomeCommandDescription() {
        return this.getString(ConfigYAML.formPath("commands", "sethome", "description"));
    }

    public String getSetHomeCommandPermission() {
        return this.getString(ConfigYAML.formPath("commands", "sethome", "permission"));
    }

    public List<String> getSetHomeCommandAliases() {
        return this.getStringList(ConfigYAML.formPath("commands", "sethome", "aliases"));
    }

    public double getSetHomeCommandCooldown() {
        return this.getDouble(ConfigYAML.formPath("commands", "sethome", "cooldown"));
    }

    public double getSetHomeCommandCost() {
        return this.getDouble(ConfigYAML.formPath("commands", "sethome", "command-cost"));
    }

    public String getSetHomeOthersPermission() {
        return this.getString(ConfigYAML.formPath("commands", "sethome", "others", "permission"));
    }

    public String getDelHomeCommand() {
        return this.getString(ConfigYAML.formPath("commands", "delhome", "command"));
    }

    public String getDelHomeCommandDescription() {
        return this.getString(ConfigYAML.formPath("commands", "delhome", "description"));
    }

    public String getDelHomeCommandPermission() {
        return this.getString(ConfigYAML.formPath("commands", "delhome", "permission"));
    }

    public List<String> getDelHomeCommandAliases() {
        return this.getStringList(ConfigYAML.formPath("commands", "delhome", "aliases"));
    }

    public double getDelHomeCommandCooldown() {
        return this.getDouble(ConfigYAML.formPath("commands", "delhome", "cooldown"));
    }

    public double getDelHomeCommandCost() {
        return this.getDouble(ConfigYAML.formPath("commands", "delhome", "command-cost"));
    }

    public String getDelHomeOthersPermission() {
        return this.getString(ConfigYAML.formPath("commands", "delhome", "others", "permission"));
    }

    public String getHomesCommand() {
        return this.getString(ConfigYAML.formPath("commands", "homes", "command"));
    }

    public String getHomesCommandDescription() {
        return this.getString(ConfigYAML.formPath("commands", "homes", "description"));
    }

    public String getHomesCommandPermission() {
        return this.getString(ConfigYAML.formPath("commands", "homes", "permission"));
    }

    public List<String> getHomesCommandAliases() {
        return this.getStringList(ConfigYAML.formPath("commands", "homes", "aliases"));
    }

    public double getHomesCommandCooldown() {
        return this.getDouble(ConfigYAML.formPath("commands", "homes", "cooldown"));
    }

    public double getHomesCommandCost() {
        return this.getDouble(ConfigYAML.formPath("commands", "homes", "command-cost"));
    }

    public String getHomesDisplayType() {
        return this.getString(ConfigYAML.formPath("commands", "homes", "type"));
    }

    public String getHomesOthersPermission() {
        return this.getString(ConfigYAML.formPath("commands", "homes", "others", "permission"));
    }

    public String getHomeCommand() {
        return this.getString(ConfigYAML.formPath("commands", "home", "command"));
    }

    public String getHomeCommandDescription() {
        return this.getString(ConfigYAML.formPath("commands", "home", "description"));
    }

    public String getHomeCommandPermission() {
        return this.getString(ConfigYAML.formPath("commands", "home", "permission"));
    }

    public List<String> getHomeCommandAliases() {
        return this.getStringList(ConfigYAML.formPath("commands", "home", "aliases"));
    }

    public double getHomeCommandCooldown() {
        return this.getDouble(ConfigYAML.formPath("commands", "home", "cooldown"));
    }

    public double getHomeCommandCost() {
        return this.getDouble(ConfigYAML.formPath("commands", "home", "command-cost"));
    }

    public String getHomeOthersPermission() {
        return this.getString(ConfigYAML.formPath("commands", "home", "others", "permission"));
    }

    public String getHomeRenamePermission() {
        return this.getString(ConfigYAML.formPath("commands", "home", "rename", "permission"));
    }

    public double getHomeRenameCommandCost() {
        return this.getDouble(ConfigYAML.formPath("commands", "home", "rename", "command-cost"));
    }

    public String getBypassLimitPermission() {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "limit"));
    }

    public String getBypassDimensionalTeleportationPermission() {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "dimensional-teleportation"));
    }

    public String getBypassSafeTeleportationPermission() {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "safe-teleportation"));
    }

    public String getBypassRestrictedWorldsPermission() {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "restricted-worlds"));
    }

    public String getBypassWarmupPermission() {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "warmup"));
    }

    public String getBypassCommandCostPermission(String commandPermission) {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "command-cost")).replace("%command_permission%", commandPermission);
    }

    public String getBypassCommandCooldownPermission(String commandPermission) {
        return this.getString(ConfigYAML.formPath("permissions", "bypass", "command-cooldown")).replace("%command_permission%", commandPermission);
    }
}

