/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.zHomes;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MainImportSubCommand
implements SubCommand {
    @Override
    @NotNull
    public String name() {
        return "import";
    }

    @Override
    public List<String> aliases() {
        return List.of("importar");
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getMainCommandImportExportPermission();
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getMainImportUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        String fileName = args[0];
        File file = new File(zHomes.getInstance().getDataFolder(), fileName + ".json.gz");
        if (fileName.endsWith("json.gz")) {
            file = new File(zHomes.getInstance().getDataFolder(), fileName);
        }
        if (!file.exists()) {
            this.message(sender, zHomes.getLanguageYAML().getMainImportFileNotFound(file.getAbsolutePath()));
        }
        DatabaseEditor.importDatabase(file, sender);
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        File[] files = zHomes.getInstance().getDataFolder().listFiles();
        if (files != null) {
            for (File file : files) {
                int dotIndex;
                String name;
                if (!file.isFile() || !(name = file.getName()).endsWith(".json.gz") || (dotIndex = name.lastIndexOf(".json.gz")) <= 0) continue;
                completions.add(name.substring(0, dotIndex));
            }
        }
        return completions;
    }
}

