/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.RenameHomeEvent;
import java.util.List;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class HomeRenameSubCommand
extends HomesUtils
implements SubCommand {
    @Override
    @NotNull
    public String name() {
        return "rename";
    }

    @Override
    public List<String> aliases() {
        return List.of("renomear");
    }

    @Override
    public int minArgs() {
        return 2;
    }

    @Override
    public int maxArgs() {
        return 2;
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getHomeRenamePermission();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getHomeRenameUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        Player player = (Player)sender;
        String home = args[0];
        String newName = args[1];
        if (home.equals(newName)) {
            this.message((CommandSender)player, zHomes.getLanguageYAML().getHomeRenameSameName());
            return;
        }
        if (!HomeRenameSubCommand.hasHome((OfflinePlayer)player, home)) {
            this.message((CommandSender)player, zHomes.getLanguageYAML().getHomeDoesntExist());
            return;
        }
        if (HomeRenameSubCommand.hasHome((OfflinePlayer)player, newName)) {
            this.message((CommandSender)player, zHomes.getLanguageYAML().getHomeAlreadyExist());
            return;
        }
        RenameHomeEvent event = new RenameHomeEvent(player, home, newName);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        home = event.getHome();
        newName = event.getNewName();
        if (HookRegistry.VAULT.canAfford(player, zHomes.getConfigYAML().getHomeRenamePermission(), zHomes.getConfigYAML().getHomeRenameCommandCost())) {
            HomeRenameSubCommand.renameHome((OfflinePlayer)player, home, newName);
            this.message((CommandSender)player, zHomes.getLanguageYAML().getHomeRenameOutput(home, newName));
        }
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return this.isPlayer(sender) ? HomeRenameSubCommand.homesW((OfflinePlayer)((Player)sender)) : List.of();
    }
}

