/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes;

import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.HashMap;
import me.yleoft.zHomes.commands.DelhomeCommand;
import me.yleoft.zHomes.commands.HomeCommand;
import me.yleoft.zHomes.commands.HomesCommand;
import me.yleoft.zHomes.commands.MainCommand;
import me.yleoft.zHomes.commands.SethomeCommand;
import me.yleoft.zHomes.configuration.ConfigYAML;
import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.configuration.menus.menuhomesYAML;
import me.yleoft.zHomes.libs.nbtapi.NBT;
import me.yleoft.zHomes.libs.zAPI.configuration.Path;
import me.yleoft.zHomes.libs.zAPI.hooks.HookPlaceholderAPI;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.libs.bstats.bukkit.Metrics;
import me.yleoft.zHomes.libs.zAPI.libs.bstats.charts.SimplePie;
import me.yleoft.zHomes.libs.zAPI.logging.Logger;
import me.yleoft.zHomes.libs.zAPI.utility.ExternalDependencyManager;
import me.yleoft.zHomes.libs.zAPI.utility.PluginYAML;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import me.yleoft.zHomes.listeners.GriefPreventionListeners;
import me.yleoft.zHomes.listeners.PlayerListeners;
import me.yleoft.zHomes.listeners.WorldGuardListeners;
import me.yleoft.zHomes.storage.DatabaseConnection;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.utility.LanguageUtils;
import me.yleoft.zHomes.utility.UpdateUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class zHomes
extends JavaPlugin {
    public static ConfigYAML config;
    public static menuhomesYAML menuHomes;
    ExternalDependencyManager mgr = new ExternalDependencyManager();
    private static zHomes instance;
    public static Logger logger;
    public static UpdateUtils updateUtils;
    public Component pluginPrefix;
    public static String bc;
    public static String wc;

    public static zHomes getInstance() {
        return instance;
    }

    public void onLoad() {
        zAPI.setPlugin(this);
        instance = this;
        logger = new Logger(this.pluginPrefix);
        zAPI.setPluginLogger(logger);
        me.yleoft.zHomes.hooks.HookRegistry.registerHooks();
        zAPI.preload(this);
    }

    public void onEnable() {
        Class<?> driver2;
        zAPI.init(this, NBT.preloadApi());
        config = new ConfigYAML();
        this.pluginPrefix = TextFormatter.transform(config.getString("prefix"));
        logger.setPrefix(this.pluginPrefix);
        boolean debugMode = config.isDebugModeEnabled();
        logger.setDebugMode(debugMode);
        zAPI.getLogger().setDebugMode(debugMode);
        logger.info("%bc| ------------------------------------------------------- |\n%bc|%tc               _   _                                     %bc|\n%bc|%tc           ___| | | | ___  _ __ ___   ___  ___           %bc|\n%bc|%tc          |_  / |_| |/ _ \\| '_ ` _ \\ / _ \\/ __|          %bc|\n%bc|%tc           / /|  _  | (_) | | | | | |  __/\\__ \\          %bc|\n%bc|%tc          /___|_| |_|\\___/|_| |_| |_|\\___||___/          %bc|\n%bc|                                                         |\n%bc|                     %wcMade by yLeoft                      %bc|\n%bc|                     %wcVersion: %v             %bc|\n".replace("%v", (CharSequence)(this.getPluginMeta().getVersion().contains("-SNAPSHOT") ? this.getPluginMeta().getVersion() : this.getPluginMeta().getVersion() + "         ")).replace("%bc", bc).replace("%tc", "<red>").replace("%wc", wc));
        updateUtils = new UpdateUtils(this);
        logger.info("%bc| ------------------------------------------------------- |".replace("%bc", bc));
        logger.info("<white>Loading plugin files...");
        logger.info("<yellow>> Checking language files...");
        LanguageUtils.loadLanguages();
        logger.info("<yellow>> Checking menu files...");
        menuHomes = new menuhomesYAML();
        logger.info("<green>All files ready.");
        logger.info("<white>Downloading external libraries...");
        ExternalDependencyManager.STATIC_DIRECTORY = new File(this.getDataFolder(), "libs");
        this.mgr = new ExternalDependencyManager();
        this.mgr.registerDependency("mysql", URI.create("https://repo1.maven.org/maven2/mysql/mysql-connector-java/8.0.23/mysql-connector-java-8.0.23.jar"));
        this.mgr.registerDependency("mariadb", URI.create("https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.5.3/mariadb-java-client-3.5.3.jar"));
        this.mgr.registerDependency("h2", URI.create("https://repo1.maven.org/maven2/com/h2database/h2/2.3.232/h2-2.3.232.jar"));
        this.mgr.registerDependency("sqlite", URI.create("https://repo1.maven.org/maven2/org/xerial/sqlite-jdbc/3.51.1.0/sqlite-jdbc-3.51.1.0.jar"));
        try {
            DatabaseConnection.mysqlDriverLoader = this.mgr.loadIsolated("mysql", ExternalDependencyManager.class.getClassLoader());
            driver2 = Class.forName("com.mysql.cj.jdbc.Driver", true, DatabaseConnection.mysqlDriverLoader);
            DatabaseConnection.mysqldriverClass = driver2;
            logger.info("<yellow>> Loaded MySQL Driver.");
            logger.debug("<yellow>" + driver2.getName() + " loaded by " + String.valueOf(driver2.getClassLoader()));
        }
        catch (Exception driver2) {
            // empty catch block
        }
        try {
            DatabaseConnection.mariadbDriverLoader = this.mgr.loadIsolated("mariadb", ExternalDependencyManager.class.getClassLoader());
            driver2 = Class.forName("org.mariadb.jdbc.Driver", true, DatabaseConnection.mariadbDriverLoader);
            DatabaseConnection.mariadbdriverClass = driver2;
            logger.info("<yellow>> Loaded MariaDB Driver.");
            logger.debug("<yellow>" + driver2.getName() + " loaded by " + String.valueOf(driver2.getClassLoader()));
        }
        catch (Exception driver3) {
            // empty catch block
        }
        try {
            DatabaseConnection.h2DriverLoader = this.mgr.loadIsolated("h2", ExternalDependencyManager.class.getClassLoader());
            driver2 = Class.forName("org.h2.Driver", true, DatabaseConnection.h2DriverLoader);
            DatabaseConnection.h2driverClass = driver2;
            logger.info("<yellow>> Loaded H2 Driver.");
            logger.debug("<yellow>" + driver2.getName() + " loaded by " + String.valueOf(driver2.getClassLoader()));
        }
        catch (Exception driver4) {
            // empty catch block
        }
        try {
            DatabaseConnection.sqliteDriverLoader = this.mgr.loadIsolated("sqlite", ExternalDependencyManager.class.getClassLoader());
            driver2 = Class.forName("org.sqlite.JDBC", true, DatabaseConnection.sqliteDriverLoader);
            DatabaseConnection.sqlitedriverClass = driver2;
            logger.info("<yellow>> Loaded SQLite Driver.");
            logger.debug("<yellow>" + driver2.getName() + " loaded by " + String.valueOf(driver2.getClassLoader()));
        }
        catch (Exception driver5) {
            // empty catch block
        }
        logger.info("<green>All external libraries have been loaded!");
        logger.info("<white>Initializing database connection...");
        DatabaseConnection.connect();
        DatabaseEditor.createTable(DatabaseEditor.databaseTable(), "(UUID VARCHAR(36),HOME VARCHAR(100),LOCATION VARCHAR(255),PRIMARY KEY (UUID, HOME))");
        logger.info("<green>Database connection has been established!");
        logger.info("<white>Enabling hooks...");
        HookPlaceholderAPI.message = "<yellow>PlaceholderAPI hooked successfully!";
        HookRegistry.load();
        zAPI.setPlaceholdersHandler(me.yleoft.zHomes.hooks.HookRegistry.PLUGIN_PAPI);
        logger.info("<green>All hooks have been enabled!");
        logger.info("<yellow>Loading commands & events...");
        this.loadCommands();
        this.registerEvents();
        logger.info("<green>All commands have been loaded!");
        logger.info("<yellow>Enabling bStats metrics...");
        try {
            int bStatsID = 25021;
            new zHomesMetrics(this, bStatsID);
        }
        catch (Exception exception) {
            logger.warn("Failed to create a bStats instance.", exception);
        }
        logger.info("<green>bStats metrics enabled! Thank you for helping us improve zHomes.");
    }

    public void onDisable() {
        try {
            DatabaseConnection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeLoader(DatabaseConnection.mysqlDriverLoader);
        this.closeLoader(DatabaseConnection.mariadbDriverLoader);
        this.closeLoader(DatabaseConnection.h2DriverLoader);
        this.closeLoader(DatabaseConnection.sqliteDriverLoader);
        zAPI.disable();
        instance = null;
    }

    private void closeLoader(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            try {
                ucl.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadCommands() {
        PluginYAML.unregisterCommands();
        PluginYAML.registerCommand(new MainCommand());
        PluginYAML.registerCommand(new SethomeCommand());
        PluginYAML.registerCommand(new DelhomeCommand());
        PluginYAML.registerCommand(new HomesCommand());
        PluginYAML.registerCommand(new HomeCommand());
        try {
            PluginYAML.unregisterPermissions();
            HashMap<String, Boolean> helpANDmainChildren = new HashMap<String, Boolean>();
            helpANDmainChildren.put(zHomes.getConfigYAML().getMainCommandPermission(), true);
            helpANDmainChildren.put(zHomes.getConfigYAML().getMainCommandHelpPermission(), true);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + "' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandHelpPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " (help|?)' command (With perm)", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandVersionPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " (version|ver)' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandVersionUpdatePermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " (version|ver) update' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandInfoPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " info' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandReloadPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " (reload|rl)' command", PermissionDefault.OP, helpANDmainChildren);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandNearHomesPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " nearhomes' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandParsePermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " parse' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandConverterPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " converter' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getMainCommandImportExportPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getMainCommand() + " (export|import)' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getSetHomeCommandPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getSetHomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getDelHomeCommandPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getDelHomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getDelHomeOthersPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getDelHomeCommand() + " (Player:Home)' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getHomesCommandPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getHomesCommand() + "' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getHomesOthersPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getHomesCommand() + " (Player)' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getHomeCommandPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getHomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getHomeRenamePermission(), "Permission to use the '/" + zHomes.getConfigYAML().getHomeCommand() + " rename (Home) (NewName)' command", PermissionDefault.TRUE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getHomeOthersPermission(), "Permission to use the '/" + zHomes.getConfigYAML().getHomeCommand() + " (Player:Home)' command", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getBypassLimitPermission(), "Bypass homes limit", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getBypassSafeTeleportationPermission(), "Bypass safe teleport", PermissionDefault.FALSE);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getBypassDimensionalTeleportationPermission(), "Bypass dimensional teleportation config", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getBypassRestrictedWorldsPermission(), "Bypass restricted worlds", PermissionDefault.OP);
            PluginYAML.registerPermission(zHomes.getConfigYAML().getBypassWarmupPermission(), "Bypass teleportation warmup time", PermissionDefault.OP);
        }
        catch (Exception e) {
            this.getLoggerInstance().warn("Failed to register permissions. Don't worry, this affects nothing in general.", e);
        }
    }

    public void registerEvents() {
        logger.debug("<yellow>Registering event listeners...");
        logger.debug("<yellow>> PlayerListeners");
        PluginYAML.registerEvent(new PlayerListeners());
        if (me.yleoft.zHomes.hooks.HookRegistry.WORLDGUARD.exists()) {
            logger.debug("<yellow>> WorldGuardListeners");
            PluginYAML.registerEvent(new WorldGuardListeners());
        }
        if (me.yleoft.zHomes.hooks.HookRegistry.GRIEF_PREVENTION.exists()) {
            logger.debug("<yellow>> GriefPreventionListeners");
            PluginYAML.registerEvent(new GriefPreventionListeners());
        }
    }

    @NotNull
    public FileConfiguration getConfig() {
        return config.getConfig();
    }

    public static ConfigYAML getConfigYAML() {
        return config;
    }

    public static LanguageBuilder getLanguageYAML() {
        return LanguageUtils.currentLanguageYAML;
    }

    public void saveDefaultConfig() {
        this.reloadConfig();
    }

    public void reloadConfig() {
        config = new ConfigYAML();
    }

    public Logger getLoggerInstance() {
        return logger;
    }

    static {
        bc = "<green>";
        wc = "<gold>";
    }

    private static class zHomesMetrics
    extends Metrics {
        public zHomesMetrics(@NotNull JavaPlugin plugin, int id) {
            super((Plugin)plugin, id);
            this.addCustomChart(new SimplePie("database_type", () -> {
                String dbType = config.getString(Path.formPath("database.type"), "H2");
                return switch (dbType.toLowerCase()) {
                    case "sqlite" -> "SQLite";
                    case "mysql" -> "MySQL";
                    case "mariadb" -> "MariaDB";
                    default -> "H2";
                };
            }));
            this.addCustomChart(new SimplePie("language", () -> {
                String language = config.getString(Path.formPath("general.lang"), "en");
                return switch (language.toLowerCase()) {
                    case "de" -> "German";
                    case "en" -> "English";
                    case "es" -> "Spanish";
                    case "fr" -> "French";
                    case "it" -> "Italian";
                    case "nl" -> "Dutch";
                    case "pl" -> "Polish";
                    case "pt_br" -> "Portuguese (Brazil)";
                    case "ru" -> "Russian";
                    case "zhcn" -> "Chinese (Simplified)";
                    default -> "Custom";
                };
            }));
            this.addCustomChart(new SimplePie("auto_update", () -> {
                boolean autoUpdate = config.getBoolean(Path.formPath("general.auto-update"), false);
                return autoUpdate ? "Enabled" : "Disabled";
            }));
        }
    }
}

