/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.listeners;

import com.zhomes.api.event.player.ExecuteHomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteSethomeCommandEvent;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.libs.zAPI.libs.folialib.wrapper.task.WrappedTask;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.utility.UpdateUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListeners
extends HomesUtils
implements Listener {
    private final ConcurrentHashMap<UUID, Long> lastAnnounced = new ConcurrentHashMap();

    public PlayerListeners() {
        zAPI.getScheduler().runTimerAsync(task -> {
            long cutoff = System.currentTimeMillis() - 1800000L;
            this.lastAnnounced.entrySet().removeIf(entry -> (Long)entry.getValue() < cutoff);
            for (Map.Entry<UUID, WrappedTask> entry2 : HomesUtils.warmups.entrySet()) {
                UUID uuid = entry2.getKey();
                WrappedTask wrappedTask = entry2.getValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player != null && player.isOnline()) continue;
                if (wrappedTask != null) {
                    try {
                        wrappedTask.cancel();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                HomesUtils.warmups.remove(uuid);
            }
        }, 12000L, 12000L);
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (this.lastAnnounced.containsKey(uuid)) {
            long lastTime = this.lastAnnounced.get(uuid);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTime <= 1800000L) {
                return;
            }
        }
        if (zHomes.updateUtils.needsUpdate && zHomes.getConfigYAML().isAnnounceUpdateEnabled() && (p.isOp() || p.hasPermission(zHomes.getConfigYAML().getMainCommandVersionUpdatePermission()))) {
            this.lastAnnounced.put(uuid, System.currentTimeMillis());
            zAPI.getScheduler().runLater(() -> {
                if (!p.isOnline()) {
                    return;
                }
                LanguageBuilder.sendMessage((CommandSender)p, "%prefix% <gold>You are using an outdated version of zHomes! Please update to the latest version.");
                LanguageBuilder.sendMessage((CommandSender)p, "%prefix% <gold>New version: <green>" + zHomes.updateUtils.updateVersion);
                LanguageBuilder.sendMessage((CommandSender)p, "%prefix% <gold>Your version: <red>" + zHomes.getInstance().getPluginMeta().getVersion());
                LanguageBuilder.sendMessage((CommandSender)p, "%prefix% <gold>You can update your plugin here: <yellow>" + UpdateUtils.site);
            }, 60L);
        }
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        WrappedTask wrappedTask = HomesUtils.warmups.remove(uuid);
        if (wrappedTask != null) {
            try {
                wrappedTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (HomesUtils.warmups.containsKey(uuid) && zHomes.getConfigYAML().isWarmupCancelOnMove()) {
            WrappedTask wrappedTask;
            Location from = e.getFrom();
            Location to = e.getTo();
            if (to == null) {
                return;
            }
            if ((from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) && (wrappedTask = HomesUtils.warmups.remove(uuid)) != null) {
                wrappedTask.cancel();
                LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getWarmupCancelled());
                LanguageBuilder.sendActionBar((CommandSender)p, zHomes.getLanguageYAML().getWarmupCancelledActionbar());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteSethomeCommand(PreExecuteSethomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!PlayerListeners.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getWorldRestrictedSethome());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteHomeCommand(ExecuteHomeCommandEvent e) {
        Player p = e.getPlayer();
        if (PlayerListeners.hasHome((OfflinePlayer)p, e.getHome()) && !PlayerListeners.isAllowedInWorld(p, HomesUtils.getHomeLoc((OfflinePlayer)p, e.getHome()).getWorld())) {
            e.setCancelled(true);
            LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getWorldRestrictedHome());
        }
    }
}

