/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PluginYAML {
    private static final PluginDescriptionFile DESCRIPTION_FILE = zAPI.getPlugin().getDescription();
    private static final Map<Command, Double> REGISTERED_COMMANDS = new ConcurrentHashMap<Command, Double>();
    private static final Map<Command, me.yleoft.zHomes.libs.zAPI.command.Command> COMMAND_INSTANCES = new ConcurrentHashMap<Command, me.yleoft.zHomes.libs.zAPI.command.Command>();
    private static final Set<String> REGISTERED_PERMISSIONS = ConcurrentHashMap.newKeySet();
    public static final Map<Player, Long> cacheCooldown = new HashMap<Player, Long>();
    public static final TabExecutor emptyExec = new TabExecutor(){

        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
            return false;
        }

        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
            return List.of();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommandMap getCommandMap() throws ReflectiveOperationException {
        if (ReflectionCache.commandMapCache != null) {
            return ReflectionCache.commandMapCache;
        }
        Class<PluginYAML> clazz = PluginYAML.class;
        synchronized (PluginYAML.class) {
            if (ReflectionCache.commandMapCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ReflectionCache.commandMapCache;
            }
            if (ReflectionCache.commandMapField == null) {
                ReflectionCache.commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                ReflectionCache.commandMapField.setAccessible(true);
            }
            ReflectionCache.commandMapCache = (CommandMap)ReflectionCache.commandMapField.get(Bukkit.getPluginManager());
            // ** MonitorExit[var0] (shouldn't be in output)
            return ReflectionCache.commandMapCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Command> getKnownCommands(CommandMap commandMap) throws ReflectiveOperationException {
        if (ReflectionCache.knownCommandsField != null) return (Map)ReflectionCache.knownCommandsField.get(commandMap);
        Class<PluginYAML> clazz = PluginYAML.class;
        synchronized (PluginYAML.class) {
            if (ReflectionCache.knownCommandsField != null) return (Map)ReflectionCache.knownCommandsField.get(commandMap);
            ReflectionCache.knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            ReflectionCache.knownCommandsField.setAccessible(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Map)ReflectionCache.knownCommandsField.get(commandMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void syncCommands() {
        try {
            if (ReflectionCache.syncCommandsMethod == null) {
                Class<PluginYAML> clazz = PluginYAML.class;
                // MONITORENTER : me.yleoft.zHomes.libs.zAPI.utility.PluginYAML.class
                if (ReflectionCache.syncCommandsMethod == null) {
                    ReflectionCache.syncCommandsMethod = zAPI.getPlugin().getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
                    ReflectionCache.syncCommandsMethod.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            ReflectionCache.syncCommandsMethod.invoke((Object)zAPI.getPlugin().getServer(), new Object[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (ReflectiveOperationException e) {
            zAPI.getPluginLogger().warn("Failed to sync commands", e);
        }
    }

    private static Set<String> generateCommandKeys(Command command, String pluginPrefix) {
        HashSet<String> keys = new HashSet<String>();
        String label = command.getLabel().toLowerCase(Locale.ROOT);
        String name = command.getName().toLowerCase(Locale.ROOT);
        keys.add(label);
        keys.add(name);
        command.getAliases().forEach(alias -> keys.add(alias.toLowerCase(Locale.ROOT)));
        if (!pluginPrefix.isEmpty()) {
            keys.add(pluginPrefix + ":" + label);
            keys.add(pluginPrefix + ":" + name);
            command.getAliases().forEach(alias -> keys.add(pluginPrefix + ":" + alias.toLowerCase(Locale.ROOT)));
        }
        return keys;
    }

    private static boolean isOwnedByPlugin(Command command) {
        if (command instanceof PluginCommand) {
            PluginCommand pluginCommand = (PluginCommand)command;
            try {
                Plugin owner = pluginCommand.getPlugin();
                return owner != null && owner.equals((Object)zAPI.getPlugin());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void unregisterCommands() {
        try {
            CommandMap commandMap = PluginYAML.getCommandMap();
            Map<String, Command> knownCommands = PluginYAML.getKnownCommands(commandMap);
            String pluginPrefix = Optional.of(Version.getName()).map(name -> name.toLowerCase(Locale.ROOT)).orElse("");
            HashSet<String> keysToRemove = new HashSet<String>();
            for (Command command : REGISTERED_COMMANDS.keySet()) {
                Set<String> commandKeys = PluginYAML.generateCommandKeys(command, pluginPrefix);
                for (String key : commandKeys) {
                    Command registered = knownCommands.get(key);
                    if (registered == null || !registered.equals(command) && !PluginYAML.isOwnedByPlugin(registered)) continue;
                    keysToRemove.add(key);
                    try {
                        registered.unregister(commandMap);
                    }
                    catch (Exception exception) {}
                }
                if (command instanceof PluginCommand) {
                    PluginCommand pluginCommand = (PluginCommand)command;
                    pluginCommand.setExecutor((CommandExecutor)emptyExec);
                    pluginCommand.setTabCompleter((TabCompleter)emptyExec);
                }
                keysToRemove.forEach(knownCommands::remove);
                REGISTERED_COMMANDS.clear();
                COMMAND_INSTANCES.clear();
            }
        }
        catch (Exception exception) {
            zAPI.getPluginLogger().error("Failed to unregister commands", exception);
        }
    }

    public static void unregisterCommand(@NotNull String commandName) {
        try {
            CommandMap commandMap = PluginYAML.getCommandMap();
            Map<String, Command> knownCommands = PluginYAML.getKnownCommands(commandMap);
            String cmdLower = commandName.toLowerCase(Locale.ROOT);
            String pluginPrefix = Optional.of(Version.getName()).map(name -> name.toLowerCase(Locale.ROOT)).orElse("");
            HashSet<Command> matchingCommands = new HashSet<Command>();
            for (Command command2 : REGISTERED_COMMANDS.keySet()) {
                if (!command2.getLabel().equalsIgnoreCase(commandName) && !command2.getName().equalsIgnoreCase(commandName) && !command2.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(commandName))) continue;
                matchingCommands.add(command2);
            }
            HashSet<Object> keysToCheck = new HashSet<Object>();
            keysToCheck.add(cmdLower);
            if (!pluginPrefix.isEmpty()) {
                keysToCheck.add(pluginPrefix + ":" + cmdLower);
            }
            for (String string : keysToCheck) {
                Command registered = knownCommands.get(string);
                if (registered == null || !matchingCommands.contains(registered) && !PluginYAML.isOwnedByPlugin(registered)) continue;
                try {
                    registered.unregister(commandMap);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                knownCommands.remove(string);
            }
            matchingCommands.forEach(command -> {
                if (command instanceof PluginCommand) {
                    PluginCommand pluginCommand = (PluginCommand)command;
                    pluginCommand.setExecutor((CommandExecutor)emptyExec);
                    pluginCommand.setTabCompleter((TabCompleter)emptyExec);
                }
                REGISTERED_COMMANDS.remove(command);
                COMMAND_INSTANCES.remove(command);
            });
        }
        catch (Exception e) {
            zAPI.getPluginLogger().warn("Error unregistering command: " + commandName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerCommand(me.yleoft.zHomes.libs.zAPI.command.Command commandClass) {
        String command = commandClass.name();
        String description = commandClass.description();
        List<String> aliases = commandClass.aliases();
        if (DESCRIPTION_FILE.getCommands().containsKey(command)) {
            zAPI.getPluginLogger().warn("<red>Command <yellow>/%s<red> is already registered in plugin.yml!".formatted(command));
            return;
        }
        try {
            if (ReflectionCache.pluginCommandConstructor == null) {
                Class<PluginYAML> clazz = PluginYAML.class;
                // MONITORENTER : me.yleoft.zHomes.libs.zAPI.utility.PluginYAML.class
                if (ReflectionCache.pluginCommandConstructor == null) {
                    ReflectionCache.pluginCommandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                    ReflectionCache.pluginCommandConstructor.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            PluginCommand cmd = ReflectionCache.pluginCommandConstructor.newInstance(command, zAPI.getPlugin());
            cmd.setDescription(description);
            cmd.setExecutor((CommandExecutor)commandClass);
            cmd.setTabCompleter((TabCompleter)commandClass);
            if (aliases != null && !aliases.isEmpty()) {
                cmd.setAliases(aliases);
            }
            CommandMap commandMap = PluginYAML.getCommandMap();
            commandMap.register(Version.getName(), (Command)cmd);
            REGISTERED_COMMANDS.put((Command)cmd, commandClass.cooldownTime());
            COMMAND_INSTANCES.put((Command)cmd, commandClass);
            zAPI.getPluginLogger().info("<green>Loaded command <yellow>/%s".formatted(command));
            return;
        }
        catch (Exception exception) {
            zAPI.getPluginLogger().error("<red>Failed to register command /%s".formatted(command), exception);
        }
    }

    public static boolean isCommandRegistered(@NotNull String command) {
        return DESCRIPTION_FILE.getCommands().containsKey(command);
    }

    public static void unregisterPermissions() {
        REGISTERED_PERMISSIONS.forEach(PluginYAML::unregisterPermission);
    }

    public static void unregisterPermission(@NotNull String permission) {
        Bukkit.getPluginManager().removePermission(permission);
        REGISTERED_PERMISSIONS.remove(permission);
    }

    public static void unregisterPermission(@NotNull Permission permission) {
        Bukkit.getPluginManager().removePermission(permission);
        REGISTERED_PERMISSIONS.remove(permission.getName());
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description, @Nullable PermissionDefault defaultValue, @Nullable Map<String, Boolean> children) {
        if (Bukkit.getPluginManager().getPermission(permission) == null) {
            Permission perm = new Permission(permission, description, defaultValue, children);
            Bukkit.getPluginManager().addPermission(perm);
        }
        REGISTERED_PERMISSIONS.add(permission);
    }

    public static void registerPermission(@NotNull String permission) {
        PluginYAML.registerPermission(permission, null, null, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description) {
        PluginYAML.registerPermission(permission, description, null, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable PermissionDefault defaultValue) {
        PluginYAML.registerPermission(permission, null, defaultValue, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description, @Nullable PermissionDefault defaultValue) {
        PluginYAML.registerPermission(permission, description, defaultValue, null);
    }

    public static void registerTabCompleter(@NotNull String command, @NotNull TabCompleter tabCompleter) {
        Optional.ofNullable(zAPI.getPlugin().getCommand(command)).ifPresent(cmd -> cmd.setTabCompleter(tabCompleter));
    }

    public static void registerEvent(@NotNull Listener listener) {
        zAPI.getPlugin().getServer().getPluginManager().registerEvents(listener, (Plugin)zAPI.getPlugin());
    }

    public static Map<Command, Double> getCmds() {
        return Collections.unmodifiableMap(REGISTERED_COMMANDS);
    }

    @Nullable
    public static me.yleoft.zHomes.libs.zAPI.command.Command getCommandInstance(@NotNull Command command) {
        return COMMAND_INSTANCES.get(command);
    }

    static final class ReflectionCache
    extends PluginYAML {
        private static volatile CommandMap commandMapCache;
        private static volatile Field commandMapField;
        private static volatile Field knownCommandsField;
        private static volatile Constructor<PluginCommand> pluginCommandConstructor;
        private static volatile Method syncCommandsMethod;

        private ReflectionCache() {
        }
    }
}

