/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.yleoft.zHomes.libs.zAPI.update.ModrinthDownloader;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class UpdateManager {
    private final JavaPlugin plugin;
    private final String url;
    private final String id;

    public UpdateManager(@NotNull JavaPlugin plugin, @NotNull String url, @NotNull String modrinthId) {
        this.plugin = plugin;
        this.url = url;
        this.id = modrinthId;
    }

    public String getVersion() {
        try {
            String jsonString = UpdateManager.readUrl(this.url);
            JsonArray json = (JsonArray)new JsonParser().parse(jsonString);
            JsonObject item = (JsonObject)json.get(0);
            return item.get("name").toString().replace("\"", "");
        }
        catch (Exception exception) {
            zAPI.getLogger().warn("Failed to retrieve the latest version from " + this.url, exception);
            return Version.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(@NotNull String urlString) throws Exception {
        try (BufferedReader reader = null;){
            int read;
            URL url = new URL(urlString);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder buffer = new StringBuilder();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
    }

    public String update() {
        try {
            File file = UpdateManager.locateJarInPlugins(this.plugin).toFile();
            file.delete();
            File directory = this.plugin.getDataFolder().getParentFile();
            String pluginName = Version.getName();
            String path = String.valueOf(directory) + "/" + pluginName + "-" + this.getVersion() + ".jar";
            File newFile = new File(path);
            UpdateManager.downloadFile(newFile, ModrinthDownloader.getLatestDownloadUrl(this.id));
            return path;
        }
        catch (Exception exception) {
            zAPI.getLogger().warn("Failed to update the plugin " + Version.getName(), exception);
            return "ERROR";
        }
    }

    public static void downloadFile(@NotNull File destination, @NotNull String url) {
        try {
            int readBytes;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            FileOutputStream outputStream = new FileOutputStream(destination);
            InputStream inputStream = connection.getInputStream();
            byte[] buffer = new byte[1024];
            while ((readBytes = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, readBytes);
            }
            outputStream.close();
            inputStream.close();
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path locateJarInPlugins(@NotNull JavaPlugin plugin) {
        Path pluginsDir = plugin.getDataFolder().getParentFile().toPath();
        String myMain = Version.getMainClass();
        String myName = Version.getName();
        String myVersion = Version.getVersion();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDir, "*.jar");){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path jarPath = iterator.next();
                try {
                    JarEntry entry;
                    JarFile jf;
                    block25: {
                        jf = new JarFile(jarPath.toFile());
                        entry = jf.getJarEntry("plugin.yml");
                        if (entry == null) {
                            entry = jf.getJarEntry("paper-plugin.yml");
                        }
                        if (entry != null) break block25;
                        jf.close();
                        continue;
                    }
                    try {
                        InputStream in;
                        block26: {
                            Path path;
                            block27: {
                                in = jf.getInputStream(entry);
                                PluginDescriptionFile pdf = new PluginDescriptionFile(in);
                                if (!myMain.equals(pdf.getMain()) && (!myName.equalsIgnoreCase(pdf.getName()) || !myVersion.equals(pdf.getVersion()))) break block26;
                                path = jarPath.toAbsolutePath();
                                if (in == null) break block27;
                                {
                                    catch (Throwable throwable) {
                                        if (in == null) throw throwable;
                                        try {
                                            in.close();
                                            throw throwable;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                in.close();
                            }
                            jf.close();
                            return path;
                        }
                        if (in == null) continue;
                        in.close();
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to scan plugins directory for the original JAR", e);
        }
    }
}

