/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.skull;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.stream.Collectors;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SkullBuilder {
    private static final Gson GSON = new Gson();
    protected static final ItemStack originalHead = SkullBuilder.getHeadItemStack();

    public static ItemStack getHeadItemStack() {
        return SkullBuilder.isNewHead() ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(Material.getMaterial((String)"SKULL_ITEM"), 1, 3);
    }

    public static boolean isNewHead() {
        return Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
    }

    @NotNull
    public static String getEncoded(@NotNull String url) {
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "https://textures.minecraft.net/texture/" + url).getBytes());
        return new String(encodedData);
    }

    @NotNull
    public static ItemStack getSkullByName(@NotNull String name) {
        ItemStack head = originalHead.clone();
        if (name.isEmpty()) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta == null) {
            return head;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
        if (Version.HAS_PLAYER_PROFILES && offlinePlayer.getPlayerProfile().getTextures().isEmpty()) {
            meta.setOwnerProfile((PlayerProfile)offlinePlayer.getPlayerProfile().update().join());
        } else {
            meta.setOwner(offlinePlayer.getName());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @NotNull
    public static ItemStack getSkullByBase64EncodedTextureUrl(@NotNull String base64Url) {
        ItemStack head = originalHead.clone();
        if (base64Url.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        if (Version.HAS_PLAYER_PROFILES) {
            PlayerProfile profile = SkullBuilder.getPlayerProfile(base64Url);
            headMeta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)headMeta);
            return head;
        }
        GameProfile profile = SkullBuilder.getGameProfile(base64Url);
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            zAPI.getLogger().warn("Failed to set profile for head: " + base64Url, exception);
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    @NotNull
    private static GameProfile getGameProfile(@NotNull String base64Url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64Url));
        return profile;
    }

    @NotNull
    private static PlayerProfile getPlayerProfile(@NotNull String base64Url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        String decodedBase64 = SkullBuilder.decodeSkinUrl(base64Url);
        if (decodedBase64 == null) {
            return profile;
        }
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedBase64));
        }
        catch (MalformedURLException exception) {
            zAPI.getLogger().warn("Failed to set skin URL for player profile: " + base64Url, exception);
        }
        profile.setTextures(textures);
        return profile;
    }

    @Nullable
    public static String decodeSkinUrl(@NotNull String base64Texture) {
        if (base64Texture.isEmpty()) {
            return null;
        }
        String decoded = new String(Base64.getDecoder().decode(base64Texture));
        JsonObject object = (JsonObject)GSON.fromJson(decoded, JsonObject.class);
        JsonElement textures = object.get("textures");
        if (textures == null) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        return url == null ? null : url.getAsString();
    }
}

