/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.player;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.yleoft.zHomes.libs.zAPI.item.NbtHandler;
import me.yleoft.zHomes.libs.zAPI.utility.Version;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerHandler {
    private static final Pattern START_PATTERN = Pattern.compile("^\\[(\\d+(?:\\.\\d+)?)]");

    public static OfflinePlayer getOfflinePlayer(@NotNull UUID uuid) {
        if (Version.isFolia()) {
            try {
                Method getOfflinePlayerMethod = zAPI.getPlugin().getServer().getClass().getMethod("getOfflinePlayerIfCached", UUID.class);
                return (OfflinePlayer)getOfflinePlayerMethod.invoke((Object)Bukkit.getServer(), uuid);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull String name) {
        if (Version.isFolia()) {
            try {
                Method getOfflinePlayerMethod = zAPI.getPlugin().getServer().getClass().getMethod("getOfflinePlayerIfCached", String.class);
                return (OfflinePlayer)getOfflinePlayerMethod.invoke((Object)Bukkit.getServer(), name);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Bukkit.getOfflinePlayer((String)name);
    }

    public static void performCommand(@Nullable Player player, @Nullable ItemStack item, @NotNull String command, boolean chanceParsed) {
        Matcher matcher;
        if (command.startsWith("[CON]") || !command.startsWith("[") && player == null) {
            String finalCommand = command = PlayerHandler.cleanCommand(command.replace("[CON]", ""));
            zAPI.getPlugin().getServer().dispatchCommand((CommandSender)zAPI.getPlugin().getServer().getConsoleSender(), finalCommand);
            return;
        }
        if (command.startsWith("[INV]")) {
            if (player == null) {
                return;
            }
            if ((command = PlayerHandler.cleanCommand(command.replace("[INV]", ""))).equalsIgnoreCase("close")) {
                player.closeInventory();
            }
            return;
        }
        if (command.startsWith("[ITEM]")) {
            if (player == null || item == null) {
                return;
            }
            item = item.clone();
            if ((command = PlayerHandler.cleanCommand(command.replace("[ITEM]", ""))).equalsIgnoreCase("give") && player.getInventory().firstEmpty() != -1) {
                if (zAPI.useNBTAPI && NbtHandler.isMarked(item, NbtHandler.mark)) {
                    NbtHandler.unmarkItem(item, NbtHandler.mark);
                    NbtHandler.removeCustomCommands(item);
                }
                player.getInventory().addItem(new ItemStack[]{item});
            }
            return;
        }
        if (!chanceParsed && command.startsWith("[") && (matcher = START_PATTERN.matcher(command)).find()) {
            String numberStr = matcher.group(1);
            double chance = Double.parseDouble(numberStr);
            if (chance < 0.0 || chance > 100.0) {
                zAPI.getLogger().warn("Invalid chance value: " + chance + " in command: " + command + ". It must be between 0 and 100.");
                return;
            }
            if (Math.random() * 100.0 > chance) {
                return;
            }
            command = matcher.replaceFirst("");
            PlayerHandler.performCommand(player, item, PlayerHandler.cleanCommand(command), true);
            return;
        }
        if (player == null) {
            return;
        }
        String finalCommand = command;
        player.performCommand(PlayerHandler.cleanCommand(finalCommand));
    }

    public static void performCommand(@Nullable Player player, @Nullable ItemStack item, @NotNull String command) {
        PlayerHandler.performCommand(player, item, command, false);
    }

    public static void performCommand(@Nullable Player p, @Nullable ItemStack item, @NotNull List<String> commands) {
        commands.forEach(cmd -> PlayerHandler.performCommand(p, item, cmd));
    }

    public static void performCommand(@Nullable Player player, @NotNull String command) {
        PlayerHandler.performCommand(player, null, command);
    }

    public static void performCommand(@Nullable Player player, @NotNull List<String> commands) {
        PlayerHandler.performCommand(player, null, commands);
    }

    private static String cleanCommand(@Nullable String command) {
        if (command == null) {
            return "";
        }
        int max = 0;
        while (command.startsWith(" ")) {
            command = command.substring(1);
            if (max >= 10) break;
            ++max;
        }
        return command;
    }
}

