/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.yleoft.zHomes.libs.zAPI.command.Command;
import me.yleoft.zHomes.libs.zAPI.configuration.Path;
import me.yleoft.zHomes.libs.zAPI.item.ItemBuilder;
import me.yleoft.zHomes.libs.zAPI.utility.PluginYAML;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryBuilder {
    public static final String KEY_INVENTORY = "Inventory";
    public static final String KEY_ITEMS = "Items";
    public static final String KEY_TITLE = "title";
    public static final String KEY_ROWS = "rows";
    public static final String KEY_COMMAND = "command";
    public static final String KEY_SLOT = "slot";
    public static final String KEY_DISPLAY_CONDITION = "display-condition";
    public static final String KEY_PLACEHOLDERS = "placeholders";
    private Component title;
    private final int rows;
    private final Map<Integer, ItemStack> items;
    private final Map<String, String> globalPlaceholders;

    public static void registerMenuCommand(final @NotNull YamlConfiguration config) {
        if (!config.contains(KEY_COMMAND) || !config.isString(KEY_COMMAND)) {
            return;
        }
        final String commandName = config.getString(KEY_COMMAND);
        if (commandName == null || PluginYAML.isCommandRegistered(commandName)) {
            return;
        }
        final Component inventoryTitle = TextFormatter.transform(config.getString(Path.formPath(KEY_INVENTORY, KEY_TITLE), KEY_INVENTORY));
        Command command = new Command(){

            @Override
            @NotNull
            public String name() {
                return commandName;
            }

            @Override
            public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
                if (!(sender instanceof Player)) {
                    return;
                }
                Player player = (Player)sender;
                InventoryBuilder builder = new InventoryBuilder((OfflinePlayer)player, config);
                player.openInventory(builder.build());
            }

            @Override
            public boolean playerOnly() {
                return true;
            }

            @Override
            public String description() {
                return "Opens " + String.valueOf(inventoryTitle);
            }
        };
    }

    public InventoryBuilder(@NotNull Component title, int rows) {
        if (rows < 1 || rows > 6) {
            throw new IllegalArgumentException("Rows must be between 1 and 6, got: " + rows);
        }
        this.title = title;
        this.rows = rows;
        this.items = new HashMap<Integer, ItemStack>();
        this.globalPlaceholders = new HashMap<String, String>();
    }

    public InventoryBuilder(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config) {
        String titleString = config.getString(Path.formPath(KEY_INVENTORY, KEY_TITLE), KEY_INVENTORY);
        this.title = TextFormatter.transform(player, titleString);
        this.rows = config.getInt(Path.formPath(KEY_INVENTORY, KEY_ROWS), 3);
        if (this.rows < 1 || this.rows > 6) {
            throw new IllegalArgumentException("Rows must be between 1 and 6, got: " + this.rows);
        }
        this.items = new HashMap<Integer, ItemStack>();
        this.globalPlaceholders = new HashMap<String, String>();
        this.loadItemsFromConfig(player, config);
    }

    public InventoryBuilder(@NotNull YamlConfiguration config) {
        this(null, config);
    }

    public InventoryBuilder(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull Map<String, String> globalPlaceholders) {
        String titleString = config.getString(Path.formPath(KEY_INVENTORY, KEY_TITLE), KEY_INVENTORY);
        for (Map.Entry<String, String> entry : globalPlaceholders.entrySet()) {
            titleString = titleString.replace(entry.getKey(), entry.getValue());
        }
        this.title = TextFormatter.transform(player, titleString);
        this.rows = config.getInt(Path.formPath(KEY_INVENTORY, KEY_ROWS), 3);
        if (this.rows < 1 || this.rows > 6) {
            throw new IllegalArgumentException("Rows must be between 1 and 6, got: " + this.rows);
        }
        this.items = new HashMap<Integer, ItemStack>();
        this.globalPlaceholders = new HashMap<String, String>(globalPlaceholders);
        this.loadItemsFromConfig(player, config);
    }

    @NotNull
    private Map<String, String> createInventoryPlaceholders(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%rows%", String.valueOf(this.rows));
        String titleString = config.getString(Path.formPath(KEY_INVENTORY, KEY_TITLE), KEY_INVENTORY);
        placeholders.put("%title%", titleString);
        String commandName = config.getString(KEY_COMMAND, "");
        placeholders.put("%command%", commandName);
        Map<String, String> customPlaceholders = ItemBuilder.parsePlaceholderDefinitions(player, config, Path.formPath(KEY_INVENTORY, KEY_PLACEHOLDERS), placeholders);
        placeholders.putAll(customPlaceholders);
        return placeholders;
    }

    private void loadItemsFromConfig(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config) {
        ConfigurationSection itemsSection = config.getConfigurationSection(KEY_ITEMS);
        if (itemsSection == null) {
            return;
        }
        Map<String, String> inventoryPlaceholders = this.createInventoryPlaceholders(player, config);
        this.globalPlaceholders.putAll(inventoryPlaceholders);
        for (String itemKey : itemsSection.getKeys(false)) {
            String itemPath = Path.formPath(KEY_ITEMS, itemKey);
            this.loadItemFromPath(player, config, itemPath);
        }
    }

    private void loadItemFromPath(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String itemPath) {
        String slotPath = Path.formPath(itemPath, KEY_SLOT);
        if (!config.contains(slotPath)) {
            return;
        }
        List<Integer> slots = this.parseSlots(player, config, slotPath);
        if (slots.isEmpty()) {
            return;
        }
        String conditionPath = Path.formPath(itemPath, KEY_DISPLAY_CONDITION);
        String condition = config.contains(conditionPath) ? config.getString(conditionPath) : null;
        int itemIndex = 1;
        for (int slot : slots) {
            HashMap<String, String> placeholders = new HashMap<String, String>(this.globalPlaceholders);
            placeholders.putAll(ItemBuilder.createSlotPlaceholders(player, slot, itemIndex));
            Map<String, String> parsedPlaceholders = ItemBuilder.parsePlaceholderDefinitions(player, config, Path.formPath(itemPath, KEY_PLACEHOLDERS), placeholders);
            Map<String, String> finalPlaceholders = ItemBuilder.mergePlaceholders(placeholders, parsedPlaceholders);
            if (condition != null && !ItemBuilder.evaluateDisplayCondition(player, condition, finalPlaceholders)) {
                ++itemIndex;
                continue;
            }
            ItemStack item = ItemBuilder.createItem(player, config, itemPath, placeholders);
            this.setItem(slot, item);
            ++itemIndex;
        }
    }

    @NotNull
    private List<Integer> parseSlots(@Nullable OfflinePlayer player, @NotNull YamlConfiguration config, @NotNull String slotPath) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (config.isList(slotPath)) {
            List slotList = config.getList(slotPath);
            if (slotList != null) {
                for (Object slotObj : slotList) {
                    String slotStr = String.valueOf(slotObj);
                    slotStr = ItemBuilder.applyPlaceholdersPublic(player, slotStr, this.globalPlaceholders);
                    slots.addAll(this.parseSlotString(slotStr));
                }
            }
        } else {
            String slotStr = config.getString(slotPath);
            if (slotStr != null) {
                slotStr = ItemBuilder.applyPlaceholdersPublic(player, slotStr, this.globalPlaceholders);
                slots.addAll(this.parseSlotString(slotStr));
            }
        }
        return slots;
    }

    @NotNull
    private List<Integer> parseSlotString(@NotNull String slotStr) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        String trimmed = slotStr.trim();
        if (trimmed.matches("\\d+\\s*-\\s*\\d+")) {
            String[] parts = trimmed.split("-");
            try {
                int start = Integer.parseInt(parts[0].trim());
                int end = Integer.parseInt(parts[1].trim());
                for (int i = Math.min(start, end); i <= Math.max(start, end); ++i) {
                    if (!this.isValidSlot(i)) continue;
                    slots.add(i);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                int slot = Integer.parseInt(trimmed);
                if (this.isValidSlot(slot)) {
                    slots.add(slot);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.rows * 9;
    }

    public void setItem(int slot, @NotNull ItemStack item) {
        if (!this.isValidSlot(slot)) {
            throw new IllegalArgumentException(String.format("Slot %d is out of bounds (0-%d)", slot, this.rows * 9 - 1));
        }
        this.items.put(slot, item.clone());
    }

    public void setItem(int slot, @NotNull ItemStack item, @NotNull Map<String, String> placeholders) {
        if (!this.isValidSlot(slot)) {
            throw new IllegalArgumentException(String.format("Slot %d is out of bounds (0-%d)", slot, this.rows * 9 - 1));
        }
        ItemStack clonedItem = item.clone();
        ItemBuilder.replacePlaceholders(clonedItem, placeholders);
        this.items.put(slot, clonedItem);
    }

    public void removeItem(int slot) {
        if (!this.isValidSlot(slot)) {
            throw new IllegalArgumentException(String.format("Slot %d is out of bounds (0-%d)", slot, this.rows * 9 - 1));
        }
        this.items.remove(slot);
    }

    public void clear() {
        this.items.clear();
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return this.items.get(slot);
    }

    public boolean hasItem(int slot) {
        return this.items.containsKey(slot);
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
    }

    public void setTitle(@Nullable OfflinePlayer player, @NotNull String titleString) {
        this.title = TextFormatter.transform(player, titleString);
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows * 9;
    }

    @NotNull
    public Inventory build() {
        Inventory inventory = Bukkit.createInventory(null, (int)(this.rows * 9), (Component)this.title);
        for (Map.Entry<Integer, ItemStack> entry : this.items.entrySet()) {
            inventory.setItem(entry.getKey().intValue(), entry.getValue());
        }
        return inventory;
    }

    @NotNull
    public Inventory getInventory() {
        return this.build();
    }

    @NotNull
    public Map<Integer, ItemStack> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @NotNull
    public InventoryBuilder copy() {
        InventoryBuilder copy = new InventoryBuilder(this.title, this.rows);
        for (Map.Entry<Integer, ItemStack> entry : this.items.entrySet()) {
            copy.items.put(entry.getKey(), entry.getValue().clone());
        }
        return copy;
    }

    public String toString() {
        return String.format("InventoryBuilder{title=%s, rows=%d, items=%d}", this.title, this.rows, this.items.size());
    }
}

