/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.configuration.languages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.configuration.YAMLBuilder;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class LanguageBuilder
extends YAMLBuilder {
    private static final File languageFolder = new File(zHomes.getInstance().getDataFolder(), "languages");

    public LanguageBuilder(String langFileName) {
        super(new File(languageFolder, langFileName + ".yml"));
        this.migrateLegacyColors(true);
        this.buildLang();
    }

    public void buildLang() {
        this.header("####################################################################################################\n# +----------------------------------------------------------------------------------------------+ #\n# |                                                                                              | #\n# |                                   zHomes \u2014 Language File                                     | #\n# |                                                                                              | #\n# |   \u2022 Wiki:        https://docs.yleoft.me/zhomes                                               | #\n# |   \u2022 Discord:     https://discord.gg/yCdhVDgn4K                                               | #\n# |   \u2022 GitHub:      https://github.com/yL3oft/zHomes                                            | #\n# |                                                                                              | #\n# +----------------------------------------------------------------------------------------------+ #\n####################################################################################################\n");
        this.commentSection("hooks", "Here you can manage hook messages.");
        this.addDefault(LanguageBuilder.formPath("hooks", "griefprevention", "cant-set-homes"), "%prefix% <red>You can't set homes in this area.");
        this.addDefault(LanguageBuilder.formPath("hooks", "worldguard", "cant-use-homes"), "%prefix% <red>You can't use homes here.");
        this.addDefault(LanguageBuilder.formPath("hooks", "worldguard", "cant-set-homes"), "%prefix% <red>You can't set a home here.");
        this.addDefault(LanguageBuilder.formPath("hooks", "vault", "cant-afford-command"), "%prefix% <red>You need <gold>$%cost% <red>in order to execute this command.");
        this.commentSection("teleport-warmup", "Messages related to teleport warmup.");
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "warmup"), "%prefix% <green>Teleporting in %time% seconds... Don't move!");
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "warmup-actionbar"), "<green>Teleporting in %time% seconds...");
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "cancelled"), "%prefix% <red>You moved! Teleportation cancelled.");
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "cancelled-actionbar"), "<red>You moved! Teleportation cancelled.");
        this.commentSection("commands", "Messages related to commands.");
        this.comment(false, "Up here you will find messages that can be used in multiple commands.");
        this.addDefault(LanguageBuilder.formPath("commands", "no-permission"), "%prefix% <red>You don't have permission to execute this command.");
        this.addDefault(LanguageBuilder.formPath("commands", "only-players"), "%prefix% <red>Only players can execute this command.");
        this.addDefault(LanguageBuilder.formPath("commands", "in-cooldown"), "%prefix% <red>You must wait %time% seconds before using this command again.");
        this.addDefault(LanguageBuilder.formPath("commands", "home-already-exist"), "%prefix% <red>You already have a home with this name.");
        this.addDefault(LanguageBuilder.formPath("commands", "home-doesnt-exist"), "%prefix% <red>You don't have any home with this name.");
        this.addDefault(LanguageBuilder.formPath("commands", "home-doesnt-exist-others"), "%prefix% <yellow>%player% <red>don't have any home with this name.");
        this.addDefault(LanguageBuilder.formPath("commands", "cant-use-2dot"), "%prefix% <red>You can't use <yellow>':' <red>in this command.");
        this.addDefault(LanguageBuilder.formPath("commands", "cant-find-player"), "%prefix% <red>This player was not found.");
        this.addDefault(LanguageBuilder.formPath("commands", "unable-to-find-safe-location"), "%prefix% <red>Unable to find a safe location to teleport you.");
        this.addDefault(LanguageBuilder.formPath("commands", "world-restricted-sethome"), "%prefix% <red>You can't set homes in this world.");
        this.addDefault(LanguageBuilder.formPath("commands", "world-restricted-home"), "%prefix% <red>You can't teleport to homes in that world.");
        this.commentSection(LanguageBuilder.formPath("commands", "main"), "Below you will find messages specific for the commands.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "help", "help-perm"), "%prefix% <aqua>Usages of <yellow>/%command%<aqua>:\n<red>-> <yellow>/%command% <green>help <gray>Shows this exact help message\n<red>-> <yellow>/%command% <green>info <gray>Shows plugin information\n<red>-> <yellow>/%command% <green>(reload|rl) <gold>[all, commands, config, languages]\n<red>-> <yellow>/%command% <green>(version|ver) <gold>[update]\n<red>-> <yellow>/%command% <green>nearhomes <gold>(<radius>) <gray>List homes near you within a certain radius\n<red>-> <yellow>/%command% <green>parse <gold>(Player) (String) <gray>Parses a string with placeholders for a specific player\n<red>-> <yellow>/%command% <green>converter (<converter-type>) <gray>Convert data from one place to another\n<red>-> <yellow>/%command% <green>export <gray>Exports all homes to a single file\n<red>-> <yellow>/%command% <green>import (<file>) <gray>Imports homes from a single file\n");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "help", "help-noperm"), "%prefix% <aqua>Usages of <yellow>/%command%<aqua>:\n<red>-> <yellow>/%command% <green>(help|?) <gray>Shows this exact help message\n<red>-> <yellow>/%command% <green>(version|ver) <gray>Shows plugin version\n");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "output"), "%prefix% <aqua>Running <dark_aqua>%name% v%version% <aqua>by <dark_aqua>%author%<aqua>:\n%prefix% <aqua>- Server Info:\n%prefix% <dark_aqua>   Software: <white>%server.software%\n%prefix% <dark_aqua>   Version: <white>%server.version%\n%prefix% <dark_aqua>   Require update: <white>%requpdate%\n%prefix% <dark_aqua>   Language: <white>%language%\n%prefix% <aqua>- Storage:\n%prefix% <dark_aqua>   Type: <white>%storage.type%\n%prefix% <dark_aqua>   Users: <white>%storage.users%\n%prefix% <dark_aqua>   Homes: <white>%storage.homes%\n%prefix% <aqua>- Hooks:\n%prefix% <dark_aqua>   PlaceholderAPI: <white>%use.placeholderapi%\n%prefix% <dark_aqua>   GriefPrevention: <white>%use.griefprevention%\n%prefix% <dark_aqua>   WorldGuard: <white>%use.worldguard%\n%prefix% <dark_aqua>   Vault: <white>%use.vault%\n");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "requpdate-yes"), "<red>Yes <gray>(Use <yellow>/%command% version <gray>for more info)");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "requpdate-no"), "<green>No");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "version", "output"), "%prefix% <aqua>Current version: <green>%version%");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "version", "update", "output"), "%prefix% <green>zHomes updated to the latest version <yellow>(%update%)<green>, please restart your server to apply the changes.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "version", "update", "no-update"), "%prefix% <green>You are already using the latest version of zHomes.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "usage"), "%prefix% <aqua>Usages of <yellow>/%command% <green>(reload|rl)<aqua>:\n<red>-> <yellow>/%command% <green>(reload|rl) <gold>[all, commands, config, languages]\n");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "output"), "%prefix% <green>Reloaded plugin in <aqua>%time%ms<green>.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "commands", "output"), "%prefix% <green>Reloaded all plugin commands in <aqua>%time%ms<green>.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "config", "output"), "%prefix% <green>Reloaded plugin config file in <aqua>%time%ms<green>.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "languages", "output"), "%prefix% <green>Reloaded plugin languages in <aqua>%time%ms<green>.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "usage"), "<red>-> <yellow>/%command% nearhomes <green>[<Radius>]");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "output"), "%prefix% <gray>Homes near you within <yellow>%radius% <gray>blocks: <white>%homes%");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "output-not-found"), "%prefix% <red>No homes found within <yellow>%radius% <red>blocks.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "home-string"), "<yellow>%home% <gray>(%owner%)");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "parse", "usage"), "<red>-> <yellow>/%command% parse <gold>(Player) (String)");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "parse", "output"), "%prefix% <gray>Parsed text: <white>%parsed%");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "usage"), "%prefix% <aqua>Usages of <yellow>/%command% <green>converter<aqua>:\n<red>-> <yellow>/%command% <green>converter sqlitetoh2\n<red>-> <yellow>/%command% <green>converter sqlitetomysql\n<red>-> <yellow>/%command% <green>converter sqlitetomariadb\n<red>-> <yellow>/%command% <green>converter mysqltosqlite\n<red>-> <yellow>/%command% <green>converter mysqltoh2\n<red>-> <yellow>/%command% <green>converter mariadbtosqlite\n<red>-> <yellow>/%command% <green>converter mariadbtoh2\n<red>-> <yellow>/%command% <green>converter h2tosqlite\n<red>-> <yellow>/%command% <green>converter h2tomysql\n<red>-> <yellow>/%command% <green>converter h2tomariadb\n<red>-> <yellow>/%command% <green>converter essentials\n<red>-> <yellow>/%command% <green>converter sethome\n<red>-> <yellow>/%command% <green>converter ultimatehomes\n<red>-> <yellow>/%command% <green>converter xhomes\n<red>-> <yellow>/%command% <green>converter zhome\n");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "output"), "%prefix% <green>All data converted!");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "error"), "%prefix% <red>Something went wrong converting the data, please check your server console.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "export", "output"), "%prefix% <green>All homes exported to <yellow>%file%<green>!");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "export", "error"), "%prefix% <red>Something went wrong exporting the data, please check your server console.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "usage"), "<red>-> <yellow>/%command% import <green>(<file>)");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "output"), "%prefix% <green>All homes imported from <yellow>%file%<green>!");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "file-not-found"), "%prefix% <red>The file <yellow>%file% <red>was not found.");
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "error"), "%prefix% <red>Something went wrong importing the data, please check your server console.");
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "usage"), "<red>-> <yellow>/%command% <green>(Home)");
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "output"), "%prefix% <green>Home <yellow>%home% <green>set to your position.");
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "limit-reached"), "<red>You can't set more homes because you reached your limit <yellow>(%limit% homes)<red>!");
        this.addDefault(LanguageBuilder.formPath("commands", "delhome", "usage"), "<red>-> <yellow>/%command% <green>(Home)");
        this.addDefault(LanguageBuilder.formPath("commands", "delhome", "output"), "%prefix% <red>Home <yellow>%home% <red>deleted.");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "usage"), "<red>-> <yellow>/%command% <green>(Home)");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "output"), "%prefix% <green>Teleported to <yellow>%home%<green>...");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "cant-dimensional-teleport"), "<red>Your teleport was cancelled! Dimensional teleportation is disabled.");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "usage"), "<red>-> <yellow>/%command% <green>rename (Home) (NewName)");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "output"), "%prefix% <green>Home <yellow>%home% <green>renamed to <yellow>%newname%<green>.");
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "same-name"), "%prefix% <red>You can't rename a home to the same name.");
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "output"), "%prefix% <gray>Your homes (%amount%): <white>%homes%");
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "invalid-page"), "%prefix% <red>Invalid page number! Please use a number higher than 0.");
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "others", "output"), "%prefix% <yellow>%player%'s <gray>homes (%amount%): <white>%homes%");
        this.build();
    }

    public String getGFCantSetHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "griefprevention", "cant-set-homes"));
    }

    public String getWGCantUseHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "worldguard", "cant-use-homes"));
    }

    public String getWGCantSetHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "worldguard", "cant-set-homes"));
    }

    public String getVaultCantAffordCommand() {
        return this.getString(LanguageBuilder.formPath("hooks", "vault", "cant-afford-command"));
    }

    public String getWarmup(int time) {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "warmup")).replace("%time%", String.valueOf(time));
    }

    public String getWarmupActionbar(int time) {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "warmup-actionbar")).replace("%time%", String.valueOf(time));
    }

    public String getWarmupCancelled() {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "cancelled"));
    }

    public String getWarmupCancelledActionbar() {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "cancelled-actionbar"));
    }

    public String getNoPermission() {
        return this.getString(LanguageBuilder.formPath("commands", "no-permission"));
    }

    public String getOnlyPlayers() {
        return this.getString(LanguageBuilder.formPath("commands", "only-players"));
    }

    public String getInCooldown() {
        return this.getString(LanguageBuilder.formPath("commands", "in-cooldown"));
    }

    public String getHomeAlreadyExist() {
        return this.getString(LanguageBuilder.formPath("commands", "home-already-exist"));
    }

    public String getHomeDoesntExist() {
        return this.getString(LanguageBuilder.formPath("commands", "home-doesnt-exist"));
    }

    public String getHomeDoesntExistOthers(String player) {
        return this.getString(LanguageBuilder.formPath("commands", "home-doesnt-exist-others")).replace("%player%", player);
    }

    public String getCantUse2Dot() {
        return this.getString(LanguageBuilder.formPath("commands", "cant-use-2dot"));
    }

    public String getCantFindPlayer() {
        return this.getString(LanguageBuilder.formPath("commands", "cant-find-player"));
    }

    public String getUnableToFindSafeLocation() {
        return this.getString(LanguageBuilder.formPath("commands", "unable-to-find-safe-location"));
    }

    public String getWorldRestrictedSethome() {
        return this.getString(LanguageBuilder.formPath("commands", "world-restricted-sethome"));
    }

    public String getWorldRestrictedHome() {
        return this.getString(LanguageBuilder.formPath("commands", "world-restricted-home"));
    }

    public String getMainHelpPerm() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "help", "help-perm"));
    }

    public String getMainHelpNoPerm() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "help", "help-noperm"));
    }

    public String getMainInfoOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "output")).replace("%name%", zHomes.getInstance().getPluginMeta().getName()).replace("%version%", zHomes.getInstance().getPluginMeta().getVersion()).replace("%author%", String.join((CharSequence)", ", zHomes.getInstance().getPluginMeta().getAuthors())).replace("%server.software%", Bukkit.getServer().getName()).replace("%server.version%", Bukkit.getServer().getVersion() + " - " + Bukkit.getServer().getBukkitVersion()).replace("%requpdate%", zHomes.updateUtils.needsUpdate ? this.getRequireUpdateYes() : this.getRequireUpdateNo()).replace("%language%", zHomes.getConfigYAML().getLanguageCode()).replace("%storage.type%", zHomes.getConfigYAML().getDatabaseType()).replace("%storage.users%", String.valueOf(DatabaseEditor.getTotalUsers())).replace("%storage.homes%", String.valueOf(DatabaseEditor.getTotalHomes())).replace("%use.placeholderapi%", HookRegistry.PAPI.exists() ? "<green>Yes" : "<red>No").replace("%use.griefprevention%", me.yleoft.zHomes.hooks.HookRegistry.GRIEF_PREVENTION.exists() ? "<green>Yes" : "<red>No").replace("%use.worldguard%", me.yleoft.zHomes.hooks.HookRegistry.WORLDGUARD.exists() ? "<green>Yes" : "<red>No").replace("%use.vault%", me.yleoft.zHomes.hooks.HookRegistry.VAULT.exists() ? "<green>Yes" : "<red>No");
    }

    public String getRequireUpdateYes() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "requpdate-yes"));
    }

    public String getRequireUpdateNo() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "requpdate-no"));
    }

    public String getMainVersionOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "version", "output")).replace("%version%", zHomes.getInstance().getPluginMeta().getVersion());
    }

    public String getMainVersionUpdateOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "version", "update", "output")).replace("%update%", zHomes.updateUtils.updateVersion);
    }

    public String getMainVersionNoUpdate() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "version", "update", "no-update"));
    }

    public String getMainReloadUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "usage"));
    }

    public String getMainReloadOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadCommandsOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "commands", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadConfigOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "config", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadLanguagesOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "languages", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainNearhomesUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "usage"));
    }

    public String getMainNearhomesOutput(double radius, HashMap<OfflinePlayer, List<String>> homes, @Nullable String playerName, @Nullable String homeName) {
        StringBuilder homesList = new StringBuilder();
        for (OfflinePlayer p : homes.keySet()) {
            if (playerName != null && p.getName() != null && !p.getName().equalsIgnoreCase(playerName)) continue;
            for (String home : homes.get(p)) {
                if (homeName != null && !home.startsWith(homeName)) continue;
                if (!homesList.toString().isEmpty()) {
                    homesList.append(", ");
                }
                homesList.append(this.getHomeString(p, home));
            }
        }
        if (homesList.toString().isEmpty()) {
            return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "output-not-found")).replace("%radius%", String.valueOf(radius));
        }
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "output")).replace("%radius%", String.valueOf(radius)).replace("%homes%", homesList.toString());
    }

    public String getMainNearhomesOutput(double radius, HashMap<OfflinePlayer, List<String>> homes) {
        return this.getMainNearhomesOutput(radius, homes, null, null);
    }

    public String getHomeString(OfflinePlayer player, String home) {
        return this.getString(LanguageBuilder.formPath("commands", "main", "nearhomes", "home-string")).replace("%home%", home).replace("%owner%", player == null || player.getName() == null ? "----" : player.getName());
    }

    public String getMainParseUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "parse", "usage"));
    }

    public String getMainParseOutput(String parsed) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "parse", "output")).replace("%parsed%", parsed);
    }

    public String getMainConverterUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "usage"));
    }

    public String getMainConverterOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "output"));
    }

    public String getMainConverterError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "error"));
    }

    public String getMainExportOutput(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "export", "output")).replace("%file%", file);
    }

    public String getMainExportError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "export", "error"));
    }

    public String getMainImportUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "usage"));
    }

    public String getMainImportOutput(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "output")).replace("%file%", file);
    }

    public String getMainImportFileNotFound(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "file-not-found")).replace("%file%", file);
    }

    public String getMainImportError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "error"));
    }

    public String getSethomeUsage() {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "usage"));
    }

    public String getSethomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "output")).replace("%home%", home);
    }

    public String getSethomeLimitReached(OfflinePlayer player) {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "limit-reached")).replace("%limit%", String.valueOf(HomesUtils.getLimit(player)));
    }

    public String getDelhomeUsage() {
        return this.getString(zHomes.getConfigYAML().getDelHomeCommand(), LanguageBuilder.formPath("commands", "delhome", "usage"));
    }

    public String getDelhomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getDelHomeCommand(), LanguageBuilder.formPath("commands", "delhome", "output")).replace("%home%", home);
    }

    public String getHomeUsage() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "usage"));
    }

    public String getHomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "output")).replace("%home%", home);
    }

    public String getHomeCantDimensionalTeleport() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "cant-dimensional-teleport"));
    }

    public String getHomeRenameUsage() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "usage"));
    }

    public String getHomeRenameOutput(String home, String newName) {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "output")).replace("%home%", home).replace("%newname%", newName);
    }

    public String getHomeRenameSameName() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "same-name"));
    }

    public String getHomesOutputSelf(Player player) {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "output")).replace("%homes%", HomesUtils.homes((OfflinePlayer)player)).replace("%amount%", String.valueOf(HomesUtils.numberOfHomes((OfflinePlayer)player)));
    }

    public String getHomesInvalidPage() {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "invalid-page"));
    }

    public String getHomesOutputOthers(OfflinePlayer player) {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "others", "output")).replace("%homes%", HomesUtils.homes(player)).replace("%amount%", String.valueOf(HomesUtils.numberOfHomes(player))).replace("%player%", player == null || player.getName() == null ? "----" : player.getName());
    }

    public static File getLanguageFolder() {
        return languageFolder;
    }

    public String getLanguageFileName() {
        return this.getFile().getName().replace(".yml", "");
    }

    public static void sendMessage(@Nullable CommandSender sender, String message) {
        if (sender != null) {
            sender.sendMessage(TextFormatter.transform((OfflinePlayer)(sender instanceof Player ? (Player)sender : null), message));
        }
    }

    public static void sendActionBar(CommandSender sender, String message) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(TextFormatter.transform(message));
            return;
        }
        Player player = (Player)sender;
        player.sendActionBar(TextFormatter.transform((OfflinePlayer)player, message));
    }

    @Override
    public String getString(String command, String path) {
        return this.getString(path).replace("%command%", command);
    }
}

