/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import java.util.List;
import java.util.Objects;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.libs.zAPI.utility.PluginYAML;
import me.yleoft.zHomes.utility.LanguageUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MainReloadSubCommand
implements SubCommand {
    @Override
    @NotNull
    public String name() {
        return "reload";
    }

    @Override
    public List<String> aliases() {
        return List.of("rl");
    }

    @Override
    public int maxArgs() {
        return 1;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getMainCommandReloadPermission();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getMainReloadUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        String reloadType = "all";
        if (args.length == 1) {
            reloadType = args[0];
        }
        switch (reloadType) {
            case "all": {
                long time = MainReloadSubCommand.reload("all");
                this.message(sender, zHomes.getLanguageYAML().getMainReloadOutput(time));
                return;
            }
            case "commands": {
                long time = MainReloadSubCommand.reload("commands");
                this.message(sender, zHomes.getLanguageYAML().getMainReloadCommandsOutput(time));
                return;
            }
            case "config": {
                long time = MainReloadSubCommand.reload("config");
                this.message(sender, zHomes.getLanguageYAML().getMainReloadConfigOutput(time));
                return;
            }
            case "languages": {
                long time = MainReloadSubCommand.reload("languages");
                this.message(sender, zHomes.getLanguageYAML().getMainReloadLanguagesOutput(time));
                return;
            }
        }
        this.message(sender, this.usage(sender, fullArgs, args));
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return List.of("all", "commands", "config", "languages");
    }

    private static long reload(String reloadType) {
        long now = System.currentTimeMillis();
        if (!Objects.equals(reloadType, "config")) {
            MainReloadSubCommand.reload("config");
        }
        switch (reloadType.toLowerCase()) {
            case "all": {
                MainReloadSubCommand.reload("commands");
                MainReloadSubCommand.reload("languages");
                break;
            }
            case "commands": {
                zHomes.getInstance().loadCommands();
                PluginYAML.syncCommands();
                break;
            }
            case "config": {
                zHomes.getInstance().reloadConfig();
                boolean debugMode = zHomes.getConfigYAML().isDebugModeEnabled();
                zHomes.getInstance().getLoggerInstance().setDebugMode(debugMode);
                break;
            }
            case "languages": {
                LanguageUtils.loadCurrentLanguage();
            }
        }
        return System.currentTimeMillis() - now;
    }
}

