/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import java.util.Arrays;
import java.util.List;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MainParseSubCommand
implements SubCommand {
    @Override
    @NotNull
    public String name() {
        return "parse";
    }

    @Override
    public int minArgs() {
        return 2;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getMainCommandParsePermission();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getMainParseUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        String targetName = args[0];
        OfflinePlayer target = PlayerHandler.getOfflinePlayer(targetName);
        if (target == null) {
            sender.sendMessage(zHomes.getLanguageYAML().getCantFindPlayer());
            return;
        }
        String parseString = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        this.message(sender, zHomes.getLanguageYAML().getMainParseOutput(parseString));
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        if (args.length == 1) {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(player -> player.getName() != null ? player.getName() : "").toList();
        }
        String currentArg = args[args.length - 1];
        if (currentArg.startsWith("%") && !currentArg.endsWith("%")) {
            return HookRegistry.PLUGIN_PAPI.getPlaceholderSuggestions(currentArg);
        }
        return List.of();
    }
}

