/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import java.util.Arrays;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.command.Parameter;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MainNearhomesSubCommand
implements SubCommand {
    private final Parameter userParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "user";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("u", "player", "p");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(offlinePlayer -> offlinePlayer.getName() == null ? "" : offlinePlayer.getName()).toList();
        }
    };
    private final Parameter homeParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "home";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("h");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            String[] userArgs = MainNearhomesSubCommand.this.getParameter(sender, MainNearhomesSubCommand.this.userParameter);
            return userArgs == null ? List.of() : HomesUtils.homesW(PlayerHandler.getOfflinePlayer(userArgs[0]));
        }
    };

    public MainNearhomesSubCommand() {
        this.addParameter(this.userParameter);
        this.addParameter(this.homeParameter);
    }

    @Override
    @NotNull
    public String name() {
        return "nearhomes";
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getMainCommandNearHomesPermission();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getMainNearhomesUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        Player player = (Player)sender;
        double radius = 0.0;
        try {
            radius = Double.parseDouble(args[0]);
            if (radius <= 0.0) {
                this.message((CommandSender)player, this.usage((CommandSender)player, fullArgs, args));
                return;
            }
        }
        catch (Exception e) {
            this.message((CommandSender)player, this.usage((CommandSender)player, fullArgs, args));
            return;
        }
        if (radius > zHomes.getConfigYAML().getMainCommandNearHomesLimit()) {
            radius = zHomes.getConfigYAML().getMainCommandNearHomesLimit();
        }
        String[] userArgs = this.getParameter(sender, this.userParameter);
        String[] homeArgs = this.getParameter(sender, this.homeParameter);
        this.message((CommandSender)player, zHomes.getLanguageYAML().getMainNearhomesOutput(radius, HomesUtils.getNearHomes(player.getLocation(), radius), userArgs == null ? null : userArgs[0], homeArgs == null ? null : homeArgs[0]));
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return args.length > 1 ? List.of("-") : List.of();
    }
}

