/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.ExecuteHomesCommandEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.Command;
import me.yleoft.zHomes.libs.zAPI.configuration.Path;
import me.yleoft.zHomes.libs.zAPI.inventory.InventoryBuilder;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class HomesCommand
extends HomesUtils
implements Command {
    @Override
    @NotNull
    public String name() {
        return zHomes.getConfigYAML().getHomesCommand();
    }

    @Override
    public String description() {
        return zHomes.getConfigYAML().getHomesCommandDescription();
    }

    @Override
    public List<String> aliases() {
        return zHomes.getConfigYAML().getHomesCommandAliases();
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getHomesCommandPermission();
    }

    @Override
    public double cooldownTime() {
        return zHomes.getConfigYAML().getHomesCommandCooldown();
    }

    @Override
    public boolean prexecute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        if (!this.isPlayer(sender)) {
            return false;
        }
        ExecuteHomesCommandEvent preevent = new ExecuteHomesCommandEvent((Player)sender);
        Bukkit.getPluginManager().callEvent((Event)preevent);
        return preevent.isCancelled();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            if (args.length != 1) {
                this.message(sender, zHomes.getLanguageYAML().getCantFindPlayer());
                return;
            }
            OfflinePlayer t = PlayerHandler.getOfflinePlayer(args[0]);
            if (t == null) {
                this.message(sender, zHomes.getLanguageYAML().getCantFindPlayer());
                return;
            }
            this.message(sender, zHomes.getLanguageYAML().getHomesOutputOthers(t));
            return;
        }
        Player player = (Player)sender;
        if (args.length >= 1) {
            if (TextFormatter.isInteger(args[0])) {
                int page = Integer.parseInt(args[0]);
                if (page < 1) {
                    this.message((CommandSender)player, zHomes.getLanguageYAML().getHomesInvalidPage());
                    return;
                }
                this.code(player, (OfflinePlayer)player, page);
                return;
            }
            String target = args[0];
            if (player.hasPermission(zHomes.getConfigYAML().getHomesOthersPermission())) {
                OfflinePlayer t = PlayerHandler.getOfflinePlayer(target);
                if (t == null) {
                    this.message((CommandSender)player, zHomes.getLanguageYAML().getCantFindPlayer());
                    return;
                }
                if (args.length >= 2 && TextFormatter.isInteger(args[1])) {
                    int page = Integer.parseInt(args[1]);
                    if (page < 1) {
                        this.message((CommandSender)player, zHomes.getLanguageYAML().getHomesInvalidPage());
                        return;
                    }
                    this.code(player, t, page);
                    return;
                }
                this.code(player, t);
                return;
            }
        }
        this.code(player, (OfflinePlayer)player);
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (sender.hasPermission(zHomes.getConfigYAML().getHomesOthersPermission())) {
            Bukkit.getOnlinePlayers().forEach(online -> completions.add(online.getName()));
        }
        return completions;
    }

    public void code(String type, Player p, OfflinePlayer t, int page) {
        if (HookRegistry.VAULT.canAfford(p, zHomes.getConfigYAML().getHomesCommandPermission(), zHomes.getConfigYAML().getHomesCommandCost())) {
            switch (type) {
                case "menu": {
                    try {
                        p.openInventory(this.getInventory(p, t, page));
                        break;
                    }
                    catch (Exception e) {
                        zHomes.getInstance().getLoggerInstance().warn("Failed to open homes menu for player " + p.getName() + ". Falling back to text display.", e);
                        this.code("text", p, t, page);
                        return;
                    }
                }
                case "text": {
                    if (p != t) {
                        this.message((CommandSender)p, zHomes.getLanguageYAML().getHomesOutputOthers(t));
                        break;
                    }
                    this.message((CommandSender)p, zHomes.getLanguageYAML().getHomesOutputSelf(p));
                    break;
                }
                default: {
                    this.message((CommandSender)p, zHomes.getLanguageYAML().getCantFindPlayer());
                }
            }
        }
    }

    public void code(Player p, OfflinePlayer t, int page) {
        this.code(zHomes.getConfigYAML().getHomesDisplayType(), p, t, page);
    }

    public void code(Player p, OfflinePlayer t) {
        this.code(zHomes.getConfigYAML().getHomesDisplayType(), p, t, 1);
    }

    public Inventory getInventory(Player p, OfflinePlayer t, int page) {
        YamlConfiguration config = (YamlConfiguration)zHomes.menuHomes.getConfig();
        HashMap<String, String> customPlaceholders = new HashMap<String, String>();
        if (t != null) {
            customPlaceholders.put("%targetplayer%", t.getName());
            customPlaceholders.put("%target%", t.getName());
        }
        customPlaceholders.put("%page%", String.valueOf(page));
        InventoryBuilder inv = new InventoryBuilder((OfflinePlayer)p, config, customPlaceholders);
        if (p != t) {
            String titleOther = zHomes.menuHomes.getString(Path.formPath("Inventory", "title-other"));
            titleOther = titleOther.replace("%target%", t.getName());
            inv.setTitle((OfflinePlayer)p, titleOther);
        }
        return inv.getInventory();
    }
}

