/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.ExecuteDelhomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteDelhomeCommandEvent;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.Command;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class DelhomeCommand
extends HomesUtils
implements Command {
    @Override
    @NotNull
    public String name() {
        return zHomes.getConfigYAML().getDelHomeCommand();
    }

    @Override
    public String description() {
        return zHomes.getConfigYAML().getDelHomeCommandDescription();
    }

    @Override
    public List<String> aliases() {
        return zHomes.getConfigYAML().getDelHomeCommandAliases();
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getDelHomeCommandPermission();
    }

    @Override
    public double cooldownTime() {
        return zHomes.getConfigYAML().getDelHomeCommandCooldown();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getDelhomeUsage();
    }

    @Override
    public boolean prexecute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        if (!this.isPlayer(sender)) {
            return false;
        }
        PreExecuteDelhomeCommandEvent preevent = new PreExecuteDelhomeCommandEvent((Player)sender);
        Bukkit.getPluginManager().callEvent((Event)preevent);
        return preevent.isCancelled();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        String home = args[0];
        if (home.contains(":")) {
            if (sender.hasPermission(zHomes.getConfigYAML().getHomesOthersPermission())) {
                this.code2(sender, home);
            } else {
                this.message(sender, zHomes.getLanguageYAML().getCantUse2Dot());
            }
        } else {
            if (!this.isPlayer(sender)) {
                this.message(sender, this.playerOnlyMessage());
                return;
            }
            this.code1((Player)sender, home);
        }
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        String[] as;
        OfflinePlayer t;
        ArrayList<String> completions = new ArrayList<String>();
        if (args[0].contains(":") && sender.hasPermission(zHomes.getConfigYAML().getDelHomeOthersPermission()) && (t = Bukkit.getOfflinePlayer((String)(as = args[0].split(":"))[0])) != null) {
            completions.addAll(DelhomeCommand.homesWDD(t));
        }
        if (completions.isEmpty() && sender instanceof Player) {
            Player player = (Player)sender;
            completions.addAll(DelhomeCommand.homesW((OfflinePlayer)player));
            if (sender.hasPermission(zHomes.getConfigYAML().getDelHomeOthersPermission())) {
                Bukkit.getOnlinePlayers().forEach(on -> completions.add(on.getName() + ":"));
            }
        }
        return completions;
    }

    public void code1(Player p, String home) {
        ExecuteDelhomeCommandEvent event = new ExecuteDelhomeCommandEvent(p, home);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        home = event.getHome();
        if (DelhomeCommand.hasHome((OfflinePlayer)p, home)) {
            if (HookRegistry.VAULT.canAfford(p, zHomes.getConfigYAML().getDelHomeCommandPermission(), zHomes.getConfigYAML().getDelHomeCommandCost())) {
                DelhomeCommand.delHome((OfflinePlayer)p, home);
                this.message((CommandSender)p, zHomes.getLanguageYAML().getDelhomeOutput(home));
            }
        } else {
            this.message((CommandSender)p, zHomes.getLanguageYAML().getHomeDoesntExist());
        }
    }

    public void code2(CommandSender sender, String home) {
        String ofchome = home;
        if (this.isPlayer(sender)) {
            ExecuteDelhomeCommandEvent event = new ExecuteDelhomeCommandEvent((Player)sender, home);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ofchome = event.getHome();
        }
        if (ofchome == null || ofchome.isEmpty()) {
            return;
        }
        String[] homeS = ofchome.split(":");
        if (homeS.length < 2) {
            return;
        }
        String player = homeS[0];
        home = homeS[1];
        OfflinePlayer t = PlayerHandler.getOfflinePlayer(player);
        if (t == null) {
            this.message(sender, zHomes.getLanguageYAML().getCantFindPlayer());
            return;
        }
        if (DelhomeCommand.hasHome(t, home)) {
            if (!this.isPlayer(sender) || HookRegistry.VAULT.canAfford((Player)sender, zHomes.getConfigYAML().getDelHomeCommandPermission(), zHomes.getConfigYAML().getDelHomeCommandCost())) {
                DelhomeCommand.delHome(t, home);
                this.message(sender, zHomes.getLanguageYAML().getDelhomeOutput(home));
            }
        } else {
            this.message(sender, zHomes.getLanguageYAML().getHomeDoesntExistOthers(t.getName()));
        }
    }
}

