/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.managers.FileManager;
import me.yleoft.zHomes.shaded.zAPI.mutable.Messages;
import me.yleoft.zHomes.shaded.zAPI.utils.FileUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import me.yleoft.zHomes.utils.ConfigUtils;
import me.yleoft.zHomes.utils.HomesUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageUtils
extends ConfigUtils {
    private static final Main main = Main.getInstance();
    private static FileUtils fuBACKUP = null;
    public static final String hooks = "hooks";
    public static final String cmds = "commands";
    public static final String tpw = "teleport-warmup";
    public static final String griefprevention = "griefprevention";
    public static final String worldguard = "worldguard";
    public static final String vault = "vault";
    public static final File f = new File(main.getDataFolder(), "languages/en.yml");
    public static YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);

    public LanguageUtils() {
        cfg = LanguageUtils.getConfigFile();
    }

    public static YamlConfiguration getConfigFile() {
        ArrayList<FileUtils> list = new ArrayList<FileUtils>();
        list.add(FileManager.getFileUtil("languages/de.yml"));
        list.add(FileManager.getFileUtil("languages/en.yml"));
        list.add(FileManager.getFileUtil("languages/es.yml"));
        list.add(FileManager.getFileUtil("languages/fr.yml"));
        list.add(FileManager.getFileUtil("languages/it.yml"));
        list.add(FileManager.getFileUtil("languages/nl.yml"));
        list.add(FileManager.getFileUtil("languages/pl.yml"));
        list.add(FileManager.getFileUtil("languages/pt-br.yml"));
        list.add(FileManager.getFileUtil("languages/ru.yml"));
        list.add(FileManager.getFileUtil("languages/zhcn.yml"));
        list.add(fuBACKUP);
        boolean found = false;
        YamlConfiguration returned = cfg;
        String lang = LanguageUtils.langType();
        for (FileUtils fu : list) {
            String name;
            String[] nameS;
            String langtype;
            File f;
            if (fu == null || !(f = fu.getFile()).exists() || !(langtype = (nameS = (name = f.getName()).split("\\."))[0]).equals(lang)) continue;
            returned = (YamlConfiguration)fu.getConfig();
            found = true;
            break;
        }
        if (!found) {
            String resource = "languages/" + lang + ".yml";
            File f = new File(main.getDataFolder(), resource);
            if (f.exists()) {
                fuBACKUP = new FileUtils(f, resource);
                returned = (YamlConfiguration)fuBACKUP.getConfig();
            }
        }
        return returned;
    }

    public static void loadzAPIMessages() {
        YamlConfiguration config = LanguageUtils.getConfigFile();
        Messages.setCooldownExpired(Objects.requireNonNull(Helper.getText(config.getString(me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(cmds, "in-cooldown")))));
    }

    public static interface Helper {
        default public void sendMsg(Player p, String text) {
            if (text.isEmpty()) {
                return;
            }
            text = Helper.getText((CommandSender)p, text.replace("%limit%", String.valueOf(Main.cfgu.getMaxLimit((OfflinePlayer)p))).replace("%numberofhomes%", String.valueOf(Main.hu.numberOfHomes((OfflinePlayer)p))).replace("%homes%", Main.hu.homes((OfflinePlayer)p)));
            p.sendMessage(text);
        }

        default public void sendMsg(CommandSender s, String text) {
            if (text.isEmpty()) {
                return;
            }
            text = Helper.getText(s, text);
            if (s instanceof Player) {
                Player p = (Player)s;
                text = text.replace("%limit%", String.valueOf(Main.cfgu.getMaxLimit((OfflinePlayer)p))).replace("%numberofhomes%", String.valueOf(Main.hu.numberOfHomes((OfflinePlayer)p))).replace("%homes%", Main.hu.homes((OfflinePlayer)p));
            }
            s.sendMessage(text);
        }

        default public void broadcast(String text) {
            if (text.isEmpty()) {
                return;
            }
            text = Helper.getText(null, text);
            Bukkit.getServer().broadcastMessage(text);
        }

        public static String getText(CommandSender s, String text) {
            text = StringUtils.transform(text.replace("%prefix%", Main.cfgu.prefix()));
            if (s instanceof Player) {
                Player p = (Player)s;
                text = StringUtils.transform((OfflinePlayer)p, text);
            }
            return text;
        }

        public static String getText(String text) {
            return Helper.getText(null, text);
        }
    }

    public static interface Commands
    extends Helper {
        public String getCmd();

        public String getUsage();

        public String getOutput();
    }

    public static class CommandsMSG
    implements Helper {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        public String getHomeAlreadyExist() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "home-already-exist");
            return this.cfg.getString(path);
        }

        public String getHomeDoesntExist() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "home-doesnt-exist");
            return this.cfg.getString(path);
        }

        public String getHomeDoesntExistOthers(OfflinePlayer p) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "home-doesnt-exist-others");
            return this.cfg.getString(path).replace("%player%", Objects.requireNonNull(p.getName()));
        }

        public String getNoPermission() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "no-permission");
            return this.cfg.getString(path);
        }

        public String getOnlyPlayers() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "only-players");
            return this.cfg.getString(path);
        }

        public String getCantUse2Dot() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "cant-use-2dot");
            return this.cfg.getString(path);
        }

        public String getCantFindPlayer() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "cant-find-player");
            return this.cfg.getString(path);
        }

        public String getUnableToFindSafeLocation() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "unable-to-find-safe-location");
            return this.cfg.getString(path);
        }

        public String getWorldRestrictedSethome() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "world-restricted-sethome");
            return this.cfg.getString(path);
        }

        public String getWorldRestrictedHome() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, "world-restricted-home");
            return this.cfg.getString(path);
        }
    }

    public static class HooksMSG
    implements Helper {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        public String getGriefPreventionCantSetHomes() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.hooks, LanguageUtils.griefprevention, "cant-set-homes");
            return this.cfg.getString(path);
        }

        public String getWorldGuardCantUseHomes() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.hooks, LanguageUtils.worldguard, "cant-use-homes");
            return this.cfg.getString(path);
        }

        public String getWorldGuardCantSetHomes() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.hooks, LanguageUtils.worldguard, "cant-set-homes");
            return this.cfg.getString(path);
        }

        public String getVaultCantAfford(Float cost) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.hooks, LanguageUtils.vault, "cant-afford-command");
            return this.cfg.getString(path).replace("%cost%", Float.toString(cost.floatValue()));
        }
    }

    public static class TeleportWarmupMSG
    implements Helper {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        public String getWarmup(int time) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.tpw, "warmup");
            return this.cfg.getString(path).replace("%time%", String.valueOf(time));
        }

        public String getWarmupActionbar(int time) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.tpw, "warmup-actionbar");
            return this.cfg.getString(path).replace("%time%", String.valueOf(time));
        }

        public String getCancelled() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.tpw, "cancelled");
            return this.cfg.getString(path);
        }

        public String getCancelledActionbar() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.tpw, "cancelled-actionbar");
            return this.cfg.getString(path);
        }
    }

    public static class MainCMD
    implements Commands {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        @Override
        public String getCmd() {
            return "main";
        }

        @Override
        public String getUsage() {
            return null;
        }

        @Override
        public String getOutput() {
            return null;
        }

        public static class MainConverter
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.converter";
            }

            @Override
            public String getUsage() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            @Override
            public String getOutput() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            public String getError() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "error");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }
        }

        public static class MainNearhomes
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.nearhomes";
            }

            @Override
            public String getUsage() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            @Override
            public String getOutput() {
                return null;
            }

            public String getOutput(HashMap<OfflinePlayer, List<String>> homes, double radius) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                StringBuilder homesList = new StringBuilder();
                for (OfflinePlayer p : homes.keySet()) {
                    for (String home : homes.get(p)) {
                        if (!homesList.toString().isEmpty()) {
                            homesList.append(", ");
                        }
                        homesList.append(this.getHomeString(p, home));
                    }
                }
                if (homesList.toString().isEmpty()) {
                    return this.cfg.getString(path + "-not-found").replace("%command%", Main.cfgu.CmdMainCommand()).replace("%radius%", String.valueOf(radius));
                }
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%radius%", String.valueOf(radius)).replace("%homes%", homesList.toString());
            }

            private String getHomeString(OfflinePlayer p, String home) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "home-string");
                return this.cfg.getString(path).replace("%owner%", p == null || p.getName() == null ? "----" : p.getName()).replace("%home%", home);
            }
        }

        public static class MainReload
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.reload";
            }

            @Override
            public String getUsage() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            @Override
            public String getOutput() {
                return null;
            }

            public String getOutput(long time) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%time%", String.valueOf(time));
            }

            public String getOutputCommands(long time) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "commands.output");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%time%", String.valueOf(time));
            }

            public String getOutputConfig(long time) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "config.output");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%time%", String.valueOf(time));
            }

            public String getOutputLanguages(long time) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "languages.output");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%time%", String.valueOf(time));
            }
        }

        public static class MainInfo
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.info";
            }

            @Override
            public String getUsage() {
                return null;
            }

            @Override
            public String getOutput() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%name%", main.getDescription().getName()).replace("%version%", main.getDescription().getVersion()).replace("%author%", String.join((CharSequence)", ", main.getDescription().getAuthors())).replace("%server.software%", Bukkit.getServer().getName()).replace("%server.version%", Bukkit.getServer().getVersion() + " - " + Bukkit.getBukkitVersion()).replace("%requpdate%", Main.needsUpdate ? this.cfg.getString(me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "requpdate-yes")) : this.cfg.getString(me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "requpdate-no"))).replace("%command%", Main.cfgu.CmdMainCommand()).replace("%storage.type%", Main.db.databaseType()).replace("%storage.users%", String.valueOf(Main.dbe.getTotalUsers())).replace("%storage.homes%", String.valueOf(Main.dbe.getTotalHomes())).replace("%language%", ConfigUtils.langType()).replace("%use.placeholderapi%", Main.usePlaceholderAPI ? "&aYes" : "&cNo").replace("%use.griefprevention%", Main.useGriefPrevention ? "&aYes" : "&cNo").replace("%use.worldguard%", Main.useWorldGuard ? "&aYes" : "&cNo").replace("%use.vault%", Main.useVault ? "&aYes" : "&cNo");
            }
        }

        public static class MainVersion
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.version";
            }

            @Override
            public String getUsage() {
                return null;
            }

            @Override
            public String getOutput() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%version%", main.getDescription().getVersion());
            }

            public static class MainVersionUpdate
            implements Commands {
                public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

                @Override
                public String getCmd() {
                    return "main.version.update";
                }

                @Override
                public String getUsage() {
                    return null;
                }

                @Override
                public String getOutput() {
                    return null;
                }

                public String getOutput(String newVersion) {
                    String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                    return this.cfg.getString(path).replace("%update%", newVersion);
                }

                public String getNoUpdate() {
                    String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "no-update");
                    return this.cfg.getString(path);
                }
            }
        }

        public static class MainHelp
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "main.help";
            }

            @Override
            public String getUsage() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "help-noperm");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            public String getUsageWithPerm() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "help-perm");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdMainCommand());
            }

            @Override
            public String getOutput() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%version%", main.getDescription().getVersion());
            }
        }
    }

    public static class Homes
    implements Commands {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        @Override
        public String getCmd() {
            return "homes";
        }

        @Override
        public String getUsage() {
            return null;
        }

        @Override
        public String getOutput() {
            return null;
        }

        public String getOutputSelf(Player p) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomesCommand()).replace("%homes%", Main.hu.homes((OfflinePlayer)p)).replace("%amount%", String.valueOf(Main.hu.numberOfHomes((OfflinePlayer)p)));
        }

        public String getInvalidPage() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "invalid-page");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomesCommand());
        }

        public String getOutput(OfflinePlayer p) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "others.output");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomesCommand()).replace("%homes%", Main.hu.homes(p)).replace("%amount%", String.valueOf(Main.hu.numberOfHomes(p))).replace("%player%", Objects.requireNonNull(p.getName()));
        }
    }

    public static class Home
    implements Commands {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        @Override
        public String getCmd() {
            return "home";
        }

        @Override
        public String getUsage() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomeCommand());
        }

        @Override
        public String getOutput() {
            return null;
        }

        public String getOutput(String home) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomeCommand()).replace("%home%", home);
        }

        public String getCantDimensionalTeleport() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "cant-dimensional-teleport");
            return this.cfg.getString(path);
        }

        public static class HomeRename
        implements Commands {
            public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

            @Override
            public String getCmd() {
                return "home.rename";
            }

            @Override
            public String getUsage() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
                return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdHomeCommand());
            }

            @Override
            public String getOutput() {
                return null;
            }

            public String getOutput(String home, String newname) {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
                return this.cfg.getString(path).replace("%home%", home).replace("%newname%", newname);
            }

            public String getSameName() {
                String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "same-name");
                return this.cfg.getString(path);
            }
        }
    }

    public static class Delhome
    implements Commands {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        @Override
        public String getCmd() {
            return "delhome";
        }

        @Override
        public String getUsage() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdDelhomeCommand());
        }

        @Override
        public String getOutput() {
            return null;
        }

        public String getOutput(String home) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdDelhomeCommand()).replace("%home%", home);
        }
    }

    public static class Sethome
    extends HomesUtils
    implements Commands {
        public final YamlConfiguration cfg = LanguageUtils.getConfigFile();

        @Override
        public String getCmd() {
            return "sethome";
        }

        @Override
        public String getUsage() {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "usage");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdSethomeCommand());
        }

        @Override
        public String getOutput() {
            return null;
        }

        public String getOutput(String home) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "output");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdSethomeCommand()).replace("%home%", home);
        }

        public String getLimitReached(Player p) {
            String path = me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils.formPath(LanguageUtils.cmds, this.getCmd(), "limit-reached");
            return this.cfg.getString(path).replace("%command%", Main.cfgu.CmdSethomeCommand()).replace("%limit%", String.valueOf(Main.hu.getMaxLimit((OfflinePlayer)p)));
        }
    }
}

