/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.yleoft.zHomes.shaded.zAPI.Metrics;
import me.yleoft.zHomes.shaded.zAPI.handlers.PlaceholderAPIHandler;
import me.yleoft.zHomes.shaded.zAPI.listeners.DupeFixerListeners;
import me.yleoft.zHomes.shaded.zAPI.listeners.ItemListeners;
import me.yleoft.zHomes.shaded.zAPI.listeners.PlayerListeners;
import me.yleoft.zHomes.shaded.zAPI.managers.PluginYAMLManager;
import me.yleoft.zHomes.shaded.zAPI.utils.LogUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class zAPI {
    private static String VERSION;
    private static int bStatsId;
    public static final String customCommandNBT = "zAPI:customCommand";
    public static PlaceholderAPIHandler placeholderAPIHandler;
    public static boolean useNBTAPI;
    private static JavaPlugin plugin;
    private static String pluginName;
    private static String coloredPluginName;
    private static Object papi;
    private static boolean usingFolia;

    public static void init(@NotNull JavaPlugin plugin, @NotNull String pluginName, @NotNull String coloredPluginName, boolean useNBTAPI) {
        zAPI.plugin = plugin;
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.RegionScheduler");
            usingFolia = true;
        }
        catch (ClassNotFoundException e) {
            usingFolia = false;
        }
        zAPI.pluginName = pluginName;
        zAPI.coloredPluginName = coloredPluginName;
        zAPI.useNBTAPI = useNBTAPI;
        placeholderAPIHandler = new PlaceholderAPIHandler();
        PluginYAMLManager.registerEvent(new PlayerListeners());
        if (useNBTAPI) {
            PluginYAMLManager.registerEvent(new DupeFixerListeners());
            PluginYAMLManager.registerEvent(new ItemListeners());
        }
        plugin.getLogger().info("[zAPI] Initialized zAPI v" + VERSION + " using " + plugin.getName() + " v" + plugin.getDescription().getVersion());
        try {
            new zAPIMetrics(plugin, bStatsId);
            plugin.getLogger().info("[zAPI] Using the plugin '" + pluginName + "' to create a bStats instance!");
        }
        catch (Exception ignored) {
            plugin.getLogger().warning("[zAPI] Failed to create a bStats instance.");
        }
    }

    public static void init(@NotNull JavaPlugin plugin, @NotNull String pluginName, @NotNull String coloredPluginName) {
        zAPI.init(plugin, pluginName, coloredPluginName, false);
    }

    public static void disable() {
        if (plugin == null) {
            return;
        }
        if (!zAPI.isFolia()) {
            Bukkit.getScheduler().cancelTasks((Plugin)plugin);
        }
        HandlerList.unregisterAll((Plugin)plugin);
        zAPI.unregisterPlaceholderExpansion();
        PluginYAMLManager.unregisterPermissions();
        LogUtils.compressLogs();
    }

    @NotNull
    public static JavaPlugin getPlugin() {
        return plugin;
    }

    @NotNull
    public static String getPluginName() {
        return pluginName;
    }

    public static void setPluginName(@NotNull String pluginName) {
        zAPI.pluginName = pluginName;
    }

    @NotNull
    public static String getColoredPluginName() {
        return coloredPluginName;
    }

    public static void setColoredPluginName(@NotNull String coloredPluginName) {
        zAPI.coloredPluginName = coloredPluginName;
    }

    public static PlaceholderExpansion getPlaceholderExpansion() {
        if (papi == null) {
            throw new RuntimeException("PlaceholderAPI is not enabled");
        }
        return (PlaceholderExpansion)papi;
    }

    public static Metrics startMetrics(int pluginId) {
        return new Metrics(plugin, pluginId);
    }

    public static void setPlaceholderAPIHandler(@NotNull PlaceholderAPIHandler handler) {
        placeholderAPIHandler = handler;
    }

    public static PlaceholderAPIHandler getPlaceholderAPIHandler() {
        return placeholderAPIHandler;
    }

    public static void registerPlaceholderExpansion(final @Nullable String identifier, final @NotNull String author, final @NotNull String version, final boolean canRegister, final boolean persist) {
        if (plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            papi = new PlaceholderExpansion(){

                @NotNull
                public String getIdentifier() {
                    return identifier == null ? plugin.getDescription().getName().toLowerCase() : identifier;
                }

                @NotNull
                public String getAuthor() {
                    return author;
                }

                @NotNull
                public String getVersion() {
                    return version;
                }

                public boolean canRegister() {
                    return canRegister;
                }

                public boolean persist() {
                    return persist;
                }

                public String onPlaceholderRequest(Player p, @NotNull String params) {
                    return placeholderAPIHandler.applyHookPlaceholders((OfflinePlayer)p, params);
                }
            };
            ((PlaceholderExpansion)papi).register();
        }
    }

    public static void registerPlaceholderExpansion(@NotNull String author, @NotNull String version, boolean canRegister, boolean persist) {
        zAPI.registerPlaceholderExpansion(null, author, version, canRegister, persist);
    }

    public static void unregisterPlaceholderExpansion() {
        if (papi != null) {
            ((PlaceholderExpansion)papi).unregister();
        }
    }

    public static boolean isFolia() {
        return usingFolia;
    }

    public static Economy setupEconomy() {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            throw new RuntimeException("Vault is not present on the server");
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            throw new RuntimeException("Unable to load Economy class on VaultAPI");
        }
        return (Economy)rsp.getProvider();
    }

    static {
        YamlConfiguration settings = new YamlConfiguration();
        String defaultVersion = "1.0.0";
        int defaultBStatsId = 26888;
        try (InputStream in = zAPI.class.getClassLoader().getResourceAsStream("settings.yml");){
            if (in != null) {
                settings.load((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                VERSION = settings.getString("version", defaultVersion);
                bStatsId = settings.getInt("bstats-id", defaultBStatsId);
            } else {
                VERSION = defaultVersion;
                bStatsId = defaultBStatsId;
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            VERSION = defaultVersion;
            bStatsId = defaultBStatsId;
        }
        useNBTAPI = false;
    }

    private static class zAPIMetrics
    extends Metrics {
        public zAPIMetrics(JavaPlugin plugin, int serviceId) {
            super(plugin, serviceId);
            this.addCustomChart(new Metrics.SimplePie("zapi_version", () -> VERSION));
            this.addCustomChart(new Metrics.DrilldownPie("parent_plugin", () -> {
                HashMap map = new HashMap();
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(zAPI.getPlugin().getDescription().getVersion(), 1);
                map.put(pluginName, entry);
                return map;
            }));
            this.addCustomChart(new Metrics.DrilldownPie("player_count", () -> {
                int players = Bukkit.getOnlinePlayers().size();
                return this.buildDistribution(players);
            }));
        }

        private Map<String, Map<String, Integer>> buildDistribution(int players) {
            HashMap<String, Map<String, Integer>> outer = new HashMap<String, Map<String, Integer>>();
            String outerBucket = this.outerBucket(players);
            String innerBucket = this.innerBucket(players);
            HashMap<String, Integer> inner = new HashMap<String, Integer>();
            inner.put(innerBucket, 1);
            outer.put(outerBucket, inner);
            return outer;
        }

        private String outerBucket(int n) {
            if (n <= 0) {
                return "0";
            }
            if (n <= 10) {
                return "1-10";
            }
            if (n <= 25) {
                return "11-25";
            }
            if (n <= 50) {
                return "26-50";
            }
            if (n <= 100) {
                return "51-100";
            }
            if (n <= 200) {
                return "101-200";
            }
            return "200+";
        }

        private String innerBucket(int n) {
            if (n <= 0) {
                return "0";
            }
            if (n <= 10) {
                return String.valueOf(n);
            }
            if (n <= 25) {
                return this.rangeOfFive(n, 11, 25);
            }
            if (n <= 50) {
                return this.rangeOfFive(n, 26, 50);
            }
            if (n <= 100) {
                return this.rangeOfFive(n, 51, 100);
            }
            if (n <= 200) {
                return this.rangeOfFive(n, 101, 200);
            }
            return "200+";
        }

        private String rangeOfFive(int n, int start, int end) {
            int bucketStart = (n - start) / 5 * 5 + start;
            int bucketEnd = Math.min(bucketStart + 4, end);
            return bucketStart + "-" + bucketEnd;
        }
    }
}

