/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import me.yleoft.zHomes.shaded.zAPI.mutable.MutableBlockLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocationUtils {
    private static final Set<Material> blacklistedGround = new HashSet<Material>();

    public static String serialize(@NotNull Location location) {
        String world = Objects.requireNonNull(location.getWorld()).getName();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float yaw = location.getYaw();
        float pitch = location.getPitch();
        return LocationUtils.serialize(world, x, y, z, yaw, pitch);
    }

    public static String serialize(@NotNull String world, double x, double y, double z, float yaw, float pitch) {
        return String.join((CharSequence)";", world, String.valueOf(x), String.valueOf(y), String.valueOf(z), String.valueOf(yaw), String.valueOf(pitch));
    }

    public static Location deserialize(@NotNull String serialized) {
        StringTokenizer tokenizer = new StringTokenizer(serialized, ";");
        World w = Bukkit.getWorld((String)tokenizer.nextToken());
        double x = Double.parseDouble(tokenizer.nextToken());
        double y = Double.parseDouble(tokenizer.nextToken());
        double z = Double.parseDouble(tokenizer.nextToken());
        float yaw = Float.parseFloat(tokenizer.nextToken());
        float pitch = Float.parseFloat(tokenizer.nextToken());
        return new Location(w, x, y, z, yaw, pitch);
    }

    private static void addIfExists(@NotNull String materialName) {
        try {
            Material mat = Material.valueOf((String)materialName);
            blacklistedGround.add(mat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Nullable
    public static Location findNearestSafeLocation(@NotNull Location origin, int radius, int heightCheckRange) {
        if (LocationUtils.isSafeLocation(origin)) {
            return origin;
        }
        World world = origin.getWorld();
        if (world == null) {
            return null;
        }
        int ox = origin.getBlockX();
        int oy = origin.getBlockY();
        int oz = origin.getBlockZ();
        ArrayList<Integer> yOffsets = new ArrayList<Integer>();
        for (int i = 0; i <= heightCheckRange; ++i) {
            yOffsets.add(i);
            if (i == 0) continue;
            yOffsets.add(-i);
        }
        Location bestLoc = null;
        double bestDistSq = Double.MAX_VALUE;
        MutableBlockLocation check = new MutableBlockLocation(world, ox, oy, oz);
        for (int r = 0; r <= radius; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) != r && Math.abs(z) != r) continue;
                    Iterator iterator = yOffsets.iterator();
                    while (iterator.hasNext()) {
                        double distSq;
                        int maxY;
                        int minY;
                        int yOffset = (Integer)iterator.next();
                        int y = oy + yOffset;
                        try {
                            minY = world.getMinHeight();
                            maxY = world.getMaxHeight();
                        }
                        catch (Throwable ignored) {
                            minY = 0;
                            maxY = 256;
                        }
                        if (y < minY || y > maxY) continue;
                        check.set(ox + x, y, oz + z);
                        Location temp = check.toLocation();
                        if (!LocationUtils.isSafeLocation(temp) || !((distSq = temp.distanceSquared(origin)) < bestDistSq)) continue;
                        bestDistSq = distSq;
                        bestLoc = temp.add(0.5, 0.0, 0.5);
                    }
                }
            }
        }
        return bestLoc;
    }

    public static boolean isSafeLocation(@NotNull Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Block feet = world.getBlockAt(loc);
        Block head = world.getBlockAt(loc.clone().add(0.0, 1.0, 0.0));
        Block ground = world.getBlockAt(loc.clone().add(0.0, -1.0, 0.0));
        return LocationUtils.isAirOrNonSolid(feet) && LocationUtils.isAirOrNonSolid(head) && LocationUtils.isSafeGround(ground);
    }

    private static boolean isAirOrNonSolid(@NotNull Block block) {
        return !block.getType().isSolid() && !block.isLiquid();
    }

    private static boolean isSafeGround(@NotNull Block block) {
        Material type = block.getType();
        return block.getType().isSolid() && !block.isLiquid() && !blacklistedGround.contains(type);
    }

    static {
        LocationUtils.addIfExists("CACTUS");
        LocationUtils.addIfExists("FIRE");
        LocationUtils.addIfExists("LAVA");
        LocationUtils.addIfExists("MAGMA_BLOCK");
        LocationUtils.addIfExists("CAMPFIRE");
        LocationUtils.addIfExists("SOUL_FIRE");
    }
}

