/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.EnchantmentUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.HeadUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.MaterialUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.NbtUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStackUtils {
    public static final String mark = "zAPI:" + zAPI.getPluginName() + "-unpickable";
    public static final Map<String, Integer> LEGACY_COLORS;

    @NotNull
    public static ItemStack getItemFromConfig(@Nullable Player player, @NotNull YamlConfiguration config, @Nullable String path, @Nullable Map<String, String> replacers) {
        ItemStack item;
        String material;
        int amount;
        if (path == null) {
            path = "";
        }
        String materialPath = ConfigUtils.formPath(path, "material");
        String amountPath = ConfigUtils.formPath(path, "amount");
        String namePath = ConfigUtils.formPath(path, "name");
        String lorePath = ConfigUtils.formPath(path, "lore");
        String enchantmentsPath = ConfigUtils.formPath(path, "enchantments");
        String unbreakablePath = ConfigUtils.formPath(path, "unbreakable");
        String itemflagsPath = ConfigUtils.formPath(path, "itemflags");
        String pickablePath = ConfigUtils.formPath(path, "pickable");
        String commandsPath = ConfigUtils.formPath(path, "commands");
        int n = amount = config.contains(amountPath) ? config.getInt(amountPath) : 1;
        if (config.isList(materialPath)) {
            List materials = config.getStringList(materialPath);
            material = (String)materials.get((int)Math.floor(Math.random() * (double)materials.size()));
        } else {
            material = Objects.requireNonNull(config.getString(materialPath));
        }
        if (material.startsWith("head-") || material.startsWith("base64head-") || material.startsWith("namehead-") || material.startsWith("urlhead-")) {
            String[] split = material.split("-");
            String type = split[0];
            String value = StringUtils.applyPlaceholders((OfflinePlayer)player, split[1]);
            item = HeadUtils.getPlayerHeadFromString(type, value);
        } else {
            item = MaterialUtils.isLegacyMaterial(material) ? ItemStackUtils.getLegacyItem(material, amount) : ItemStackUtils.getItem(material, amount);
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (config.contains(namePath) && config.isString(namePath)) {
                meta.setDisplayName(StringUtils.transform((OfflinePlayer)player, Objects.requireNonNull(config.getString(namePath))));
            }
            if (config.contains(lorePath) && (config.isString(lorePath) || config.isList(lorePath))) {
                List<String> lore = config.isList(lorePath) ? config.getStringList(lorePath).stream().map(loreLine -> StringUtils.transform((OfflinePlayer)player, loreLine)).collect(Collectors.toList()) : Collections.singletonList(StringUtils.transform((OfflinePlayer)player, Objects.requireNonNull(config.getString(lorePath))));
                meta.setLore(lore);
            }
            if (config.contains(enchantmentsPath) && (config.isString(enchantmentsPath) || config.isList(enchantmentsPath))) {
                List<String> enchantments = config.isList(enchantmentsPath) ? config.getStringList(enchantmentsPath) : Collections.singletonList(Objects.requireNonNull(config.getString(enchantmentsPath)));
                for (String enchantmentString : enchantments) {
                    Enchantment enchantment;
                    enchantmentString = StringUtils.applyPlaceholders((OfflinePlayer)player, enchantmentString);
                    int level = 1;
                    if (enchantmentString.contains(";")) {
                        String[] split = enchantmentString.split(";");
                        if (split.length == 2 && StringUtils.isInteger(split[1])) {
                            level = Integer.parseInt(split[1]) > 1 ? Integer.parseInt(split[1]) : level;
                        }
                        enchantmentString = split[0];
                    }
                    if ((enchantment = EnchantmentUtils.getEnchantment(enchantmentString)) == null) continue;
                    meta.addEnchant(enchantment, level, true);
                }
            }
            if (config.contains(unbreakablePath) && config.isBoolean(unbreakablePath)) {
                boolean unbreakable = config.getBoolean(unbreakablePath);
                try {
                    meta.setUnbreakable(unbreakable);
                }
                catch (NoSuchMethodError e) {
                    zAPI.getPlugin().getLogger().warning("[zAPI] Your server version does not support unbreakable items (Tried to load menu with unbreakable item).");
                }
            }
            if (config.contains(itemflagsPath) && (config.isString(itemflagsPath) || config.isList(itemflagsPath))) {
                List<String> itemFlags = config.isList(itemflagsPath) ? config.getStringList(itemflagsPath) : Collections.singletonList(Objects.requireNonNull(config.getString(itemflagsPath)));
                ArrayList<ItemFlag> flagsToAdd = new ArrayList<ItemFlag>();
                for (String flagString : itemFlags) {
                    ItemFlag flag;
                    if (flagString == null || flagString.trim().isEmpty() || (flag = ItemStackUtils.getItemFlagFromString(flagString = StringUtils.applyPlaceholders((OfflinePlayer)player, flagString).trim())) == null) continue;
                    flagsToAdd.add(flag);
                }
                if (!flagsToAdd.isEmpty()) {
                    meta.addItemFlags(flagsToAdd.toArray(new ItemFlag[0]));
                }
            }
            item.setItemMeta(meta);
        }
        boolean pickable = config.contains(pickablePath) && config.isBoolean(pickablePath) && config.getBoolean(pickablePath);
        NbtUtils.markItem(item, mark, !pickable);
        List<String> commands = new ArrayList<String>();
        if (config.contains(commandsPath)) {
            List<String> list = commands = config.isList(commandsPath) ? config.getStringList(commandsPath) : Collections.singletonList(Objects.requireNonNull(config.getString(commandsPath)));
        }
        if (replacers != null && !replacers.isEmpty()) {
            NbtUtils.addCustomCommands(item, commands, replacers);
        } else {
            NbtUtils.addCustomCommands(item, commands);
        }
        return item;
    }

    @NotNull
    public static ItemStack getItemFromConfig(@Nullable Player player, @NotNull YamlConfiguration config, @Nullable String path) {
        return ItemStackUtils.getItemFromConfig(player, config, path, null);
    }

    @NotNull
    public static ItemStack getItem(@NotNull String materialString, int amount) {
        Material material = MaterialUtils.getMaterial(materialString);
        return new ItemStack(material, amount);
    }

    public static void replaceAll(@NotNull ItemStack item, @NotNull Map<String, String> replaces) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ItemStackUtils.replaceName(meta, replaces);
            ItemStackUtils.replaceLore(meta, replaces);
            item.setItemMeta(meta);
        }
    }

    public static ItemMeta replaceLore(@NotNull ItemMeta meta, @NotNull Map<String, String> replaces) {
        List lore = meta.getLore();
        if (lore != null) {
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                for (String key : replaces.keySet()) {
                    line = line.replace(key, replaces.get(key));
                }
                lore.set(i, line);
            }
            meta.setLore(lore);
        }
        return meta;
    }

    public static ItemStack replaceLore(@NotNull ItemStack item, @NotNull Map<String, String> replaces) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore = meta.getLore();
            if (lore != null) {
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    for (String key : replaces.keySet()) {
                        line = line.replace(key, replaces.get(key));
                    }
                    lore.set(i, line);
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    public static ItemMeta replaceName(@NotNull ItemMeta meta, @NotNull Map<String, String> replaces) {
        String name = meta.getDisplayName();
        for (String key : replaces.keySet()) {
            name = name.replace(key, replaces.get(key));
        }
        meta.setDisplayName(name);
        return meta;
    }

    @NotNull
    public static ItemStack replaceName(@NotNull ItemStack item, @NotNull Map<String, String> replaces) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ItemStackUtils.replaceName(meta, replaces);
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    public static ItemStack getLegacyItem(@NotNull String color, @NotNull String material) {
        color = color.toUpperCase();
        material = material.toUpperCase();
        if (!LEGACY_COLORS.containsKey(color)) {
            throw new IllegalArgumentException("Invalid color: " + color);
        }
        short data = (short)LEGACY_COLORS.get(color).intValue();
        try {
            ItemStack item = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)material)), 1);
            item.setDurability(data);
            return item;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid material: " + material, e);
        }
    }

    @NotNull
    public static ItemStack getLegacyItem(@NotNull String modernName, int amount) {
        Material material = Material.STONE;
        short data = 0;
        if (LEGACY_COLORS.keySet().stream().anyMatch(modernName::startsWith)) {
            String color = Objects.requireNonNull(LEGACY_COLORS.keySet().stream().filter(modernName::startsWith).findFirst().orElse(null));
            String type = modernName.substring(color.length() + 1);
            ItemStack item = ItemStackUtils.getLegacyItem(color, type);
            item.setAmount(amount);
            return item;
        }
        ItemStack item = new ItemStack(material, amount);
        item.setDurability(data);
        return item;
    }

    @Nullable
    private static ItemFlag getItemFlagFromString(@NotNull String raw) {
        String s = raw.trim();
        s = s.replace(" ", "_").replace("-", "_");
        try {
            return ItemFlag.valueOf((String)s.toUpperCase());
        }
        catch (Exception exception) {
            String upper = s.toUpperCase();
            String withoutHide = upper.startsWith("HIDE_") ? upper.substring(5) : upper;
            String lower = withoutHide.toLowerCase();
            if (lower.contains("enchant")) {
                return ItemFlag.HIDE_ENCHANTS;
            }
            if (lower.contains("attribut") || lower.contains("attributte") || lower.contains("attributtes") || lower.contains("attributes")) {
                return ItemFlag.HIDE_ATTRIBUTES;
            }
            if (lower.contains("unbreak")) {
                return ItemFlag.HIDE_UNBREAKABLE;
            }
            if (lower.contains("destro")) {
                return ItemFlag.HIDE_DESTROYS;
            }
            if (lower.contains("placed") || lower.contains("placed_on")) {
                return ItemFlag.HIDE_PLACED_ON;
            }
            try {
                return ItemFlag.valueOf((String)("HIDE_" + withoutHide));
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    static {
        HashMap<String, Integer> _map = new HashMap<String, Integer>();
        _map.put("WHITE", 0);
        _map.put("ORANGE", 1);
        _map.put("MAGENTA", 2);
        _map.put("LIGHT_BLUE", 3);
        _map.put("YELLOW", 4);
        _map.put("LIME", 5);
        _map.put("PINK", 6);
        _map.put("GRAY", 7);
        _map.put("LIGHT_GRAY", 8);
        _map.put("CYAN", 9);
        _map.put("PURPLE", 10);
        _map.put("BLUE", 11);
        _map.put("BROWN", 12);
        _map.put("GREEN", 13);
        _map.put("RED", 14);
        _map.put("BLACK", 15);
        LEGACY_COLORS = Collections.unmodifiableMap(_map);
    }
}

