/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private FileConfiguration newConfig = null;
    private final File configFile;
    private final String resource;

    public FileUtils(@NotNull File file, @NotNull String resource) {
        this.configFile = file;
        this.resource = resource;
    }

    public FileConfiguration getConfig() {
        if (this.newConfig == null) {
            this.reloadConfig();
        }
        return this.newConfig;
    }

    public String getResource() {
        return this.resource;
    }

    public File getFile() {
        return this.configFile;
    }

    public void reloadConfig(boolean copyDefaults) {
        try {
            this.newConfig = new YamlConfiguration();
            this.newConfig.load(this.configFile);
            InputStream defConfigStream = zAPI.getPlugin().getResource(this.resource);
            if (defConfigStream != null) {
                this.newConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, Charsets.UTF_8)));
            }
            this.saveDefaultConfig();
            this.getConfig().options().copyDefaults(copyDefaults);
            this.saveConfig();
        }
        catch (IOException | InvalidConfigurationException ex) {
            zAPI.getPlugin().getLogger().log(Level.SEVERE, "Failed to load YAML file: " + this.configFile.getName(), ex);
            zAPI.getPlugin().getServer().getConsoleSender().sendMessage(zAPI.getColoredPluginName() + "\u00a7cError loading \u00a7f" + this.configFile.getName() + "\u00a7c! Backing up and restoring default config...");
            this.backupBrokenConfig();
            this.saveDefaultConfig();
            this.reloadConfig(copyDefaults);
        }
    }

    public void reloadConfig() {
        this.reloadConfig(true);
    }

    public void saveConfig() {
        try {
            if (this.newConfig != null) {
                this.newConfig.save(this.configFile);
            }
        }
        catch (IOException ex) {
            zAPI.getPlugin().getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile.getName(), ex);
        }
    }

    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.saveResource(this.resource, false);
        }
    }

    private void backupBrokenConfig() {
        if (!this.configFile.exists()) {
            return;
        }
        String backupName = this.configFile.getName() + ".broken." + System.currentTimeMillis();
        File backupFile = new File(this.configFile.getParentFile(), backupName);
        try {
            if (this.configFile.renameTo(backupFile)) {
                zAPI.getPlugin().getLogger().warning("Backed up broken config to: " + backupFile.getName());
            } else {
                zAPI.getPlugin().getLogger().warning("Failed to backup broken config file.");
            }
        }
        catch (Exception e) {
            zAPI.getPlugin().getLogger().log(Level.SEVERE, "Error while backing up config file", e);
        }
    }

    public void saveResource(String resourcePath, boolean replace) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        resourcePath = resourcePath.replace('\\', '/');
        InputStream in = zAPI.getPlugin().getResource(resourcePath);
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + zAPI.getColoredPluginName());
        }
        File outFile = new File(zAPI.getPlugin().getDataFolder(), resourcePath);
        File outDir = outFile.getParentFile();
        if (!outDir.exists() && !outDir.mkdirs()) {
            zAPI.getPlugin().getLogger().log(Level.WARNING, "Failed to create directory: " + outDir);
            return;
        }
        if (!outFile.exists() || replace) {
            try (OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                zAPI.getPlugin().getServer().getConsoleSender().sendMessage(zAPI.getColoredPluginName() + "\u00a7eFile \u00a7f'" + resourcePath + "' \u00a7ehas been created.");
            }
            catch (IOException ex) {
                zAPI.getPlugin().getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
            }
        } else {
            zAPI.getPlugin().getLogger().log(Level.WARNING, "File " + outFile.getName() + " already exists and won't be replaced.");
        }
    }
}

