/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.managers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginYAMLManager {
    private static final PluginDescriptionFile file = zAPI.getPlugin().getDescription();
    private static final Map<Command, Double> cmds = new HashMap<Command, Double>();
    private static final List<String> perms = new ArrayList<String>();
    public static final Map<Player, Long> cacheCooldown = new HashMap<Player, Long>();
    public static final TabExecutor emptyExec = new TabExecutor(){

        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
            return false;
        }

        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
            return null;
        }
    };

    public static void syncCommands() {
        try {
            Method syncCommandsMethod = zAPI.getPlugin().getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            syncCommandsMethod.setAccessible(true);
            syncCommandsMethod.invoke((Object)zAPI.getPlugin().getServer(), new Object[0]);
        }
        catch (NoSuchMethodException syncCommandsMethod) {
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not invoke syncCommands method", e);
        }
    }

    public static void unregisterCommands() {
        try {
            Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            CommandMap commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            HashMap<String, Command> commandsToCheck = new HashMap<String, Command>();
            String pluginNameLower = zAPI.getPluginName() == null ? "" : zAPI.getPluginName().toLowerCase(Locale.ROOT);
            for (Command command : cmds.keySet()) {
                commandsToCheck.put(command.getLabel().toLowerCase(Locale.ROOT), command);
                commandsToCheck.put(command.getName().toLowerCase(Locale.ROOT), command);
                for (String a : command.getAliases()) {
                    commandsToCheck.put(a.toLowerCase(Locale.ROOT), command);
                }
                if (pluginNameLower.isEmpty()) continue;
                commandsToCheck.put(pluginNameLower + ":" + command.getLabel().toLowerCase(Locale.ROOT), command);
                commandsToCheck.put(pluginNameLower + ":" + command.getName().toLowerCase(Locale.ROOT), command);
                for (String a : command.getAliases()) {
                    commandsToCheck.put(pluginNameLower + ":" + a.toLowerCase(Locale.ROOT), command);
                }
            }
            for (Map.Entry entry : commandsToCheck.entrySet()) {
                String key = (String)entry.getKey();
                Command registered = (Command)knownCommands.get(key);
                if (registered == null) continue;
                boolean isSameCommand = ((Command)entry.getValue()).equals(registered);
                boolean isOurPluginCommand = false;
                if (registered instanceof PluginCommand) {
                    try {
                        PluginCommand pCmd = (PluginCommand)registered;
                        Plugin owning = pCmd.getPlugin();
                        if (owning != null && owning.equals((Object)zAPI.getPlugin())) {
                            isOurPluginCommand = true;
                        }
                    }
                    catch (Throwable pCmd) {
                        // empty catch block
                    }
                }
                if (isSameCommand || isOurPluginCommand) {
                    try {
                        registered.unregister(commandMap);
                    }
                    catch (Exception pCmd) {
                        // empty catch block
                    }
                    knownCommands.remove(key);
                    continue;
                }
                if (!(entry.getValue() instanceof PluginCommand)) continue;
                try {
                    PluginCommand mappedPCmd;
                    CommandExecutor mappedExec;
                    PluginCommand checkPCmd = (PluginCommand)entry.getValue();
                    if (registered instanceof PluginCommand && (mappedExec = (mappedPCmd = (PluginCommand)registered).getExecutor()) != null && mappedExec.equals((Object)checkPCmd.getExecutor())) {
                        mappedPCmd.setExecutor(null);
                        mappedPCmd.setTabCompleter(null);
                    }
                    checkPCmd.setExecutor((CommandExecutor)emptyExec);
                    checkPCmd.setTabCompleter((TabCompleter)emptyExec);
                }
                catch (Exception exception) {}
            }
            knownCommandsField.setAccessible(false);
            f.setAccessible(false);
            cmds.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unregisterCommand(@NotNull String command) {
        try {
            Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            CommandMap commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            String cmdLower = command.toLowerCase(Locale.ROOT);
            String pluginNameLower = zAPI.getPluginName() == null ? "" : zAPI.getPluginName().toLowerCase(Locale.ROOT);
            ArrayList<String> keysToCheck = new ArrayList<String>();
            keysToCheck.add(cmdLower);
            if (!pluginNameLower.isEmpty()) {
                keysToCheck.add(pluginNameLower + ":" + cmdLower);
            }
            HashSet<Command> trackedMatching = new HashSet<Command>();
            block8: for (Command c : cmds.keySet()) {
                if (c.getLabel().equalsIgnoreCase(command) || c.getName().equalsIgnoreCase(command)) {
                    trackedMatching.add(c);
                    continue;
                }
                for (String a : c.getAliases()) {
                    if (!a.equalsIgnoreCase(command)) continue;
                    trackedMatching.add(c);
                    continue block8;
                }
            }
            for (String key : keysToCheck) {
                Command mapped = (Command)knownCommands.get(key);
                if (mapped == null) continue;
                boolean isSame = trackedMatching.contains(mapped);
                boolean isOurPluginCommand = false;
                if (mapped instanceof PluginCommand) {
                    try {
                        PluginCommand pCmd = (PluginCommand)mapped;
                        Plugin owning = pCmd.getPlugin();
                        if (owning != null && owning.equals((Object)zAPI.getPlugin())) {
                            isOurPluginCommand = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (isSame || isOurPluginCommand) {
                    try {
                        mapped.unregister(commandMap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    knownCommands.remove(key);
                    continue;
                }
                for (Command t : trackedMatching) {
                    if (!(t instanceof PluginCommand)) continue;
                    try {
                        PluginCommand mappedPCmd;
                        CommandExecutor mappedExec;
                        PluginCommand checkPCmd = (PluginCommand)t;
                        if (mapped instanceof PluginCommand && (mappedExec = (mappedPCmd = (PluginCommand)mapped).getExecutor()) != null && mappedExec.equals((Object)checkPCmd.getExecutor())) {
                            mappedPCmd.setExecutor(null);
                            mappedPCmd.setTabCompleter(null);
                        }
                        checkPCmd.setExecutor((CommandExecutor)emptyExec);
                        checkPCmd.setTabCompleter((TabCompleter)emptyExec);
                    }
                    catch (Exception exception) {}
                }
            }
            for (Command t : trackedMatching) {
                cmds.remove(t);
            }
            knownCommandsField.setAccessible(false);
            f.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerCommand(@NotNull String command, @NotNull CommandExecutor ce, @Nullable Double cooldown, @Nullable TabCompleter completer, @NotNull String description, String ... aliases) {
        if (cooldown == null) {
            cooldown = 0.0;
        }
        if (!file.getCommands().containsKey(command)) {
            try {
                Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                c.setAccessible(true);
                f.setAccessible(true);
                PluginCommand cmd = (PluginCommand)c.newInstance(command, zAPI.getPlugin());
                cmd.setDescription(description);
                cmd.setExecutor(ce);
                if (completer != null) {
                    cmd.setTabCompleter(completer);
                }
                ArrayList<Object> aliasesList = new ArrayList();
                try {
                    aliasesList = new ArrayList<String>(Arrays.asList(aliases));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cmd.setAliases(aliasesList);
                CommandMap commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
                commandMap.register(zAPI.getPluginName(), (Command)cmd);
                cmds.put((Command)cmd, cooldown);
                zAPI.getPlugin().getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(zAPI.getColoredPluginName() + "&aLoaded command &e/" + command)));
            }
            catch (Exception e) {
                e.printStackTrace();
                zAPI.getPlugin().getLogger().severe(zAPI.getColoredPluginName() + "\u00a74Couldn't load command \u00a7e" + command);
            }
        } else {
            zAPI.getPlugin().getLogger().severe(zAPI.getColoredPluginName() + "\u00a74Couldn't load command \u00a7e" + command + "\u00a74, it is already registered!");
        }
    }

    public static void registerCommand(@NotNull String command, @NotNull CommandExecutor ce, @Nullable TabCompleter completer, @NotNull String description, String ... aliases) {
        PluginYAMLManager.registerCommand(command, ce, null, completer, description, aliases);
    }

    public static void registerCommand(@NotNull String command, @NotNull CommandExecutor ce, @Nullable Double cooldown, @NotNull String description, String ... aliases) {
        PluginYAMLManager.registerCommand(command, ce, cooldown, null, description, aliases);
    }

    public static void registerCommand(@NotNull String command, @NotNull CommandExecutor ce, @NotNull String description, String ... aliases) {
        PluginYAMLManager.registerCommand(command, ce, null, null, description, aliases);
    }

    public static boolean isCommandRegistered(@NotNull String command) {
        return file.getCommands().containsKey(command);
    }

    public static void unregisterPermissions() {
        for (String perm : perms) {
            PluginYAMLManager.unregisterPermission(perm);
        }
    }

    public static void unregisterPermission(@NotNull String permission) {
        Bukkit.getPluginManager().removePermission(permission);
    }

    public static void unregisterPermission(@NotNull Permission permission) {
        Bukkit.getPluginManager().removePermission(permission);
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description, @Nullable PermissionDefault def, @Nullable Map<String, Boolean> children) {
        if (Bukkit.getPluginManager().getPermission(permission) == null) {
            Bukkit.getPluginManager().addPermission(new Permission(permission, description, def, children));
        }
        if (!perms.contains(permission)) {
            perms.add(permission);
        }
    }

    public static void registerPermission(@NotNull String permission) {
        PluginYAMLManager.registerPermission(permission, null, null, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description) {
        PluginYAMLManager.registerPermission(permission, description, null, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable PermissionDefault def) {
        PluginYAMLManager.registerPermission(permission, null, def, null);
    }

    public static void registerPermission(@NotNull String permission, @Nullable String description, @Nullable PermissionDefault def) {
        PluginYAMLManager.registerPermission(permission, description, def, null);
    }

    public static void registerTabCompleter(@NotNull String command, @NotNull TabCompleter tc) {
        try {
            Objects.requireNonNull(zAPI.getPlugin().getCommand(command)).setTabCompleter(tc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerEvent(@NotNull Listener l) {
        zAPI.getPlugin().getServer().getPluginManager().registerEvents(l, (Plugin)zAPI.getPlugin());
    }

    public static Map<Command, Double> getCmds() {
        return cmds;
    }
}

