/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.shaded.zAPI.utils.LogUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.jetbrains.annotations.NotNull;

public abstract class LogManager {
    private static final List<CustomLog> logFiles = new ArrayList<CustomLog>();
    private static final File logFolder = new File(zAPI.getPlugin().getDataFolder(), "logs");

    public static List<LogUtils> getFiles() {
        ArrayList<LogUtils> lus = new ArrayList<LogUtils>();
        logFiles.forEach(cl -> lus.add(cl.getLu()));
        return lus;
    }

    public static LogUtils createFile(@NotNull String name) {
        for (CustomLog cl : logFiles) {
            if (!cl.getName().equals(name)) continue;
            return cl.getLu();
        }
        CustomLog cl = new CustomLog(name);
        logFiles.add(cl);
        return cl.getLu();
    }

    public static LogUtils getLogUtil(@NotNull String name) {
        for (CustomLog cl : logFiles) {
            if (!cl.getName().equals(name)) continue;
            return cl.getLu();
        }
        throw new IllegalArgumentException("Unable to find log file: " + name);
    }

    public static File getFile(@NotNull String name) {
        return LogManager.getLogUtil(name).getLogFile();
    }

    public static File getLogFolder() {
        return logFolder;
    }

    static {
        logFolder.mkdirs();
    }

    private static class CustomLog {
        private final LogUtils lu;
        private final String name;

        public CustomLog(@NotNull String name) {
            this.lu = new LogUtils(logFolder, name);
            this.name = name;
        }

        public File getFile() {
            return this.lu.getLogFile();
        }

        public LogUtils getLu() {
            return this.lu;
        }

        public String getName() {
            return this.name;
        }
    }
}

