/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class LanguageManager {
    private final File folder;
    private final String languageCode;
    private final String fallbackLanguageCode;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Map<String, Object> fallbackOptions = new HashMap<String, Object>();
    private final File languageFile;
    private File fallbackFile;

    public LanguageManager(@NotNull File folder, @NotNull String languageCode) throws IOException {
        this(folder, languageCode, null);
    }

    public LanguageManager(@NotNull File folder, @NotNull String languageCode, @Nullable String fallbackLanguageCode) throws IOException {
        this.folder = folder;
        this.languageCode = languageCode;
        this.fallbackLanguageCode = fallbackLanguageCode;
        this.languageFile = new File(folder, languageCode + ".yml");
        if (!this.languageFile.exists()) {
            throw new IOException("Language file not found: " + this.languageFile.getAbsolutePath());
        }
        if (fallbackLanguageCode != null) {
            this.fallbackFile = new File(folder, fallbackLanguageCode + ".yml");
            if (!this.fallbackFile.exists()) {
                throw new IOException("Fallback language file not found: " + this.fallbackFile.getAbsolutePath());
            }
        }
        this.load();
    }

    public void reload() throws IOException {
        this.options.clear();
        this.fallbackOptions.clear();
        this.load();
    }

    public Object get(@NotNull String path) {
        if (this.options.containsKey(path)) {
            return this.options.get(path);
        }
        if (this.fallbackLanguageCode != null && this.fallbackOptions.containsKey(path)) {
            return this.fallbackOptions.get(path);
        }
        return null;
    }

    public String getString(@NotNull String path) {
        Object value = this.get(path);
        return value != null ? value.toString() : null;
    }

    private void load() throws IOException {
        Object data;
        Yaml yaml;
        try {
            Class<?> loaderOptionsClass = Class.forName("org.yaml.snakeyaml.LoaderOptions");
            yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        }
        catch (ClassNotFoundException | NoSuchMethodError e) {
            yaml = new Yaml();
        }
        try (FileInputStream inputStream = new FileInputStream(this.languageFile);){
            data = yaml.load((InputStream)inputStream);
            if (data instanceof Map) {
                this.flattenMap("", (Map)data, this.options);
            }
        }
        if (this.fallbackFile != null) {
            inputStream = new FileInputStream(this.fallbackFile);
            try {
                data = yaml.load((InputStream)inputStream);
                if (data instanceof Map) {
                    this.flattenMap("", (Map)data, this.fallbackOptions);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    private void flattenMap(String prefix, Map<?, ?> source, Map<String, Object> target) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String fullPath;
            String key = entry.getKey().toString();
            String string = fullPath = prefix.isEmpty() ? key : prefix + "." + key;
            if (entry.getValue() instanceof Map) {
                this.flattenMap(fullPath, (Map)entry.getValue(), target);
                continue;
            }
            target.put(fullPath, entry.getValue());
        }
    }

    public String getCurrentLanguage() {
        return this.languageCode;
    }

    public String getFallbackLanguage() {
        return this.fallbackLanguageCode;
    }

    public File getFolder() {
        return this.folder;
    }
}

