/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.shaded.zAPI.utils.FileUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class FileManager {
    private static final List<CustomFile> files = new ArrayList<CustomFile>();
    private static final File df = zAPI.getPlugin().getDataFolder();

    public static List<FileUtils> getFiles() {
        ArrayList<FileUtils> fus = new ArrayList<FileUtils>();
        files.forEach(cf -> fus.add(cf.getFu()));
        return fus;
    }

    public static FileUtils createFile(@NotNull String path) {
        for (CustomFile cf : files) {
            if (!cf.getPath().equals(path)) continue;
            return cf.getFu();
        }
        CustomFile cf = new CustomFile(path);
        files.add(cf);
        return cf.getFu();
    }

    public static FileUtils getFileUtil(@NotNull String path) {
        for (CustomFile cf : files) {
            if (!cf.getPath().equals(path)) continue;
            return cf.getFu();
        }
        throw new IllegalArgumentException("Unable to find file in: " + path);
    }

    public static YamlConfiguration getFile(@NotNull String path) {
        return (YamlConfiguration)FileManager.getFileUtil(path).getConfig();
    }

    private static class CustomFile {
        private final File file;
        private final FileUtils fu;
        private final String path;

        public CustomFile(@NotNull String path) {
            this.file = new File(df, path);
            this.fu = new FileUtils(this.file, path);
            this.path = path;
        }

        public File getFile() {
            return this.file;
        }

        public FileUtils getFu() {
            return this.fu;
        }

        public String getPath() {
            return this.path;
        }
    }
}

