/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.listeners;

import java.util.Locale;
import me.yleoft.zHomes.shaded.zAPI.managers.PluginYAMLManager;
import me.yleoft.zHomes.shaded.zAPI.mutable.Messages;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class PlayerListeners
implements Listener {
    @EventHandler
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String commandString = event.getMessage();
        String command = commandString.split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)command);
        if (PluginYAMLManager.getCmds().containsKey(pluginCommand)) {
            long currentTime = System.currentTimeMillis();
            if (PluginYAMLManager.cacheCooldown.containsKey(player)) {
                long cooldown = PluginYAMLManager.cacheCooldown.get(player);
                if (currentTime >= cooldown) {
                    PluginYAMLManager.cacheCooldown.remove(player);
                } else {
                    event.setCancelled(true);
                    double seconds = (double)(cooldown - currentTime) / 1000.0;
                    player.sendMessage(StringUtils.transform(Messages.getCooldownExpired(player, seconds)));
                }
            }
            if (!PluginYAMLManager.cacheCooldown.containsKey(player)) {
                double cooldown = PluginYAMLManager.getCmds().get(pluginCommand);
                if (cooldown == 0.0) {
                    return;
                }
                long cooldownInMills = (long)(cooldown * 1000.0);
                PluginYAMLManager.cacheCooldown.put(player, currentTime + cooldownInMills);
            }
        }
    }
}

