/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.listeners;

import me.yleoft.zHomes.shaded.zAPI.utils.InventoryUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.ItemStackUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.NbtUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.SchedulerUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.jetbrains.annotations.NotNull;

public class DupeFixerListeners
implements Listener {
    @EventHandler
    private void onClose(@NotNull InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        SchedulerUtils.runTaskLater(player.getLocation(), () -> InventoryUtils.cleanInventory(player, ItemStackUtils.mark), 3L);
    }

    @EventHandler
    private void onPickup(@NotNull EntityPickupItemEvent event) {
        if (!NbtUtils.isMarked(event.getItem().getItemStack(), ItemStackUtils.mark)) {
            return;
        }
        event.getItem().remove();
    }

    @EventHandler
    private void onDrop(@NotNull PlayerDropItemEvent event) {
        if (!NbtUtils.isMarked(event.getItemDrop().getItemStack(), ItemStackUtils.mark)) {
            return;
        }
        event.getItemDrop().remove();
    }

    @EventHandler
    private void onLogin(@NotNull PlayerLoginEvent event) {
        SchedulerUtils.runTaskLater(event.getPlayer().getLocation(), () -> InventoryUtils.cleanInventory(event.getPlayer(), ItemStackUtils.mark), 10L);
    }
}

