/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.yleoft.zHomes.shaded.zAPI.managers.PluginYAMLManager;
import me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.ItemStackUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.MaterialUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.NbtUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomInventory {
    public static final String configPathInventory = "Inventory";
    public static final String configPathItems = "Items";
    private YamlConfiguration config;
    private String inventoryName;
    private final int rows;
    private final Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();

    public static void loadMenuCommand(@NotNull YamlConfiguration config) {
        if (config.contains("command") && config.isString("command")) {
            String inventoryName = StringUtils.transform(Objects.requireNonNull(config.getString(ConfigUtils.formPath(configPathInventory, "title"))));
            String command = config.getString("command");
            if (!PluginYAMLManager.isCommandRegistered(command)) {
                PluginYAMLManager.registerCommand(command, (sender, cmd, label, args) -> {
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        CustomInventory inventory = new CustomInventory(p, config);
                        p.openInventory(inventory.getInventory());
                        return false;
                    }
                    return false;
                }, "Opens the custom inventory " + inventoryName, new String[0]);
            }
        }
    }

    public CustomInventory(@NotNull String inventoryName, int rows) {
        if (rows < 1 || rows > 6) {
            throw new IllegalArgumentException("Number of rows must be between 1 and 6");
        }
        this.inventoryName = inventoryName;
        this.rows = rows;
    }

    public CustomInventory(@Nullable Player player, @NotNull YamlConfiguration config) {
        this.config = config;
        this.inventoryName = StringUtils.transform((OfflinePlayer)player, Objects.requireNonNull(config.getString(ConfigUtils.formPath(configPathInventory, "title"))));
        this.rows = config.getInt(ConfigUtils.formPath(configPathInventory, "rows"), 3);
        for (String itemPath : config.getConfigurationSection(configPathItems).getKeys(false)) {
            String materialPath = ConfigUtils.formPath(configPathItems, itemPath, "material");
            String slotPath = ConfigUtils.formPath(configPathItems, itemPath, "slot");
            ItemStack item = ItemStackUtils.getItemFromConfig(player, config, ConfigUtils.formPath(configPathItems, itemPath));
            String slotS = config.getString(slotPath);
            assert (slotS != null);
            this.setItem(config, materialPath, slotS, item, null);
        }
    }

    public CustomInventory(@NotNull YamlConfiguration config) {
        this(null, config);
    }

    public void setItem(int slot, @NotNull ItemStack item, @NotNull List<String> commands, @Nullable Map<String, String> replaces) {
        if (slot < 0 || slot >= this.rows * 9) {
            throw new IllegalArgumentException("Slot must be between 0 and " + (this.rows * 9 - 1));
        }
        if (replaces != null && !replaces.isEmpty()) {
            NbtUtils.addCustomCommands(item, commands, replaces);
            ItemStackUtils.replaceAll(item, replaces);
        } else {
            NbtUtils.addCustomCommands(item, commands);
        }
        this.items.put(slot, item);
    }

    public void setItem(int slot, @NotNull ItemStack item, @NotNull String command, @Nullable Map<String, String> replaces) {
        this.setItem(slot, item, Collections.singletonList(command), replaces);
    }

    public void setItem(int slot, @NotNull ItemStack item, @NotNull String command) {
        this.setItem(slot, item, Collections.singletonList(command), null);
    }

    public void setItem(int slot, @NotNull ItemStack item, @Nullable Map<String, String> replaces) {
        this.setItem(slot, item, new ArrayList<String>(), replaces);
    }

    public void setItem(int slot, @NotNull ItemStack item) {
        this.setItem(slot, item, new ArrayList<String>(), null);
    }

    public void setItem(@Nullable YamlConfiguration config, @Nullable String materialPath, @NotNull String slot, @NotNull ItemStack item, @Nullable Map<String, String> replaces) {
        block5: {
            block4: {
                if (!slot.matches("\\d+")) break block4;
                this.setItem(Integer.parseInt(slot), item, replaces);
                break block5;
            }
            if (!slot.matches("\\d+-\\d+")) break block5;
            String[] parts = slot.split("-");
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            if (config != null && materialPath != null && config.isList(materialPath)) {
                ArrayList materials = new ArrayList();
                config.getStringList(materialPath).forEach(m -> materials.add(MaterialUtils.getMaterial(m)));
                for (int i = start; i <= end; ++i) {
                    item.setType((Material)materials.get((int)Math.floor(Math.random() * (double)materials.size())));
                    this.setItem(i, item.clone(), replaces);
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    this.setItem(i, item.clone(), replaces);
                }
            }
        }
    }

    public void setItem(@Nullable Player player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable String replace, @Nullable List<String> replacers, boolean addIfEmpty) {
        block10: {
            String slot;
            String materialPath;
            block9: {
                materialPath = ConfigUtils.formPath(path, "material");
                String slotPath = ConfigUtils.formPath(path, "slot");
                slot = config.getString(slotPath);
                assert (slot != null);
                if (!slot.matches("\\d+")) break block9;
                HashMap<String, String> hash = new HashMap<String, String>();
                if (replace != null && replacers != null && !replacers.isEmpty()) {
                    hash.put(replace, replacers.get(0));
                    ItemStack item = ItemStackUtils.getItemFromConfig(player, config, path, hash);
                    this.setItem(Integer.parseInt(slot), item, hash);
                    return;
                }
                if (!addIfEmpty) break block10;
                ItemStack item = ItemStackUtils.getItemFromConfig(player, config, path);
                this.setItem(Integer.parseInt(slot), item, hash);
                break block10;
            }
            if (slot.matches("\\d+-\\d+")) {
                String[] parts = slot.split("-");
                int start = Integer.parseInt(parts[0]);
                int end = Integer.parseInt(parts[1]);
                if (config.isList(materialPath)) {
                    ArrayList materials = new ArrayList();
                    config.getStringList(materialPath).forEach(m -> materials.add(MaterialUtils.getMaterial(m)));
                    for (int i = start; i <= end; ++i) {
                        ItemStack item;
                        HashMap<String, String> hash = new HashMap<String, String>();
                        if (replace != null && replacers != null && !replacers.isEmpty()) {
                            hash.put(replace, replacers.get(0));
                            item = ItemStackUtils.getItemFromConfig(player, config, path, hash);
                            item.setType((Material)materials.get((int)Math.floor(Math.random() * (double)materials.size())));
                            this.setItem(i, item.clone(), hash);
                            replacers.remove(0);
                            continue;
                        }
                        if (!addIfEmpty) continue;
                        item = ItemStackUtils.getItemFromConfig(player, config, path);
                        item.setType((Material)materials.get((int)Math.floor(Math.random() * (double)materials.size())));
                        this.setItem(i, item.clone());
                    }
                } else {
                    for (int i = start; i <= end; ++i) {
                        ItemStack item;
                        HashMap<String, String> hash = new HashMap<String, String>();
                        if (replace != null && replacers != null && !replacers.isEmpty()) {
                            hash.put(replace, replacers.get(0));
                            item = ItemStackUtils.getItemFromConfig(player, config, path, hash);
                            this.setItem(i, item.clone(), hash);
                            replacers.remove(0);
                            continue;
                        }
                        if (!addIfEmpty) continue;
                        item = ItemStackUtils.getItemFromConfig(player, config, path);
                        this.setItem(i, item.clone());
                    }
                }
            }
        }
    }

    public void setItem(@Nullable Player player, @NotNull YamlConfiguration config, @NotNull String path, @Nullable String replace, @Nullable List<String> replacers) {
        this.setItem(player, config, path, replace, replacers, false);
    }

    public void removeItem(int slot) {
        if (slot < 0 || slot >= this.rows * 9) {
            throw new IllegalArgumentException("Slot must be between 0 and " + (this.rows * 9 - 1));
        }
        this.items.remove(slot);
    }

    public void setInventoryName(@Nullable OfflinePlayer player, @NotNull String inventoryName) {
        this.inventoryName = StringUtils.transform(player, inventoryName);
    }

    public void setInventoryName(@NotNull String inventoryName) {
        this.setInventoryName(null, inventoryName);
    }

    @NotNull
    public String getInventoryName() {
        return this.inventoryName;
    }

    public int getRows() {
        return this.rows;
    }

    private ItemStack[] getItemsArray() {
        ItemStack[] itemsArray = new ItemStack[this.rows * 9];
        for (int i = 0; i < itemsArray.length; ++i) {
            ItemStack item = this.items.getOrDefault(i, null);
            itemsArray[i] = item == null ? null : item;
        }
        return itemsArray;
    }

    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)(this.rows * 9), (String)StringUtils.transform(this.inventoryName));
        inv.setContents(this.getItemsArray());
        return inv;
    }
}

