/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.listeners;

import com.zhomes.api.event.player.ExecuteHomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteSethomeCommandEvent;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.folia.FoliaRunnable;
import me.yleoft.zHomes.shaded.zAPI.utils.ActionbarUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.SchedulerUtils;
import me.yleoft.zHomes.utils.HomesUtils;
import me.yleoft.zHomes.utils.LanguageUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListeners
extends HomesUtils
implements Listener {
    private final ConcurrentHashMap<UUID, Long> lastAnnounced = new ConcurrentHashMap();

    public PlayerListeners() {
        FoliaRunnable runnable = new FoliaRunnable(){

            @Override
            public void run() {
                long cutoff = System.currentTimeMillis() - 1800000L;
                PlayerListeners.this.lastAnnounced.entrySet().removeIf(entry -> (Long)entry.getValue() < cutoff);
                for (Map.Entry<UUID, FoliaRunnable> entry2 : HomesUtils.warmups.entrySet()) {
                    UUID uuid = entry2.getKey();
                    FoliaRunnable runnable = entry2.getValue();
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null && player.isOnline()) continue;
                    if (runnable != null) {
                        try {
                            runnable.cancel();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    HomesUtils.warmups.remove(uuid);
                }
            }
        };
        SchedulerUtils.runTaskTimer(null, runnable, 12000L, 12000L);
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (this.lastAnnounced.containsKey(uuid)) {
            long lastTime = this.lastAnnounced.get(uuid);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTime <= 1800000L) {
                return;
            }
        }
        if (Main.needsUpdate && this.doAnnounceUpdate().booleanValue() && (p.isOp() || p.hasPermission(this.CmdMainVersionUpdatePermission()))) {
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            this.lastAnnounced.put(uuid, System.currentTimeMillis());
            SchedulerUtils.runTaskLater(p.getLocation(), () -> {
                cmdm.sendMsg(p, "%prefix%&6You are using an outdated version of zHomes! Please update to the latest version.");
                cmdm.sendMsg(p, "%prefix%&6New version: &a" + Main.getInstance().updateVersion);
                cmdm.sendMsg(p, "%prefix%&6Your version: &c" + Main.getInstance().getDescription().getVersion());
                cmdm.sendMsg(p, "%prefix%&6You can update your plugin here: &e" + Main.getInstance().site);
            }, 60L);
        }
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        FoliaRunnable runnable = HomesUtils.warmups.remove(uuid);
        if (runnable != null) {
            try {
                runnable.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (HomesUtils.warmups.containsKey(uuid) && this.warmupCancelOnMove()) {
            FoliaRunnable runnable;
            LanguageUtils.TeleportWarmupMSG lang = new LanguageUtils.TeleportWarmupMSG();
            Location from = e.getFrom();
            Location to = e.getTo();
            if (to == null) {
                return;
            }
            if ((from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) && (runnable = HomesUtils.warmups.remove(uuid)) != null) {
                runnable.cancel();
                lang.sendMsg(p, lang.getCancelled());
                ActionbarUtils.send(p, LanguageUtils.Helper.getText((CommandSender)p, lang.getCancelledActionbar()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteSethomeCommand(PreExecuteSethomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestrictedSethome());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteHomeCommand(ExecuteHomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p, Main.hu.getHomeLoc((OfflinePlayer)p, e.getHome()).getWorld())) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestrictedHome());
        }
    }
}

