/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.utils;

import com.zhomes.api.event.player.TeleportToHomeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.folia.FoliaRunnable;
import me.yleoft.zHomes.shaded.zAPI.utils.ActionbarUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.LocationUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.SchedulerUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.utils.LanguageUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class HomesUtils
extends DatabaseEditor {
    Main main = Main.getInstance();
    public static final HashMap<UUID, FoliaRunnable> warmups = new HashMap();

    public boolean hasHome(OfflinePlayer p, String home) {
        return this.isInTable(p, home);
    }

    public boolean inSameWorld(String w, Player p) {
        String w2 = p.getWorld().getName();
        return !w.equals(w2);
    }

    public boolean inMaxLimit(Player p) {
        if (this.needsLimit() && !p.hasPermission(this.PermissionBypassLimit())) {
            return this.getLimit((OfflinePlayer)p) >= this.getMaxLimit((OfflinePlayer)p);
        }
        return false;
    }

    public boolean isAllowedInWorld(Player p) {
        if (!this.useRestrictedWorlds() || p.hasPermission(this.PermissionBypassRestrictedWorlds())) {
            return true;
        }
        World world = p.getWorld();
        List<String> restrictedWorlds = this.restrictedWorldsList();
        String mode = this.restrictedWorldsMode();
        if (mode.equalsIgnoreCase("blacklist")) {
            return !restrictedWorlds.contains(world.getName());
        }
        return restrictedWorlds.contains(world.getName());
    }

    public int getLimit(OfflinePlayer p) {
        return this.getHomes(p).size();
    }

    public void addHome(OfflinePlayer p, String home, Location loc) {
        this.setHome(p, home, LocationUtils.serialize(loc));
    }

    public void delHome(OfflinePlayer p, String home) {
        this.deleteHome(p, home);
    }

    public void renameHome(OfflinePlayer p, String home, String newName) {
        if (this.hasHome(p, home) && !this.hasHome(p, newName)) {
            String locS = this.getHome(p, home);
            this.deleteHome(p, home);
            this.setHome(p, newName, locS);
        }
    }

    public boolean canDimensionalTeleport(OfflinePlayer p) {
        Player pl;
        if (p.isOnline() && (pl = (Player)p).hasPermission(this.PermissionBypassDT())) {
            return true;
        }
        return this.canDimensionalTeleport();
    }

    public void teleportPlayer(final Player p, final OfflinePlayer t, final String home) {
        final Location loc = this.getHomeLoc(t, home);
        boolean isDimensionalTeleport = this.inSameWorld(this.getHomeWorld(t, home), p);
        TeleportToHomeEvent event = new TeleportToHomeEvent(p, home, p.getLocation(), loc, isDimensionalTeleport, p.getUniqueId() == t.getUniqueId(), t);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        final LanguageUtils.Home lang = new LanguageUtils.Home();
        if (isDimensionalTeleport && !this.canDimensionalTeleport((OfflinePlayer)p)) {
            lang.sendMsg(p, lang.getCantDimensionalTeleport());
            return;
        }
        SchedulerUtils.runTask(loc, (Runnable)((Object)new FoliaRunnable(){

            @Override
            public void run() {
                Location tpLoc;
                Location location = tpLoc = HomesUtils.this.enableSafeTeleport() && !p.hasPermission(HomesUtils.this.PermissionBypassST()) ? LocationUtils.findNearestSafeLocation(loc, 4, 50) : loc;
                if (tpLoc == null) {
                    LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
                    cmdm.sendMsg(p, cmdm.getUnableToFindSafeLocation());
                    return;
                }
                String homeString = p.getUniqueId() == t.getUniqueId() ? home : t.getName() + ":" + home;
                Runnable task = () -> {
                    Sound sound = HomesUtils.getTeleportSound();
                    if (zAPI.isFolia()) {
                        try {
                            Method teleportAsyncMethod = Player.class.getMethod("teleportAsync", Location.class);
                            teleportAsyncMethod.invoke((Object)p, tpLoc);
                            SchedulerUtils.runTask(tpLoc, () -> {
                                if (sound != null && HomesUtils.this.playSound()) {
                                    p.playSound(p.getLocation(), sound, 1.0f, 1.0f);
                                }
                            });
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new RuntimeException("Unable to teleport player to home", e);
                        }
                    } else {
                        SchedulerUtils.runTaskLater(tpLoc, () -> {
                            p.teleport(tpLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                            SchedulerUtils.runTask(tpLoc, () -> {
                                if (sound != null && HomesUtils.this.playSound()) {
                                    p.playSound(p.getLocation(), sound, 1.0f, 1.0f);
                                }
                            });
                        }, 1L);
                    }
                    lang.sendMsg(p, lang.getOutput(homeString));
                };
                if (HomesUtils.this.doWarmup() && !p.hasPermission(HomesUtils.this.PermissionBypassWarmup()) && HomesUtils.this.warmupTime() > 0) {
                    LanguageUtils.TeleportWarmupMSG langWarmup = new LanguageUtils.TeleportWarmupMSG();
                    lang.sendMsg(p, langWarmup.getWarmup(HomesUtils.this.warmupTime()));
                    HomesUtils.this.startWarmup(p, langWarmup, lang, homeString, task);
                    return;
                }
                task.run();
            }
        }));
    }

    public void teleportPlayer(Player p, String home) {
        this.teleportPlayer(p, (OfflinePlayer)p, home);
    }

    public void startWarmup(final Player p, final LanguageUtils.TeleportWarmupMSG lang, final LanguageUtils.Home lang2, final String home, final Runnable task) {
        final UUID uuid = p.getUniqueId();
        if (warmups.containsKey(uuid)) {
            warmups.get(uuid).cancel();
        }
        FoliaRunnable runnable = new FoliaRunnable(){
            int counter;
            {
                this.counter = HomesUtils.this.warmupTime();
            }

            @Override
            public void run() {
                if (!p.isOnline()) {
                    this.cancel();
                    warmups.remove(uuid);
                    return;
                }
                if (this.counter >= 1) {
                    if (HomesUtils.this.warmupShowOnActionbar()) {
                        ActionbarUtils.send(p, LanguageUtils.Helper.getText((CommandSender)p, lang.getWarmupActionbar(this.counter)));
                    }
                    --this.counter;
                } else {
                    if (HomesUtils.this.warmupShowOnActionbar()) {
                        ActionbarUtils.send(p, LanguageUtils.Helper.getText((CommandSender)p, lang2.getOutput(home)));
                    }
                    task.run();
                    warmups.remove(uuid);
                    this.cancel();
                }
            }
        };
        warmups.put(uuid, runnable);
        SchedulerUtils.runTaskTimer(p.getLocation(), runnable, 1L, 20L);
    }

    public static Sound getTeleportSound() {
        try {
            return Sound.valueOf((String)"ENTITY_ENDERMAN_TELEPORT");
        }
        catch (Throwable ignored1) {
            try {
                return Sound.valueOf((String)"ENDERMAN_TELEPORT");
            }
            catch (Throwable ignored2) {
                return null;
            }
        }
    }

    public String homes(OfflinePlayer p) {
        StringBuilder returned = new StringBuilder();
        try {
            List<String> homes = this.getHomes(p);
            if (!homes.isEmpty()) {
                for (String home : homes) {
                    if (returned.length() == 0) {
                        returned = new StringBuilder(home);
                        continue;
                    }
                    returned.append(", ").append(home);
                }
            } else {
                returned = new StringBuilder("None");
            }
        }
        catch (Exception e) {
            returned = new StringBuilder("None");
        }
        return returned.toString();
    }

    public List<String> homesW(OfflinePlayer p) {
        return this.getHomes(p);
    }

    public List<String> homesWDD(OfflinePlayer p) {
        ArrayList<String> list = new ArrayList<String>();
        this.getHomes(p).forEach(home -> list.add(p.getName() + ":" + home));
        return list;
    }

    public int numberOfHomes(OfflinePlayer p) {
        return this.getHomes(p).size();
    }

    public Location getHomeLoc(OfflinePlayer p, String home) {
        String locS = this.getHome(p, home);
        return LocationUtils.deserialize(locS);
    }

    public String getHomeWorld(OfflinePlayer p, String home) {
        String locS = this.getHome(p, home);
        String[] locP = locS.split(";");
        try {
            return locP[0];
        }
        catch (Exception exception) {
            return null;
        }
    }
}

