/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.utils.ActionbarUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.LocationUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.PlayerUtils;
import me.yleoft.zHomes.storage.DatabaseConnection;
import me.yleoft.zHomes.storage.database_type;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class DatabaseEditor
extends DatabaseConnection {
    public void createTable(String table, String coluns) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + table + coluns);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error creating table: " + table, e);
        }
    }

    public void setHome(OfflinePlayer p, String home, String location) {
        block26: {
            database_type type = Main.type;
            try (Connection con = this.getConnection();){
                if (this.isInTable(p, home)) {
                    try (PreparedStatement ps = con.prepareStatement("UPDATE " + this.databaseTable() + " SET LOCATION=? WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
                        String uuid = p.getUniqueId().toString();
                        ps.setString(1, location);
                        ps.setString(2, uuid);
                        ps.setString(3, home);
                        ps.executeUpdate();
                        break block26;
                    }
                }
                String query = "INSERT OR IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                switch (type) {
                    case SQLITE: {
                        query = "INSERT OR IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                        break;
                    }
                    case H2: {
                        query = "MERGE INTO " + this.databaseTable() + " KEY(UUID, HOME) VALUES (?, ?, ?)";
                        break;
                    }
                    case EXTERNAL: {
                        query = "INSERT IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                    }
                }
                try (PreparedStatement ps = con.prepareStatement(query);){
                    String uuid = p.getUniqueId().toString();
                    ps.setString(1, uuid);
                    ps.setString(2, home);
                    ps.setString(3, location);
                    ps.executeUpdate();
                }
            }
            catch (SQLException e) {
                Main.getInstance().getLogger().log(Level.SEVERE, "Error setting home for player: " + p.getName(), e);
            }
        }
    }

    public void deleteHome(OfflinePlayer p, String home) {
        try (Connection con = this.getConnection();
             PreparedStatement ps2 = con.prepareStatement("DELETE FROM " + this.databaseTable() + " WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
            String uuid = p.getUniqueId().toString();
            ps2.setString(1, uuid);
            ps2.setString(2, home);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error deleting home for player: " + p.getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHome(OfflinePlayer p, String home) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT LOCATION from " + this.databaseTable() + " WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
            String uuid = p.getUniqueId().toString();
            ps.setString(1, uuid);
            ps.setString(2, home);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return "";
                String returned = rs.getString("LOCATION");
                rs.close();
                ps.close();
                String string = returned;
                return string;
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting homes for player: " + p.getName(), e);
        }
        return "";
    }

    public List<String> getHomes(OfflinePlayer p) {
        ArrayList<String> list = new ArrayList<String>();
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.databaseTable() + " WHERE UUID=?");){
            ps.setString(1, p.getUniqueId().toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString("HOME"));
                }
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting homes for player: " + p.getName(), e);
        }
        return list;
    }

    public HashMap<OfflinePlayer, List<String>> getNearHomes(Location loc, double radius) {
        HashMap<OfflinePlayer, List<String>> result = new HashMap<OfflinePlayer, List<String>>();
        if (loc == null || loc.getWorld() == null) {
            return result;
        }
        double radiusSq = radius * radius;
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT UUID, HOME, LOCATION FROM " + this.databaseTable());
             ResultSet rs = ps.executeQuery();){
            World world = loc.getWorld();
            while (rs.next()) {
                String uuid = rs.getString("UUID");
                String home = rs.getString("HOME");
                String locStr = rs.getString("LOCATION");
                Location homeLoc = LocationUtils.deserialize(locStr);
                if (!Objects.equals(homeLoc.getWorld(), world) || !(homeLoc.distanceSquared(loc) <= radiusSq)) continue;
                OfflinePlayer owner = PlayerUtils.getOfflinePlayer(UUID.fromString(uuid));
                result.computeIfAbsent(owner, k -> new ArrayList()).add(home);
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting near homes", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public long getTotalHomes() {
        long count = 0L;
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(*) AS total FROM " + this.databaseTable());
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                count = rs.getLong("total");
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting total homes", e);
        }
        return count;
    }

    public long getTotalUsers() {
        long count = 0L;
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(DISTINCT UUID) AS total FROM " + this.databaseTable());
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                count = rs.getLong("total");
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting total users", e);
        }
        return count;
    }

    public boolean isInTable(OfflinePlayer p, String home) {
        try {
            String uuid = p.getUniqueId().toString();
            if (this.existsTableColumnValueDoubleLower(this.databaseTable(), "UUID", uuid, "HOME", home)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public File exportDatabase(Player p) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Sound getEntityLevelUP() {
        try {
            return Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP");
        }
        catch (Throwable ignored1) {
            try {
                return Sound.valueOf((String)"LEVEL_UP");
            }
            catch (Throwable ignored2) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int importDatabase(File gzJsonFile, Player p) {
        String insertQuery;
        List entries;
        if (gzJsonFile == null || !gzJsonFile.exists()) {
            Main.getInstance().getLogger().severe("Import file does not exist: " + (gzJsonFile == null ? "null" : gzJsonFile.getAbsolutePath()));
            return -1;
        }
        try (GZIPInputStream gis = new GZIPInputStream(Files.newInputStream(gzJsonFile.toPath(), new OpenOption[0]));
             InputStreamReader reader = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            entries = (List)gson.fromJson((Reader)reader, new TypeToken<List<ExportEntry>>(){}.getType());
            if (entries == null) {
                entries = Collections.emptyList();
            }
        }
        catch (Exception e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error reading import file: " + gzJsonFile.getAbsolutePath(), e);
            if (p != null) {
                p.sendMessage("\u00a7cFailed to read import file: " + e.getMessage());
            }
            return -1;
        }
        if (entries.isEmpty()) {
            Main.getInstance().getLogger().info("Import file contained no entries: " + gzJsonFile.getAbsolutePath());
            if (p != null) {
                p.sendMessage("\u00a7eImport file contained no entries.");
            }
            return 0;
        }
        database_type type = Main.type;
        switch (type) {
            case H2: {
                insertQuery = "MERGE INTO " + this.databaseTable() + " KEY(UUID, HOME) VALUES (?, ?, ?)";
                break;
            }
            case SQLITE: {
                insertQuery = "INSERT OR REPLACE INTO " + this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?)";
                break;
            }
            default: {
                insertQuery = "INSERT INTO " + this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)";
            }
        }
        int imported = 0;
        int BATCH_SIZE = 500;
        try (Connection con = this.getConnection();){
            int n;
            block42: {
                PreparedStatement pstmt = con.prepareStatement(insertQuery);
                try {
                    con.setAutoCommit(false);
                    int batchCount = 0;
                    for (int i = 0; i < entries.size(); ++i) {
                        ExportEntry e = (ExportEntry)entries.get(i);
                        pstmt.setString(1, e.uuid);
                        pstmt.setString(2, e.home);
                        pstmt.setString(3, e.location);
                        pstmt.addBatch();
                        if (++batchCount < 500) continue;
                        pstmt.executeBatch();
                        con.commit();
                        pstmt.clearBatch();
                        imported += batchCount;
                        batchCount = 0;
                        this.updateImportProgressToPlayer(p, imported, entries.size());
                    }
                    if (batchCount > 0) {
                        pstmt.executeBatch();
                        con.commit();
                        imported += batchCount;
                    }
                    con.setAutoCommit(true);
                    if (p != null) {
                        String message = "Import complete! " + imported + " records imported.";
                        ActionbarUtils.send(p, message);
                        try {
                            p.playSound(p.getLocation(), Objects.requireNonNull(DatabaseEditor.getEntityLevelUP()), 100.0f, 1.0f);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Main.getInstance().getLogger().info("Imported " + imported + " records from " + gzJsonFile.getAbsolutePath());
                    n = imported;
                    if (pstmt == null) break block42;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error importing database from " + gzJsonFile.getAbsolutePath(), e);
            if (p != null) {
                p.sendMessage("\u00a7cFailed to import database: " + e.getMessage());
            }
            return -1;
        }
    }

    private void updateImportProgressToPlayer(Player p, int count, int total) {
        if (p != null) {
            String message = "\u00a7aImporting data... \u00a78[\u00a77" + count + " / " + total + "\u00a78]";
            ActionbarUtils.send(p, message);
        }
    }

    private static class ExportEntry {
        String uuid;
        String home;
        String location;

        ExportEntry() {
        }

        ExportEntry(String uuid, String home, String location) {
            this.uuid = uuid;
            this.home = home;
            this.location = location;
        }
    }
}

