/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.Objects;
import me.yleoft.zHomes.shaded.zAPI.utils.ItemStackUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public abstract class MaterialUtils {
    @NotNull
    public static Material getMaterial(@NotNull String materialString) {
        if (StringUtils.startsWithIgnoreCase(materialString, "[head]")) {
            return Material.PLAYER_HEAD;
        }
        if (MaterialUtils.isLegacyMaterial(materialString)) {
            if (ItemStackUtils.LEGACY_COLORS.keySet().stream().anyMatch(materialString::startsWith)) {
                return MaterialUtils.getLegacyMaterial(ItemStackUtils.LEGACY_COLORS.keySet().stream().filter(materialString::startsWith).findFirst().map(prefix -> materialString.substring(prefix.length() + 1)).orElse(materialString));
            }
        }
        return Objects.requireNonNull(Material.getMaterial((String)materialString));
    }

    @NotNull
    public static Material getLegacyMaterial(@NotNull String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return Material.STONE;
        }
    }

    public static boolean isLegacyMaterial(@NotNull String name) {
        try {
            Material.valueOf((String)name);
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    @NotNull
    public static Material findMaterial(String ... names) {
        for (String name : names) {
            try {
                return Material.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.COBBLESTONE;
    }
}

