/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import me.yleoft.zHomes.shaded.zAPI.managers.LogManager;
import me.yleoft.zHomes.shaded.zAPI.zAPI;

public class LogUtils {
    private final File logFile;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public LogUtils(File folder, String name) {
        if (!folder.exists() && !folder.mkdirs()) {
            zAPI.getPlugin().getLogger().severe("Failed to create folder: " + folder.getAbsolutePath());
        }
        this.logFile = new File(folder, name + ".log");
        if (!this.logFile.exists()) {
            try {
                if (!this.logFile.createNewFile()) {
                    zAPI.getPlugin().getLogger().severe("Failed to create log file: " + this.logFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create log file: " + this.logFile.getAbsolutePath(), e);
            }
        }
    }

    public void log(String message) {
        String timestamp = this.dateFormat.format(new Date());
        String formattedMessage = "[" + timestamp + "] " + message;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFile, true));){
            writer.write(formattedMessage);
            writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public static File compressLogs() {
        File folder = LogManager.getLogFolder();
        List<LogUtils> logs = LogManager.getFiles();
        if (logs.isEmpty()) {
            return null;
        }
        if (!folder.exists() && !folder.mkdirs()) {
            zAPI.getPlugin().getLogger().severe("Failed to create folder: " + folder.getAbsolutePath());
        }
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm").format(new Date());
        File compressedFile = new File(folder, timestamp + ".zip");
        try (FileOutputStream fos = new FileOutputStream(compressedFile);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
            for (LogUtils log : logs) {
                File file = log.getLogFile();
                if (!file.exists()) continue;
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    int len;
                    ZipEntry entry = new ZipEntry(file.getName());
                    zos.putNextEntry(entry);
                    byte[] buffer = new byte[4096];
                    while ((len = bis.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
                if (file.delete()) continue;
                zAPI.getPlugin().getLogger().warning("Could not delete log file: " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to compress logs", e);
        }
        return compressedFile;
    }
}

