/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.listeners;

import com.zhomes.api.event.player.ExecuteHomesCommandEvent;
import com.zhomes.api.event.player.PreExecuteDelhomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteHomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteSethomeCommandEvent;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.utils.ActionbarUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.SchedulerUtils;
import me.yleoft.zHomes.utils.HomesUtils;
import me.yleoft.zHomes.utils.LanguageUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerListeners
extends HomesUtils
implements Listener {
    private final ConcurrentHashMap<UUID, Long> lastAnnounced = new ConcurrentHashMap();

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (this.lastAnnounced.containsKey(uuid)) {
            long lastTime = this.lastAnnounced.get(uuid);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTime <= 1800000L) {
                return;
            }
        }
        if (Main.needsUpdate && this.doAnnounceUpdate().booleanValue() && (p.isOp() || p.hasPermission(this.CmdMainVersionUpdatePermission()))) {
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            this.lastAnnounced.put(uuid, System.currentTimeMillis());
            SchedulerUtils.runTaskLater(p.getLocation(), () -> {
                cmdm.sendMsg(p, "%prefix%&6You are using an outdated version of zHomes! Please update to the latest version.");
                cmdm.sendMsg(p, "%prefix%&6New version: &a" + Main.getInstance().updateVersion);
                cmdm.sendMsg(p, "%prefix%&6Your version: &c" + Main.getInstance().getDescription().getVersion());
                cmdm.sendMsg(p, "%prefix%&6You can update your plugin here: &e" + Main.getInstance().site);
            }, 60L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (HomesUtils.warmups.containsKey(uuid) && this.warmupCancelOnMove()) {
            BukkitRunnable runnable;
            LanguageUtils.TeleportWarmupMSG lang = new LanguageUtils.TeleportWarmupMSG();
            Location from = e.getFrom();
            Location to = e.getTo();
            if (to == null) {
                return;
            }
            if ((from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) && (runnable = (BukkitRunnable)HomesUtils.warmups.remove(uuid)) != null) {
                runnable.cancel();
                lang.sendMsg(p, lang.getCancelled());
                ActionbarUtils.send(p, LanguageUtils.Helper.getText((CommandSender)p, lang.getCancelledActionbar()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteSethomeCommand(PreExecuteSethomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestricted());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteDelhomeCommand(PreExecuteDelhomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestricted());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteHomeCommand(PreExecuteHomeCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestricted());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerExecuteHomesCommand(ExecuteHomesCommandEvent e) {
        Player p = e.getPlayer();
        if (!this.isAllowedInWorld(p)) {
            e.setCancelled(true);
            LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
            cmdm.sendMsg(p, cmdm.getWorldRestricted());
        }
    }
}

