/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes;

import com.sk89q.worldguard.protection.flags.StateFlag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.yleoft.zHomes.commands.DelhomeCommand;
import me.yleoft.zHomes.commands.HomeCommand;
import me.yleoft.zHomes.commands.HomesCommand;
import me.yleoft.zHomes.commands.MainCommand;
import me.yleoft.zHomes.commands.SethomeCommand;
import me.yleoft.zHomes.hooks.PlaceholderAPIHandler;
import me.yleoft.zHomes.hooks.WorldGuardHook;
import me.yleoft.zHomes.listeners.GriefPreventionListeners;
import me.yleoft.zHomes.listeners.PlayerListeners;
import me.yleoft.zHomes.listeners.WorldGuardListeners;
import me.yleoft.zHomes.shaded.hikari.HikariDataSource;
import me.yleoft.zHomes.shaded.nbtapi.NBT;
import me.yleoft.zHomes.shaded.zAPI.Metrics;
import me.yleoft.zHomes.shaded.zAPI.managers.FileManager;
import me.yleoft.zHomes.shaded.zAPI.managers.PluginYAMLManager;
import me.yleoft.zHomes.shaded.zAPI.managers.UpdateManager;
import me.yleoft.zHomes.shaded.zAPI.utils.FileUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import me.yleoft.zHomes.storage.DatabaseConnection;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.storage.database_type;
import me.yleoft.zHomes.tabcompleters.DelhomeCompleter;
import me.yleoft.zHomes.tabcompleters.HomeCompleter;
import me.yleoft.zHomes.tabcompleters.HomesCompleter;
import me.yleoft.zHomes.tabcompleters.MainCompleter;
import me.yleoft.zHomes.utils.ConfigUtils;
import me.yleoft.zHomes.utils.HomesUtils;
import me.yleoft.zHomes.utils.LanguageUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Main
extends JavaPlugin {
    public static FileUtils configFileUtils;
    public static final String homesMenuPath = "menus/menu-homes.yml";
    public static final String smallerHomesMenuExamplePath = "menus/small-homes-menu-example.yml";
    public static StateFlag useHomesFlag;
    public static StateFlag setHomesFlag;
    public static boolean useGriefPrevention;
    public static boolean usePlaceholderAPI;
    public static boolean useWorldGuard;
    public static boolean isWG7;
    public static boolean useVault;
    private static Main main;
    public static ConfigUtils cfgu;
    public static HomesUtils hu;
    public static DatabaseConnection db;
    public static DatabaseEditor dbe;
    public static HikariDataSource dataSource;
    public static database_type type;
    public static Driver mysqlDriver;
    public static Driver mariadbDriver;
    public static Driver h2Driver;
    public static Object papi;
    public static Object economy;
    public static UpdateManager checker;
    public static boolean needsUpdate;
    public String updateVersion = this.getDescription().getVersion();
    public final String pluginName;
    public String coloredPluginName = this.pluginName = this.getDescription().getName();
    public final String pluginVer = this.getDescription().getVersion();
    public final String site = "https://modrinth.com/plugin/zhomes/version/latest";
    public static final int bStatsId = 25021;
    public final File libsFolder = new File(this.getDataFolder(), "libs");
    public final String mysqlVersion = "8.0.23";
    public final String mysqlJar = "mysql-connector-java-8.0.23.jar";
    public final String mysqlRepo = "https://repo1.maven.org/maven2/mysql/mysql-connector-java/8.0.23/mysql-connector-java-8.0.23.jar";
    public final String mariadbVersion = "3.5.3";
    public final String mariadbJar = "mariadb-java-client-3.5.3.jar";
    public final String mariadbRepo = "https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.5.3/mariadb-java-client-3.5.3.jar";
    public final String h2Version = "2.3.232";
    public final String h2Jar = "h2-2.3.232.jar";
    public final String h2Repo = "https://repo1.maven.org/maven2/com/h2database/h2/2.3.232/h2-2.3.232.jar";

    public static Main getInstance() {
        return main;
    }

    public void onLoad() {
        block7: {
            try {
                Plugin wg = this.getServer().getPluginManager().getPlugin("WorldGuard");
                if (wg != null) {
                    useWorldGuard = true;
                    try {
                        Class.forName("com.sk89q.worldguard.WorldGuard");
                        isWG7 = true;
                    }
                    catch (ClassNotFoundException ignored) {
                        isWG7 = false;
                        this.getLogger().warning("Legacy WorldGuard version found, some features may not work as expected.");
                    }
                    try {
                        WorldGuardHook.setupFlags();
                    }
                    catch (Exception e) {
                        this.getLogger().severe("Failed to setup custom flags with WorldGuard.");
                        e.printStackTrace();
                    }
                    break block7;
                }
                this.getLogger().warning("WorldGuard not found, continuing without it.");
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error hooking into WorldGuard", e);
            }
        }
    }

    public void onEnable() {
        zAPI.init(this, this.pluginName, this.coloredPluginName, NBT.preloadApi());
        main = this;
        this.coloredPluginName = this.pluginName;
        cfgu = new ConfigUtils();
        hu = new HomesUtils();
        db = new DatabaseConnection();
        dbe = new DatabaseEditor();
        LanguageUtils.Helper helper = new LanguageUtils.Helper(){};
        this.coloredPluginName = StringUtils.transform(Objects.requireNonNull(this.getConfig().getString("prefix")));
        zAPI.setColoredPluginName(this.coloredPluginName);
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7f------------------------------------------------------");
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7fPlugin started loading...");
        this.updatePlugin();
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "&fChecking if files exist...")));
        if (configFileUtils == null) {
            this.getConfig();
        }
        ArrayList<FileUtils> fus = new ArrayList<FileUtils>();
        fus.add(FileManager.createFile("languages/de.yml"));
        fus.add(FileManager.createFile("languages/en.yml"));
        fus.add(FileManager.createFile("languages/es.yml"));
        fus.add(FileManager.createFile("languages/fr.yml"));
        fus.add(FileManager.createFile("languages/it.yml"));
        fus.add(FileManager.createFile("languages/nl.yml"));
        fus.add(FileManager.createFile("languages/pl.yml"));
        fus.add(FileManager.createFile("languages/pt-br.yml"));
        fus.add(FileManager.createFile("languages/ru.yml"));
        fus.add(FileManager.createFile("languages/zhcn.yml"));
        for (FileUtils fileUtils : fus) {
            fileUtils.saveDefaultConfig();
            fileUtils.reloadConfig();
        }
        ArrayList<FileUtils> menusFus = new ArrayList<FileUtils>();
        menusFus.add(FileManager.createFile(homesMenuPath));
        menusFus.add(FileManager.createFile(smallerHomesMenuExamplePath));
        for (FileUtils fu : menusFus) {
            if (!fu.getFile().exists()) {
                fu.saveDefaultConfig();
                fu.reloadConfig(true);
                continue;
            }
            fu.saveDefaultConfig();
            fu.reloadConfig(false);
        }
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "&fAll files have been created!")));
        if (!this.libsFolder.exists()) {
            try {
                Files.createDirectories(Paths.get(this.libsFolder.toURI()), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            File file = new File(this.libsFolder, "h2-2.3.232.jar");
            if (!file.exists()) {
                Main.downloadFile("https://repo1.maven.org/maven2/com/h2database/h2/2.3.232/h2-2.3.232.jar", file);
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aLibrary \u00a79H2Database \u00a7asaved to " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to download H2Database library", exception);
        }
        try {
            File file = new File(this.libsFolder, "mysql-connector-java-8.0.23.jar");
            if (!file.exists()) {
                Main.downloadFile("https://repo1.maven.org/maven2/mysql/mysql-connector-java/8.0.23/mysql-connector-java-8.0.23.jar", file);
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aLibrary \u00a79MySQL Connector Java \u00a7asaved to " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to download MySQL Connector Java library", exception);
        }
        try {
            File file = new File(this.libsFolder, "mariadb-java-client-3.5.3.jar");
            if (!file.exists()) {
                Main.downloadFile("https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.5.3/mariadb-java-client-3.5.3.jar", file);
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aLibrary \u00a79MariaDB Java Client \u00a7asaved to " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to download MariaDB library", exception);
        }
        db.connect();
        dbe.createTable(db.databaseTable(), "(UUID VARCHAR(36),HOME VARCHAR(100),LOCATION VARCHAR(255),PRIMARY KEY (UUID, HOME))");
        if (cfgu.hasMetrics().booleanValue()) {
            Metrics metrics = zAPI.startMetrics(25021);
            metrics.addCustomChart(new Metrics.DrilldownPie("player_count", () -> {
                int players = Bukkit.getOnlinePlayers().size();
                return this.buildDistribution(players);
            }));
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "&aMetrics enabled.")));
        }
        LanguageUtils.loadzAPIMessages();
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7fTrying to connect to hooks...");
        try {
            zAPI.setPlaceholderAPIHandler(new PlaceholderAPIHandler());
            if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                usePlaceholderAPI = true;
                zAPI.registerPlaceholderExpansion(this.getDescription().getAuthors().toString(), this.pluginVer, true, true);
                papi = zAPI.getPlaceholderExpansion();
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aPlaceholderAPI hooked successfully!");
            } else {
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7cPlaceholderAPI plugin not found! Disabling hook...");
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Error hooking into PlaceholderAPI", exception);
        }
        try {
            if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
                useVault = true;
                this.setupEconomy();
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aConnected to Vault successfully!");
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Error hooking into VaultAPI", exception);
        }
        try {
            if (this.getServer().getPluginManager().isPluginEnabled("GriefPrevention")) {
                useGriefPrevention = true;
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7aConnected to GriefPrevention successfully!");
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Error hooking into GriefPrevention", exception);
        }
        this.loadCommands();
        this.registerEvents();
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7fPlugin started (Any errors will be above this message)");
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7f------------------------------------------------------");
    }

    public void onDisable() {
        if (!zAPI.isFolia()) {
            Bukkit.getScheduler().cancelTasks((Plugin)this);
        }
        PluginYAMLManager.unregisterPermissions();
        HandlerList.unregisterAll((Plugin)this);
        if (db != null) {
            db.closePool();
            this.getLogger().info("Database connection closed.");
        }
        if (papi != null) {
            zAPI.unregisterPlaceholderExpansion();
        }
        main = null;
    }

    public void updatePlugin() {
        LanguageUtils.Helper helper = new LanguageUtils.Helper(){};
        checker = new UpdateManager(this, "https://api.github.com/repos/yL3oft/zHomes/tags", "zhomes");
        String version = checker.getVersion();
        String pf = "&8&l|> &r";
        if (!this.getDescription().getVersion().equals(version)) {
            needsUpdate = true;
            this.updateVersion = version;
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "&cPlugin is out-dated!")));
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&fNew version: &e" + version)));
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&fYour version: &e" + this.getDescription().getVersion())));
            if (cfgu.isAutoUpdate().booleanValue()) {
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&fAttempting to auto-update it...")));
                try {
                    String path = checker.update();
                    helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&aPlugin updated! &7Saved in: " + path)));
                    helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&aRestart the server to apply changes.")));
                }
                catch (Exception e) {
                    helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&cCould not auto-update it.")));
                    helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&fYou can update your plugin here: &e" + "https://modrinth.com/plugin/zhomes/version/latest")));
                }
            } else {
                helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(pf + "&fYou can update your plugin here: &e" + "https://modrinth.com/plugin/zhomes/version/latest")));
            }
        } else {
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "&aPlugin is up-to-date!")));
        }
    }

    public void loadCommands() {
        LanguageUtils.CommandsMSG helper = new LanguageUtils.CommandsMSG();
        helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.coloredPluginName + "\u00a7fTrying to load commands, permissions & events...")));
        try {
            PluginYAMLManager.unregisterCommands();
            PluginYAMLManager.registerCommand(cfgu.CmdMainCommand(), (CommandExecutor)new MainCommand(), cfgu.CmdMainCooldown(), new MainCompleter(), cfgu.CmdMainDescription(), cfgu.CmdMainAliases().toArray(new String[0]));
            PluginYAMLManager.registerCommand(cfgu.CmdSethomeCommand(), (CommandExecutor)new SethomeCommand(), cfgu.CmdSethomeCooldown(), cfgu.CmdSethomeDescription(), cfgu.CmdSethomeAliases().toArray(new String[0]));
            PluginYAMLManager.registerCommand(cfgu.CmdDelhomeCommand(), (CommandExecutor)new DelhomeCommand(), cfgu.CmdDelhomeCooldown(), new DelhomeCompleter(), cfgu.CmdDelhomeDescription(), cfgu.CmdDelhomeAliases().toArray(new String[0]));
            PluginYAMLManager.registerCommand(cfgu.CmdHomesCommand(), (CommandExecutor)new HomesCommand(), cfgu.CmdHomesCooldown(), new HomesCompleter(), cfgu.CmdHomesDescription(), cfgu.CmdHomesAliases().toArray(new String[0]));
            PluginYAMLManager.registerCommand(cfgu.CmdHomeCommand(), (CommandExecutor)new HomeCommand(), cfgu.CmdHomeCooldown(), new HomeCompleter(), cfgu.CmdHomeDescription(), cfgu.CmdHomeAliases().toArray(new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load commands", e);
        }
        try {
            PluginYAMLManager.unregisterPermissions();
            HashMap<String, Boolean> helpANDmainChildren = new HashMap<String, Boolean>();
            helpANDmainChildren.put(cfgu.CmdMainPermission(), true);
            helpANDmainChildren.put(cfgu.CmdMainHelpPermission(), true);
            PluginYAMLManager.registerPermission(cfgu.CmdMainPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + "' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdMainHelpPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " (help|?)' command (With perm)", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdMainVersionPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " (version|ver)' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdMainVersionUpdatePermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " (version|ver) update' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdMainInfoPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " info' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdMainReloadPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " (reload|rl)' command", PermissionDefault.OP, helpANDmainChildren);
            PluginYAMLManager.registerPermission(cfgu.CmdMainNearhomesPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " nearhomes' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdMainConverterPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " converter' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdMainImportexportPermission(), "Permission to use the '/" + cfgu.CmdMainCommand() + " (export|import)' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdSethomePermission(), "Permission to use the '/" + cfgu.CmdSethomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdDelhomePermission(), "Permission to use the '/" + cfgu.CmdDelhomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdDelhomeOthersPermission(), "Permission to use the '/" + cfgu.CmdDelhomeCommand() + " (Player:Home)' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdHomesPermission(), "Permission to use the '/" + cfgu.CmdHomesCommand() + "' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdHomesOthersPermission(), "Permission to use the '/" + cfgu.CmdHomesCommand() + " (Player)' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.CmdHomePermission(), "Permission to use the '/" + cfgu.CmdHomeCommand() + "' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdHomeRenamePermission(), "Permission to use the '/" + cfgu.CmdHomeCommand() + " rename (Home) (NewName)' command", PermissionDefault.TRUE);
            PluginYAMLManager.registerPermission(cfgu.CmdHomeOthersPermission(), "Permission to use the '/" + cfgu.CmdHomeCommand() + " (Player:Home)' command", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.PermissionBypassLimit(), "Bypass homes limit", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.PermissionBypassST(), "Bypass safe teleport", PermissionDefault.FALSE);
            PluginYAMLManager.registerPermission(cfgu.PermissionBypassDT(), "Bypass dimensional teleportation config", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.PermissionBypassRestrictedWorlds(), "Bypass restricted worlds", PermissionDefault.OP);
            PluginYAMLManager.registerPermission(cfgu.PermissionBypassWarmup(), "Bypass teleportation warmup time", PermissionDefault.OP);
        }
        catch (Exception e) {
            helper.sendMsg((CommandSender)this.getServer().getConsoleSender(), this.coloredPluginName + "\u00a7cError registering permissions (This doesn't affect anything in general)!");
        }
    }

    public void registerEvents() {
        PluginYAMLManager.registerEvent(new PlayerListeners());
        if (useWorldGuard) {
            PluginYAMLManager.registerEvent(new WorldGuardListeners());
        }
        if (useGriefPrevention) {
            PluginYAMLManager.registerEvent(new GriefPreventionListeners());
        }
    }

    public static void downloadFile(String fileURL, File saveFilePath) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            int bytesRead;
            InputStream inputStream = httpConn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
        } else {
            System.out.println("Error downloading libs. HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = rsp.getProvider();
        return true;
    }

    private Map<String, Map<String, Integer>> buildDistribution(int players) {
        HashMap<String, Map<String, Integer>> outer = new HashMap<String, Map<String, Integer>>();
        String outerBucket = this.outerBucket(players);
        String innerBucket = this.innerBucket(players);
        HashMap<String, Integer> inner = new HashMap<String, Integer>();
        inner.put(innerBucket, 1);
        outer.put(outerBucket, inner);
        return outer;
    }

    private String outerBucket(int n) {
        if (n <= 0) {
            return "0";
        }
        if (n <= 10) {
            return "1-10";
        }
        if (n <= 25) {
            return "11-25";
        }
        if (n <= 50) {
            return "26-50";
        }
        if (n <= 100) {
            return "51-100";
        }
        if (n <= 200) {
            return "101-200";
        }
        return "200+";
    }

    private String innerBucket(int n) {
        if (n <= 0) {
            return "0";
        }
        if (n <= 10) {
            return String.valueOf(n);
        }
        if (n <= 25) {
            return this.rangeOfFive(n, 11, 25);
        }
        if (n <= 50) {
            return this.rangeOfFive(n, 26, 50);
        }
        if (n <= 100) {
            return this.rangeOfFive(n, 51, 100);
        }
        if (n <= 200) {
            return this.rangeOfFive(n, 101, 200);
        }
        return "200+";
    }

    private String rangeOfFive(int n, int start, int end) {
        int bucketStart = (n - start) / 5 * 5 + start;
        int bucketEnd = Math.min(bucketStart + 4, end);
        return bucketStart + "-" + bucketEnd;
    }

    @NotNull
    public FileConfiguration getConfig() {
        if (configFileUtils == null) {
            File configFile = new File(this.getDataFolder(), "config.yml");
            configFileUtils = new FileUtils(configFile, "config.yml");
            configFileUtils.saveDefaultConfig();
            configFileUtils.reloadConfig(false);
        }
        return configFileUtils.getConfig();
    }

    public void saveDefaultConfig() {
        if (configFileUtils == null) {
            File configFile = new File(this.getDataFolder(), "config.yml");
            configFileUtils = new FileUtils(configFile, "config.yml");
        }
        configFileUtils.saveDefaultConfig();
    }

    public void reloadConfig() {
        if (configFileUtils == null) {
            File configFile = new File(this.getDataFolder(), "config.yml");
            configFileUtils = new FileUtils(configFile, "config.yml");
            configFileUtils.saveDefaultConfig();
        }
        configFileUtils.reloadConfig(false);
    }

    static {
        useGriefPrevention = false;
        usePlaceholderAPI = false;
        useWorldGuard = false;
        isWG7 = false;
        useVault = false;
        dataSource = null;
        type = database_type.SQLITE;
        mysqlDriver = null;
        mariadbDriver = null;
        h2Driver = null;
        needsUpdate = false;
    }
}

