/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.command;

import com.ollamachat.chat.ChatTriggerHandler;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OllamaChatCommand
implements CommandExecutor {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final ChatTriggerHandler chatTriggerHandler;

    public OllamaChatCommand(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.chatTriggerHandler = new ChatTriggerHandler(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("usage-ollamachat", null));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ollamachat.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                return true;
            }
            this.configManager.reloadConfigValues();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("reload-success", null));
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle") && args.length > 1) {
            if (!sender.hasPermission("ollamachat.toggle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                return true;
            }
            String aiName = args[1];
            if (aiName.equalsIgnoreCase("ollama")) {
                this.configManager.setOllamaEnabled(!this.configManager.isOllamaEnabled());
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage(this.configManager.isOllamaEnabled() ? "ollama-enabled" : "ollama-disabled", null));
            } else if (this.configManager.getOtherAIConfigs().containsKey(aiName)) {
                boolean newState = this.configManager.getOtherAIEnabled().getOrDefault(aiName, false) == false;
                this.configManager.getOtherAIEnabled().put(aiName, newState);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage(newState ? "toggle-enabled" : "toggle-disabled", Map.of("ai-name", aiName)));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("invalid-ai-name", Map.of("ai-list", String.join((CharSequence)", ", this.configManager.getOtherAIConfigs().keySet()))));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("prompt") && args.length > 1) {
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("set") && args.length > 3) {
                if (!sender.hasPermission("ollamachat.prompt.set")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String promptName = args[2];
                String promptContent = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
                this.plugin.getConfig().set("prompts." + promptName, (Object)promptContent);
                this.plugin.saveConfig();
                this.configManager.getPrompts().put(promptName, promptContent);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-set", Map.of("name", promptName)));
                return true;
            }
            if (subCommand.equals("delete") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.prompt.delete")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String promptName = args[2];
                if (this.configManager.getPrompts().containsKey(promptName)) {
                    this.plugin.getConfig().set("prompts." + promptName, null);
                    if (this.configManager.getDefaultPrompt().equals(promptName)) {
                        this.plugin.getConfig().set("default-prompt", (Object)"");
                        this.configManager.setDefaultPrompt("");
                    }
                    this.plugin.saveConfig();
                    this.configManager.getPrompts().remove(promptName);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-deleted", Map.of("name", promptName)));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("prompt-not-found", Map.of("name", promptName)));
                }
                return true;
            }
            if (subCommand.equals("list")) {
                if (!sender.hasPermission("ollamachat.prompt.list")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                if (this.configManager.getPrompts().isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-list-empty", null));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-list", Map.of("prompts", String.join((CharSequence)", ", this.configManager.getPrompts().keySet()))));
                }
                if (!this.configManager.getDefaultPrompt().isEmpty() && this.configManager.getPrompts().containsKey(this.configManager.getDefaultPrompt())) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-default", Map.of("name", this.configManager.getDefaultPrompt())));
                } else if (!this.configManager.getDefaultPrompt().isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("prompt-default-invalid", Map.of("name", this.configManager.getDefaultPrompt())));
                }
                return true;
            }
            if (subCommand.equals("select") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.prompt.select")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String promptName = args[2];
                if (this.configManager.getPrompts().containsKey(promptName)) {
                    this.plugin.getConfig().set("default-prompt", (Object)promptName);
                    this.plugin.saveConfig();
                    this.configManager.setDefaultPrompt(promptName);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-selected", Map.of("name", promptName)));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("prompt-not-found", Map.of("name", promptName)));
                }
                return true;
            }
            if (subCommand.equals("clear")) {
                if (!sender.hasPermission("ollamachat.prompt.select")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                this.plugin.getConfig().set("default-prompt", (Object)"");
                this.plugin.saveConfig();
                this.configManager.setDefaultPrompt("");
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("prompt-cleared", null));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("prompt-usage", null));
            return true;
        }
        if (args[0].equalsIgnoreCase("conversation") && args.length > 1) {
            String aiName;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("player-only", null));
                return true;
            }
            Player player = (Player)sender;
            String subCommand = args[1].toLowerCase();
            String string = aiName = args.length > 2 ? args[2] : "ollama";
            if (!aiName.equals("ollama") && !this.configManager.getOtherAIConfigs().containsKey(aiName)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("invalid-ai-name", Map.of("ai-list", String.join((CharSequence)", ", this.configManager.getOtherAIConfigs().keySet()))));
                return true;
            }
            if (subCommand.equals("new") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.new")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String convName = args[3];
                String convId = this.plugin.getChatHistoryManager().createConversation(player.getUniqueId(), aiName, convName);
                this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(aiName, convName);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-created", Map.of("name", convName, "ai-name", aiName)));
                return true;
            }
            if (subCommand.equals("select") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.select")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String convName = args[3];
                if (this.plugin.getChatHistoryManager().conversationExistsByName(player.getUniqueId(), aiName, convName)) {
                    this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(aiName, convName);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-selected", Map.of("name", convName, "ai-name", aiName)));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("conversation-not-found", Map.of("name", convName)));
                }
                return true;
            }
            if (subCommand.equals("delete") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.delete")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                String convName = args[3];
                String convId = this.plugin.getChatHistoryManager().getConversationId(player.getUniqueId(), aiName, convName);
                if (convId != null && this.plugin.getChatHistoryManager().deleteConversation(player.getUniqueId(), aiName, convId)) {
                    Map<String, String> convMap = this.configManager.getSelectedConversations().get(player.getUniqueId());
                    if (convMap != null && convName.equals(convMap.get(aiName))) {
                        convMap.remove(aiName);
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-deleted", Map.of("name", convName, "ai-name", aiName)));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("conversation-not-found", Map.of("name", convName)));
                }
                return true;
            }
            if (subCommand.equals("list") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.conversation.list")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                    return true;
                }
                Map<String, String> conversations = this.plugin.getChatHistoryManager().listConversations(player.getUniqueId(), aiName);
                if (conversations.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-list-empty", Map.of("ai-name", aiName)));
                } else {
                    String convList = String.join((CharSequence)", ", conversations.values());
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-list", Map.of("conversations", convList, "ai-name", aiName)));
                }
                String selectedConv = (String)this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).get(aiName);
                if (selectedConv != null && conversations.containsValue(selectedConv)) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("conversation-default", Map.of("name", selectedConv, "ai-name", aiName)));
                } else if (selectedConv != null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("conversation-default-invalid", Map.of("name", selectedConv, "ai-name", aiName)));
                }
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("conversation-usage", null));
            return true;
        }
        if (args[0].equalsIgnoreCase("suggests") && args.length == 2) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("player-only", null));
                return true;
            }
            if (!sender.hasPermission("ollamachat.suggests.toggle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                return true;
            }
            Player player = (Player)sender;
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("on")) {
                this.plugin.getSuggestedResponseHandler().toggleSuggestionsForPlayer(player, true);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("suggests-enabled", Map.of("player", player.getName())));
                return true;
            }
            if (subCommand.equals("off")) {
                this.plugin.getSuggestedResponseHandler().toggleSuggestionsForPlayer(player, false);
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("suggests-disabled", Map.of("player", player.getName())));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("usage-ollamachat", null));
            return true;
        }
        if (args[0].equalsIgnoreCase("suggests-presets") && args.length == 2) {
            if (!sender.hasPermission("ollamachat.suggests-presets.toggle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("no-permission", null));
                return true;
            }
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("on")) {
                this.configManager.setSuggestedResponsePresetsEnabled(true);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.configManager.getMessage("suggests-presets-enabled", null));
                return true;
            }
            if (subCommand.equals("off")) {
                this.configManager.setSuggestedResponsePresetsEnabled(false);
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.configManager.getMessage("suggests-presets-disabled", null));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("usage-ollamachat", null));
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.configManager.getMessage("usage-ollamachat", null));
        return true;
    }
}

