/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ollamachat.AIService;
import com.ollamachat.ChatHistoryManager;
import com.ollamachat.api.OllamaChatAPI;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;

public class OllamaChatAPIImpl
implements OllamaChatAPI {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final ChatHistoryManager chatHistoryManager;
    private final AIService aiService;
    private final Gson gson;

    public OllamaChatAPIImpl(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.chatHistoryManager = plugin.getChatHistoryManager();
        this.aiService = new AIService();
        this.gson = new Gson();
    }

    @Override
    public CompletableFuture<String> sendAIQuery(Player player, String aiName, String prompt) {
        if (!aiName.equalsIgnoreCase("ollama") && !this.configManager.getOtherAIEnabled().getOrDefault(aiName, false).booleanValue()) {
            return CompletableFuture.completedFuture("Error: AI model " + aiName + " is disabled.");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                String finalResponse;
                boolean isMessagesFormat;
                String model;
                String apiKey;
                String apiUrl;
                UUID playerUuid = player.getUniqueId();
                this.chatHistoryManager.savePlayerInfo(player);
                String conversationName = this.configManager.getSelectedConversations().computeIfAbsent(playerUuid, k -> new HashMap()).getOrDefault(aiName, null);
                String conversationId = conversationName != null ? this.chatHistoryManager.getConversationId(playerUuid, aiName, conversationName) : null;
                String history = this.chatHistoryManager.getChatHistory(playerUuid, aiName, conversationId, this.configManager.getMaxHistory());
                String selectedPrompt = this.configManager.getPrompts().getOrDefault(this.configManager.getDefaultPrompt(), "");
                String context = history + (String)(selectedPrompt.isEmpty() ? "" : selectedPrompt + "\n") + "User: " + prompt;
                if (aiName.equalsIgnoreCase("ollama")) {
                    apiUrl = this.configManager.getOllamaApiUrl();
                    apiKey = null;
                    model = this.configManager.getOllamaModel();
                    isMessagesFormat = false;
                } else {
                    ConfigManager.AIConfig aiConfig = this.configManager.getOtherAIConfigs().get(aiName);
                    apiUrl = aiConfig.getApiUrl();
                    apiKey = aiConfig.getApiKey();
                    model = aiConfig.getModel();
                    isMessagesFormat = aiConfig.isMessagesFormat();
                }
                String responseBody = this.aiService.sendRequest(apiUrl, apiKey, model, context, isMessagesFormat).join();
                if (isMessagesFormat) {
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    finalResponse = json.getAsJsonArray("choices").get(0).getAsJsonObject().get("message").getAsJsonObject().get("content").getAsString();
                } else {
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    finalResponse = json.get("response").getAsString();
                }
                if (!finalResponse.isEmpty()) {
                    this.chatHistoryManager.saveChatHistory(playerUuid, aiName, conversationId, prompt, finalResponse);
                }
                return finalResponse.length() > this.configManager.getMaxResponseLength() ? finalResponse.substring(0, this.configManager.getMaxResponseLength()) + "..." : finalResponse;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing API " + aiName + " request: " + e.getMessage());
                return "Error: Failed to get response from " + aiName;
            }
        });
    }

    @Override
    public String createConversation(UUID playerUuid, String aiModel, String convName) {
        return this.chatHistoryManager.createConversation(playerUuid, aiModel, convName);
    }

    @Override
    public boolean conversationExistsByName(UUID playerUuid, String aiModel, String convName) {
        return this.chatHistoryManager.conversationExistsByName(playerUuid, aiModel, convName);
    }

    @Override
    public String getConversationId(UUID playerUuid, String aiModel, String convName) {
        return this.chatHistoryManager.getConversationId(playerUuid, aiModel, convName);
    }

    @Override
    public boolean deleteConversation(UUID playerUuid, String aiModel, String convId) {
        return this.chatHistoryManager.deleteConversation(playerUuid, aiModel, convId);
    }

    @Override
    public Map<String, String> listConversations(UUID playerUuid, String aiModel) {
        return this.chatHistoryManager.listConversations(playerUuid, aiModel);
    }

    @Override
    public void saveChatHistory(UUID playerUuid, String aiModel, String conversationId, String prompt, String response) {
        this.chatHistoryManager.saveChatHistory(playerUuid, aiModel, conversationId, prompt, response);
    }

    @Override
    public String getChatHistory(UUID playerUuid, String aiModel, String conversationId) {
        return this.chatHistoryManager.getChatHistory(playerUuid, aiModel, conversationId, this.configManager.getMaxHistory());
    }

    @Override
    public int getMaxHistory() {
        return this.configManager.getMaxHistory();
    }
}

