/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class DependencyLoader {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final File libDir;

    public DependencyLoader(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.libDir = new File(plugin.getDataFolder(), "libs");
    }

    public boolean loadDependencies() {
        try {
            if (!this.libDir.exists() && !this.libDir.mkdirs()) {
                this.logger.severe("Failed to create libs directory: " + this.libDir.getAbsolutePath());
                return false;
            }
            List<Dependency> dependencies = List.of(new Dependency("com.mysql", "mysql-connector-j", "8.0.33"), new Dependency("org.xerial", "sqlite-jdbc", "3.46.0.0"), new Dependency("com.zaxxer", "HikariCP", "5.1.0"));
            int loadedCount = 0;
            for (Dependency dep : dependencies) {
                File jarFile = this.downloadDependency(dep);
                if (jarFile != null && this.injectToPluginClassLoader(jarFile)) {
                    ++loadedCount;
                    this.logger.info("Loaded dependency: " + jarFile.getName());
                    continue;
                }
                this.logger.warning("Failed to load dependency: " + dep.artifactId);
            }
            this.logger.info("Successfully loaded " + loadedCount + " dependencies.");
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Failed to load dependencies: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private File downloadDependency(Dependency dep) {
        File file;
        block9: {
            String fileName = dep.artifactId + "-" + dep.version + ".jar";
            File file2 = new File(this.libDir, fileName);
            if (file2.exists()) {
                return file2;
            }
            String mavenPath = String.format("%s/%s/%s/%s-%s.jar", dep.groupId.replace(".", "/"), dep.artifactId, dep.version, dep.artifactId, dep.version);
            String url = "https://repo1.maven.org/maven2/" + mavenPath;
            this.logger.info("Downloading dependency: " + fileName + " from " + url);
            InputStream in = new URL(url).openStream();
            try {
                Path temp = Files.createTempFile(this.libDir.toPath(), dep.artifactId, ".tmp", new FileAttribute[0]);
                Files.copy(in, temp, StandardCopyOption.REPLACE_EXISTING);
                Files.move(temp, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info("Downloaded dependency: " + fileName);
                file = file2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.severe("Failed to download " + fileName + ": " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return file;
    }

    private boolean injectToPluginClassLoader(File jarFile) {
        try {
            ClassLoader pluginClassLoader = this.plugin.getClass().getClassLoader();
            Method addURLMethod = null;
            for (Class<?> current = pluginClassLoader.getClass(); current != null && addURLMethod == null; current = current.getSuperclass()) {
                try {
                    addURLMethod = current.getDeclaredMethod("addURL", URL.class);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (addURLMethod == null) {
                this.logger.severe("Unable to find addURL method in plugin classloader. Injection failed.");
                return false;
            }
            addURLMethod.setAccessible(true);
            addURLMethod.invoke((Object)pluginClassLoader, jarFile.toURI().toURL());
            this.logger.info("Injected dependency into classloader: " + jarFile.getName());
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Failed to inject dependency " + jarFile.getName() + ": " + e.getMessage());
            return false;
        }
    }

    private static class Dependency {
        String groupId;
        String artifactId;
        String version;

        Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

